/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.PhrasePositions;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

abstract class PhraseScorer
extends Scorer {
    protected byte[] norms;
    protected float value;
    PhrasePositions min;
    PhrasePositions max;
    private float freq;

    PhraseScorer(Weight weight, PhraseQuery.PostingsAndFreq[] postingsAndFreqArray, Similarity similarity, byte[] byArray) {
        super(similarity, weight);
        this.norms = byArray;
        this.value = weight.getValue();
        if (postingsAndFreqArray.length > 0) {
            this.max = this.min = new PhrasePositions(postingsAndFreqArray[0].postings, postingsAndFreqArray[0].position, 0);
            this.max.doc = -1;
            for (int i = 1; i < postingsAndFreqArray.length; ++i) {
                PhrasePositions phrasePositions;
                this.max.next = phrasePositions = new PhrasePositions(postingsAndFreqArray[i].postings, postingsAndFreqArray[i].position, i);
                this.max = phrasePositions;
                this.max.doc = -1;
            }
            this.max.next = this.min;
        }
    }

    @Override
    public int docID() {
        return this.max.doc;
    }

    @Override
    public int nextDoc() throws IOException {
        return this.advance(this.max.doc);
    }

    private boolean advanceMin(int n) throws IOException {
        if (!this.min.skipTo(n)) {
            this.max.doc = Integer.MAX_VALUE;
            return false;
        }
        this.min = this.min.next;
        this.max = this.max.next;
        return true;
    }

    @Override
    public float score() throws IOException {
        float f = this.getSimilarity().tf(this.freq) * this.value;
        return this.norms == null ? f : f * this.getSimilarity().decodeNormValue(this.norms[this.max.doc]);
    }

    @Override
    public int advance(int n) throws IOException {
        this.freq = 0.0f;
        if (!this.advanceMin(n)) {
            return Integer.MAX_VALUE;
        }
        boolean bl = false;
        while (this.freq == 0.0f) {
            while (this.min.doc < this.max.doc || bl) {
                bl = false;
                if (this.advanceMin(this.max.doc)) continue;
                return Integer.MAX_VALUE;
            }
            this.freq = this.phraseFreq();
            bl = true;
        }
        return this.max.doc;
    }

    @Override
    public final float freq() {
        return this.freq;
    }

    abstract float phraseFreq() throws IOException;

    public String toString() {
        return "scorer(" + this.weight + ")";
    }
}

