/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;

public class NGramPhraseQuery
extends PhraseQuery {
    private final int n;

    public NGramPhraseQuery(int n) {
        this.n = n;
    }

    @Override
    public Query rewrite(IndexReader indexReader) throws IOException {
        int n;
        if (this.getSlop() != 0) {
            return super.rewrite(indexReader);
        }
        if (this.n < 2 || this.getTerms().length < 3) {
            return super.rewrite(indexReader);
        }
        int[] nArray = this.getPositions();
        Term[] termArray = this.getTerms();
        int n2 = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            n = nArray[i];
            if (n2 + 1 != n) {
                return super.rewrite(indexReader);
            }
            n2 = n;
        }
        PhraseQuery phraseQuery = new PhraseQuery();
        n = 0;
        int n3 = termArray.length - 1;
        for (int i = 0; i < termArray.length; ++i) {
            if (n % this.n == 0 || n >= n3) {
                phraseQuery.add(termArray[i], nArray[i]);
            }
            ++n;
        }
        return phraseQuery;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof NGramPhraseQuery)) {
            return false;
        }
        NGramPhraseQuery nGramPhraseQuery = (NGramPhraseQuery)object;
        if (this.n != nGramPhraseQuery.n) {
            return false;
        }
        return super.equals(nGramPhraseQuery);
    }

    @Override
    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.getSlop() ^ this.getTerms().hashCode() ^ this.getPositions().hashCode() ^ this.n;
    }
}

