/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class FilteredQuery
extends Query {
    Query query;
    Filter filter;

    public FilteredQuery(Query query, Filter filter) {
        this.query = query;
        this.filter = filter;
    }

    @Override
    public Weight createWeight(Searcher searcher) throws IOException {
        final Weight weight = this.query.createWeight(searcher);
        final Similarity similarity = this.query.getSimilarity(searcher);
        return new Weight(){
            private float value;

            @Override
            public float getValue() {
                return this.value;
            }

            @Override
            public boolean scoresDocsOutOfOrder() {
                return false;
            }

            @Override
            public float sumOfSquaredWeights() throws IOException {
                return weight.sumOfSquaredWeights() * FilteredQuery.this.getBoost() * FilteredQuery.this.getBoost();
            }

            @Override
            public void normalize(float f) {
                weight.normalize(f * FilteredQuery.this.getBoost());
                this.value = weight.getValue();
            }

            @Override
            public Explanation explain(IndexReader indexReader, int n) throws IOException {
                DocIdSetIterator docIdSetIterator;
                Explanation explanation = weight.explain(indexReader, n);
                Filter filter = FilteredQuery.this.filter;
                DocIdSet docIdSet = filter.getDocIdSet(indexReader);
                DocIdSetIterator docIdSetIterator2 = docIdSetIterator = docIdSet == null ? DocIdSet.EMPTY_DOCIDSET.iterator() : docIdSet.iterator();
                if (docIdSetIterator == null) {
                    docIdSetIterator = DocIdSet.EMPTY_DOCIDSET.iterator();
                }
                if (docIdSetIterator.advance(n) == n) {
                    return explanation;
                }
                Explanation explanation2 = new Explanation(0.0f, "failure to match filter: " + filter.toString());
                explanation2.addDetail(explanation);
                return explanation2;
            }

            @Override
            public Query getQuery() {
                return FilteredQuery.this;
            }

            @Override
            public Scorer scorer(IndexReader indexReader, boolean bl, boolean bl2) throws IOException {
                return FilteredQuery.getFilteredScorer(indexReader, similarity, weight, this, FilteredQuery.this.filter);
            }
        };
    }

    static Scorer getFilteredScorer(IndexReader indexReader, Similarity similarity, Weight weight, Weight weight2, Filter filter) throws IOException {
        assert (filter != null);
        DocIdSet docIdSet = filter.getDocIdSet(indexReader);
        if (docIdSet == null) {
            return null;
        }
        final DocIdSetIterator docIdSetIterator = docIdSet.iterator();
        if (docIdSetIterator == null) {
            return null;
        }
        final Scorer scorer = weight.scorer(indexReader, true, false);
        return scorer == null ? null : new Scorer(similarity, weight2){
            private int scorerDoc;
            private int filterDoc;
            {
                super(similarity, weight);
                this.scorerDoc = -1;
                this.filterDoc = -1;
            }

            @Override
            public void score(Collector collector) throws IOException {
                int n = docIdSetIterator.nextDoc();
                int n2 = scorer.advance(n);
                collector.setScorer(scorer);
                while (true) {
                    if (n2 == n) {
                        if (n2 == Integer.MAX_VALUE) break;
                        collector.collect(n2);
                        n = docIdSetIterator.nextDoc();
                        n2 = scorer.advance(n);
                        continue;
                    }
                    if (n2 > n) {
                        n = docIdSetIterator.advance(n2);
                        continue;
                    }
                    n2 = scorer.advance(n);
                }
            }

            private int advanceToNextCommonDoc() throws IOException {
                while (true) {
                    if (this.scorerDoc < this.filterDoc) {
                        this.scorerDoc = scorer.advance(this.filterDoc);
                        continue;
                    }
                    if (this.scorerDoc == this.filterDoc) {
                        return this.scorerDoc;
                    }
                    this.filterDoc = docIdSetIterator.advance(this.scorerDoc);
                }
            }

            @Override
            public int nextDoc() throws IOException {
                this.filterDoc = docIdSetIterator.nextDoc();
                return this.advanceToNextCommonDoc();
            }

            @Override
            public int advance(int n) throws IOException {
                if (n > this.filterDoc) {
                    this.filterDoc = docIdSetIterator.advance(n);
                }
                return this.advanceToNextCommonDoc();
            }

            @Override
            public int docID() {
                return this.scorerDoc;
            }

            @Override
            public float score() throws IOException {
                return scorer.score();
            }
        };
    }

    @Override
    public Query rewrite(IndexReader indexReader) throws IOException {
        Query query = this.query.rewrite(indexReader);
        if (query != this.query) {
            FilteredQuery filteredQuery = (FilteredQuery)this.clone();
            filteredQuery.query = query;
            return filteredQuery;
        }
        return this;
    }

    public Query getQuery() {
        return this.query;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void extractTerms(Set<Term> set) {
        this.getQuery().extractTerms(set);
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("filtered(");
        stringBuilder.append(this.query.toString(string));
        stringBuilder.append(")->");
        stringBuilder.append(this.filter);
        stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof FilteredQuery) {
            FilteredQuery filteredQuery = (FilteredQuery)object;
            return this.query.equals(filteredQuery.query) && this.filter.equals(filteredQuery.filter) && this.getBoost() == filteredQuery.getBoost();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.query.hashCode() ^ this.filter.hashCode() + Float.floatToRawIntBits(this.getBoost());
    }
}

