/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.Serializable;
import java.util.ArrayList;

public class Explanation
implements Serializable {
    private float value;
    private String description;
    private ArrayList<Explanation> details;

    public Explanation() {
    }

    public Explanation(float f, String string) {
        this.value = f;
        this.description = string;
    }

    public boolean isMatch() {
        return 0.0f < this.getValue();
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float f) {
        this.value = f;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    protected String getSummary() {
        return this.getValue() + " = " + this.getDescription();
    }

    public Explanation[] getDetails() {
        if (this.details == null) {
            return null;
        }
        return this.details.toArray(new Explanation[0]);
    }

    public void addDetail(Explanation explanation) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        this.details.add(explanation);
    }

    public String toString() {
        return this.toString(0);
    }

    protected String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
        stringBuilder.append(this.getSummary());
        stringBuilder.append("\n");
        Explanation[] explanationArray = this.getDetails();
        if (explanationArray != null) {
            for (int i = 0; i < explanationArray.length; ++i) {
                stringBuilder.append(explanationArray[i].toString(n + 1));
            }
        }
        return stringBuilder.toString();
    }

    public String toHtml() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<ul>\n");
        stringBuilder.append("<li>");
        stringBuilder.append(this.getSummary());
        stringBuilder.append("<br />\n");
        Explanation[] explanationArray = this.getDetails();
        if (explanationArray != null) {
            for (int i = 0; i < explanationArray.length; ++i) {
                stringBuilder.append(explanationArray[i].toHtml());
            }
        }
        stringBuilder.append("</li>\n");
        stringBuilder.append("</ul>\n");
        return stringBuilder.toString();
    }

    public static abstract class IDFExplanation
    implements Serializable {
        public abstract float getIdf();

        public abstract String explain();
    }
}

