/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermCollectingRewrite;
import org.apache.lucene.search.TermQuery;

class ConstantScoreAutoRewrite
extends TermCollectingRewrite<BooleanQuery> {
    public static int DEFAULT_TERM_COUNT_CUTOFF = 350;
    public static double DEFAULT_DOC_COUNT_PERCENT = 0.1;
    private int termCountCutoff = DEFAULT_TERM_COUNT_CUTOFF;
    private double docCountPercent = DEFAULT_DOC_COUNT_PERCENT;

    ConstantScoreAutoRewrite() {
    }

    public void setTermCountCutoff(int n) {
        this.termCountCutoff = n;
    }

    public int getTermCountCutoff() {
        return this.termCountCutoff;
    }

    public void setDocCountPercent(double d) {
        this.docCountPercent = d;
    }

    public double getDocCountPercent() {
        return this.docCountPercent;
    }

    @Override
    protected BooleanQuery getTopLevelQuery() {
        return new BooleanQuery(true);
    }

    @Override
    protected void addClause(BooleanQuery booleanQuery, Term term, float f) {
        booleanQuery.add(new TermQuery(term), BooleanClause.Occur.SHOULD);
    }

    @Override
    public Query rewrite(IndexReader indexReader, MultiTermQuery multiTermQuery) throws IOException {
        Query query;
        int n = (int)(this.docCountPercent / 100.0 * (double)indexReader.maxDoc());
        int n2 = Math.min(BooleanQuery.getMaxClauseCount(), this.termCountCutoff);
        CutOffTermCollector cutOffTermCollector = new CutOffTermCollector(indexReader, n, n2);
        this.collectTerms(indexReader, multiTermQuery, cutOffTermCollector);
        if (cutOffTermCollector.hasCutOff) {
            return MultiTermQuery.CONSTANT_SCORE_FILTER_REWRITE.rewrite(indexReader, multiTermQuery);
        }
        if (cutOffTermCollector.pendingTerms.isEmpty()) {
            query = this.getTopLevelQuery();
        } else {
            BooleanQuery booleanQuery = this.getTopLevelQuery();
            for (Term term : cutOffTermCollector.pendingTerms) {
                this.addClause(booleanQuery, term, 1.0f);
            }
            query = new ConstantScoreQuery(booleanQuery);
            query.setBoost(multiTermQuery.getBoost());
        }
        multiTermQuery.incTotalNumberOfTerms(cutOffTermCollector.pendingTerms.size());
        return query;
    }

    public int hashCode() {
        return (int)((long)(1279 * this.termCountCutoff) + Double.doubleToLongBits(this.docCountPercent));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ConstantScoreAutoRewrite constantScoreAutoRewrite = (ConstantScoreAutoRewrite)object;
        if (constantScoreAutoRewrite.termCountCutoff != this.termCountCutoff) {
            return false;
        }
        return Double.doubleToLongBits(constantScoreAutoRewrite.docCountPercent) == Double.doubleToLongBits(this.docCountPercent);
    }

    private static final class CutOffTermCollector
    implements TermCollectingRewrite.TermCollector {
        int docVisitCount = 0;
        boolean hasCutOff = false;
        final IndexReader reader;
        final int docCountCutoff;
        final int termCountLimit;
        final ArrayList<Term> pendingTerms = new ArrayList();

        CutOffTermCollector(IndexReader indexReader, int n, int n2) {
            this.reader = indexReader;
            this.docCountCutoff = n;
            this.termCountLimit = n2;
        }

        @Override
        public boolean collect(Term term, float f) throws IOException {
            this.pendingTerms.add(term);
            this.docVisitCount += this.reader.docFreq(term);
            if (this.pendingTerms.size() >= this.termCountLimit || this.docVisitCount >= this.docCountCutoff) {
                this.hasCutOff = true;
                return false;
            }
            return true;
        }
    }
}

