/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;

class ConjunctionScorer
extends Scorer {
    private final Scorer[] scorers;
    private final float coord;
    private int lastDoc = -1;

    public ConjunctionScorer(Weight weight, float f, Collection<Scorer> collection) throws IOException {
        this(weight, f, collection.toArray(new Scorer[collection.size()]));
    }

    public ConjunctionScorer(Weight weight, float f, Scorer ... scorerArray) throws IOException {
        super(weight);
        int n;
        this.scorers = scorerArray;
        this.coord = f;
        for (n = 0; n < scorerArray.length; ++n) {
            if (scorerArray[n].nextDoc() != Integer.MAX_VALUE) continue;
            this.lastDoc = Integer.MAX_VALUE;
            return;
        }
        ArrayUtil.mergeSort(scorerArray, new Comparator<Scorer>(){

            @Override
            public int compare(Scorer scorer, Scorer scorer2) {
                return scorer.docID() - scorer2.docID();
            }
        });
        if (this.doNext() == Integer.MAX_VALUE) {
            this.lastDoc = Integer.MAX_VALUE;
            return;
        }
        n = scorerArray.length - 1;
        int n2 = n >> 1;
        for (int i = 0; i < n2; ++i) {
            Scorer scorer = scorerArray[i];
            int n3 = n - i - 1;
            scorerArray[i] = scorerArray[n3];
            scorerArray[n3] = scorer;
        }
    }

    private int doNext() throws IOException {
        Scorer scorer;
        int n = 0;
        int n2 = this.scorers[this.scorers.length - 1].docID();
        while ((scorer = this.scorers[n]).docID() < n2) {
            n2 = scorer.advance(n2);
            n = n == this.scorers.length - 1 ? 0 : n + 1;
        }
        return n2;
    }

    @Override
    public int advance(int n) throws IOException {
        if (this.lastDoc == Integer.MAX_VALUE) {
            return this.lastDoc;
        }
        if (this.scorers[this.scorers.length - 1].docID() < n) {
            this.scorers[this.scorers.length - 1].advance(n);
        }
        this.lastDoc = this.doNext();
        return this.lastDoc;
    }

    @Override
    public int docID() {
        return this.lastDoc;
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.lastDoc == Integer.MAX_VALUE) {
            return this.lastDoc;
        }
        if (this.lastDoc == -1) {
            this.lastDoc = this.scorers[this.scorers.length - 1].docID();
            return this.lastDoc;
        }
        this.scorers[this.scorers.length - 1].nextDoc();
        this.lastDoc = this.doNext();
        return this.lastDoc;
    }

    @Override
    public float score() throws IOException {
        float f = 0.0f;
        for (int i = 0; i < this.scorers.length; ++i) {
            f += this.scorers[i].score();
        }
        return f * this.coord;
    }
}

