/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser;

import java.io.IOException;
import java.io.StringReader;
import java.text.Collator;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.CharStream;
import org.apache.lucene.queryParser.FastCharStream;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParserConstants;
import org.apache.lucene.queryParser.QueryParserTokenManager;
import org.apache.lucene.queryParser.Token;
import org.apache.lucene.queryParser.TokenMgrError;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.Version;
import org.apache.lucene.util.VirtualMethod;

public class QueryParser
implements QueryParserConstants {
    private static final int CONJ_NONE = 0;
    private static final int CONJ_AND = 1;
    private static final int CONJ_OR = 2;
    private static final int MOD_NONE = 0;
    private static final int MOD_NOT = 10;
    private static final int MOD_REQ = 11;
    public static final Operator AND_OPERATOR = Operator.AND;
    public static final Operator OR_OPERATOR = Operator.OR;
    private Operator operator = OR_OPERATOR;
    boolean lowercaseExpandedTerms = true;
    MultiTermQuery.RewriteMethod multiTermRewriteMethod = MultiTermQuery.CONSTANT_SCORE_AUTO_REWRITE_DEFAULT;
    boolean allowLeadingWildcard = false;
    boolean enablePositionIncrements = true;
    Analyzer analyzer;
    String field;
    int phraseSlop = 0;
    float fuzzyMinSim = 0.5f;
    int fuzzyPrefixLength = 0;
    Locale locale = Locale.getDefault();
    DateTools.Resolution dateResolution = null;
    Map<String, DateTools.Resolution> fieldToDateResolution = null;
    Collator rangeCollator = null;
    @Deprecated
    private static final VirtualMethod<QueryParser> getFieldQueryMethod = new VirtualMethod<QueryParser>(QueryParser.class, "getFieldQuery", String.class, String.class);
    @Deprecated
    private static final VirtualMethod<QueryParser> getFieldQueryWithQuotedMethod = new VirtualMethod<QueryParser>(QueryParser.class, "getFieldQuery", String.class, String.class, Boolean.TYPE);
    @Deprecated
    private final boolean hasNewAPI = VirtualMethod.compareImplementationDistance(this.getClass(), getFieldQueryWithQuotedMethod, getFieldQueryMethod) >= 0;
    private boolean autoGeneratePhraseQueries;
    public QueryParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[23];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public QueryParser(Version version, String string, Analyzer analyzer) {
        this(new FastCharStream(new StringReader("")));
        this.analyzer = analyzer;
        this.field = string;
        this.enablePositionIncrements = version.onOrAfter(Version.LUCENE_29);
        if (version.onOrAfter(Version.LUCENE_31)) {
            this.setAutoGeneratePhraseQueries(false);
        } else {
            this.setAutoGeneratePhraseQueries(true);
        }
    }

    public Query parse(String string) throws ParseException {
        this.ReInit(new FastCharStream(new StringReader(string)));
        try {
            Query query = this.TopLevelQuery(this.field);
            return query != null ? query : this.newBooleanQuery(false);
        }
        catch (ParseException parseException) {
            ParseException parseException2 = new ParseException("Cannot parse '" + string + "': " + parseException.getMessage());
            parseException2.initCause(parseException);
            throw parseException2;
        }
        catch (TokenMgrError tokenMgrError) {
            ParseException parseException = new ParseException("Cannot parse '" + string + "': " + tokenMgrError.getMessage());
            parseException.initCause(tokenMgrError);
            throw parseException;
        }
        catch (BooleanQuery.TooManyClauses tooManyClauses) {
            ParseException parseException = new ParseException("Cannot parse '" + string + "': too many boolean clauses");
            parseException.initCause(tooManyClauses);
            throw parseException;
        }
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public String getField() {
        return this.field;
    }

    public final boolean getAutoGeneratePhraseQueries() {
        return this.autoGeneratePhraseQueries;
    }

    public final void setAutoGeneratePhraseQueries(boolean bl) {
        if (!bl && !this.hasNewAPI) {
            throw new IllegalArgumentException("You must implement the new API: getFieldQuery(String,String,boolean) to use setAutoGeneratePhraseQueries(false)");
        }
        this.autoGeneratePhraseQueries = bl;
    }

    public float getFuzzyMinSim() {
        return this.fuzzyMinSim;
    }

    public void setFuzzyMinSim(float f) {
        this.fuzzyMinSim = f;
    }

    public int getFuzzyPrefixLength() {
        return this.fuzzyPrefixLength;
    }

    public void setFuzzyPrefixLength(int n) {
        this.fuzzyPrefixLength = n;
    }

    public void setPhraseSlop(int n) {
        this.phraseSlop = n;
    }

    public int getPhraseSlop() {
        return this.phraseSlop;
    }

    public void setAllowLeadingWildcard(boolean bl) {
        this.allowLeadingWildcard = bl;
    }

    public boolean getAllowLeadingWildcard() {
        return this.allowLeadingWildcard;
    }

    public void setEnablePositionIncrements(boolean bl) {
        this.enablePositionIncrements = bl;
    }

    public boolean getEnablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public void setDefaultOperator(Operator operator) {
        this.operator = operator;
    }

    public Operator getDefaultOperator() {
        return this.operator;
    }

    public void setLowercaseExpandedTerms(boolean bl) {
        this.lowercaseExpandedTerms = bl;
    }

    public boolean getLowercaseExpandedTerms() {
        return this.lowercaseExpandedTerms;
    }

    public void setMultiTermRewriteMethod(MultiTermQuery.RewriteMethod rewriteMethod) {
        this.multiTermRewriteMethod = rewriteMethod;
    }

    public MultiTermQuery.RewriteMethod getMultiTermRewriteMethod() {
        return this.multiTermRewriteMethod;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setDateResolution(DateTools.Resolution resolution) {
        this.dateResolution = resolution;
    }

    public void setDateResolution(String string, DateTools.Resolution resolution) {
        if (string == null) {
            throw new IllegalArgumentException("Field cannot be null.");
        }
        if (this.fieldToDateResolution == null) {
            this.fieldToDateResolution = new HashMap<String, DateTools.Resolution>();
        }
        this.fieldToDateResolution.put(string, resolution);
    }

    public DateTools.Resolution getDateResolution(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Field cannot be null.");
        }
        if (this.fieldToDateResolution == null) {
            return this.dateResolution;
        }
        DateTools.Resolution resolution = this.fieldToDateResolution.get(string);
        if (resolution == null) {
            resolution = this.dateResolution;
        }
        return resolution;
    }

    public void setRangeCollator(Collator collator) {
        this.rangeCollator = collator;
    }

    public Collator getRangeCollator() {
        return this.rangeCollator;
    }

    protected void addClause(List<BooleanClause> list, int n, int n2, Query query) {
        boolean bl;
        boolean bl2;
        BooleanClause booleanClause;
        if (list.size() > 0 && n == 1 && !(booleanClause = list.get(list.size() - 1)).isProhibited()) {
            booleanClause.setOccur(BooleanClause.Occur.MUST);
        }
        if (list.size() > 0 && this.operator == AND_OPERATOR && n == 2 && !(booleanClause = list.get(list.size() - 1)).isProhibited()) {
            booleanClause.setOccur(BooleanClause.Occur.SHOULD);
        }
        if (query == null) {
            return;
        }
        if (this.operator == OR_OPERATOR) {
            bl2 = n2 == 10;
            boolean bl3 = bl = n2 == 11;
            if (n == 1 && !bl2) {
                bl = true;
            }
        } else {
            bl2 = n2 == 10;
            boolean bl4 = bl = !bl2 && n != 2;
        }
        if (bl && !bl2) {
            list.add(this.newBooleanClause(query, BooleanClause.Occur.MUST));
        } else if (!bl && !bl2) {
            list.add(this.newBooleanClause(query, BooleanClause.Occur.SHOULD));
        } else if (!bl && bl2) {
            list.add(this.newBooleanClause(query, BooleanClause.Occur.MUST_NOT));
        } else {
            throw new RuntimeException("Clause cannot be both required and prohibited");
        }
    }

    @Deprecated
    protected Query getFieldQuery(String string, String string2) throws ParseException {
        return this.getFieldQuery(string, string2, true);
    }

    protected Query getFieldQuery(String string, String string2, boolean bl) throws ParseException {
        TokenStream tokenStream;
        try {
            tokenStream = this.analyzer.reusableTokenStream(string, new StringReader(string2));
            tokenStream.reset();
        }
        catch (IOException iOException) {
            tokenStream = this.analyzer.tokenStream(string, new StringReader(string2));
        }
        CachingTokenFilter cachingTokenFilter = new CachingTokenFilter(tokenStream);
        CharTermAttribute charTermAttribute = null;
        PositionIncrementAttribute positionIncrementAttribute = null;
        int n = 0;
        boolean bl2 = false;
        try {
            cachingTokenFilter.reset();
            bl2 = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl2) {
            if (cachingTokenFilter.hasAttribute(CharTermAttribute.class)) {
                charTermAttribute = cachingTokenFilter.getAttribute(CharTermAttribute.class);
            }
            if (cachingTokenFilter.hasAttribute(PositionIncrementAttribute.class)) {
                positionIncrementAttribute = cachingTokenFilter.getAttribute(PositionIncrementAttribute.class);
            }
        }
        int n2 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        if (charTermAttribute != null) {
            try {
                bl4 = cachingTokenFilter.incrementToken();
                while (bl4) {
                    int n3;
                    ++n;
                    int n4 = n3 = positionIncrementAttribute != null ? positionIncrementAttribute.getPositionIncrement() : 1;
                    if (n3 != 0) {
                        n2 += n3;
                    } else {
                        bl3 = true;
                    }
                    bl4 = cachingTokenFilter.incrementToken();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            cachingTokenFilter.reset();
            tokenStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            String string3 = null;
            try {
                boolean bl5 = cachingTokenFilter.incrementToken();
                assert (bl5);
                string3 = charTermAttribute.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.newTermQuery(new Term(string, string3));
        }
        if (bl3 || !bl && !this.autoGeneratePhraseQueries) {
            if (n2 == 1 || !bl && !this.autoGeneratePhraseQueries) {
                BooleanQuery booleanQuery = this.newBooleanQuery(n2 == 1);
                BooleanClause.Occur occur = n2 > 1 && this.operator == AND_OPERATOR ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD;
                for (int i = 0; i < n; ++i) {
                    String string4 = null;
                    try {
                        boolean bl6 = cachingTokenFilter.incrementToken();
                        assert (bl6);
                        string4 = charTermAttribute.toString();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    Query query = this.newTermQuery(new Term(string, string4));
                    booleanQuery.add(query, occur);
                }
                return booleanQuery;
            }
            MultiPhraseQuery multiPhraseQuery = this.newMultiPhraseQuery();
            multiPhraseQuery.setSlop(this.phraseSlop);
            ArrayList<Term> arrayList = new ArrayList<Term>();
            int n5 = -1;
            for (int i = 0; i < n; ++i) {
                String string5 = null;
                int n6 = 1;
                try {
                    boolean bl7 = cachingTokenFilter.incrementToken();
                    assert (bl7);
                    string5 = charTermAttribute.toString();
                    if (positionIncrementAttribute != null) {
                        n6 = positionIncrementAttribute.getPositionIncrement();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (n6 > 0 && arrayList.size() > 0) {
                    if (this.enablePositionIncrements) {
                        multiPhraseQuery.add(arrayList.toArray(new Term[0]), n5);
                    } else {
                        multiPhraseQuery.add(arrayList.toArray(new Term[0]));
                    }
                    arrayList.clear();
                }
                n5 += n6;
                arrayList.add(new Term(string, string5));
            }
            if (this.enablePositionIncrements) {
                multiPhraseQuery.add(arrayList.toArray(new Term[0]), n5);
            } else {
                multiPhraseQuery.add(arrayList.toArray(new Term[0]));
            }
            return multiPhraseQuery;
        }
        PhraseQuery phraseQuery = this.newPhraseQuery();
        phraseQuery.setSlop(this.phraseSlop);
        int n7 = -1;
        for (int i = 0; i < n; ++i) {
            String string6 = null;
            int n8 = 1;
            try {
                boolean bl8 = cachingTokenFilter.incrementToken();
                assert (bl8);
                string6 = charTermAttribute.toString();
                if (positionIncrementAttribute != null) {
                    n8 = positionIncrementAttribute.getPositionIncrement();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.enablePositionIncrements) {
                phraseQuery.add(new Term(string, string6), n7 += n8);
                continue;
            }
            phraseQuery.add(new Term(string, string6));
        }
        return phraseQuery;
    }

    protected Query getFieldQuery(String string, String string2, int n) throws ParseException {
        Query query;
        Query query2 = query = this.hasNewAPI ? this.getFieldQuery(string, string2, true) : this.getFieldQuery(string, string2);
        if (query instanceof PhraseQuery) {
            ((PhraseQuery)query).setSlop(n);
        }
        if (query instanceof MultiPhraseQuery) {
            ((MultiPhraseQuery)query).setSlop(n);
        }
        return query;
    }

    protected Query getRangeQuery(String string, String string2, String string3, boolean bl) throws ParseException {
        if (this.lowercaseExpandedTerms) {
            string2 = string2.toLowerCase();
            string3 = string3.toLowerCase();
        }
        try {
            Object object;
            DateFormat dateFormat = DateFormat.getDateInstance(3, this.locale);
            dateFormat.setLenient(true);
            Date date = dateFormat.parse(string2);
            Date date2 = dateFormat.parse(string3);
            if (bl) {
                object = Calendar.getInstance(this.locale);
                ((Calendar)object).setTime(date2);
                ((Calendar)object).set(11, 23);
                ((Calendar)object).set(12, 59);
                ((Calendar)object).set(13, 59);
                ((Calendar)object).set(14, 999);
                date2 = ((Calendar)object).getTime();
            }
            if ((object = this.getDateResolution(string)) == null) {
                string2 = DateField.dateToString(date);
                string3 = DateField.dateToString(date2);
            } else {
                string2 = DateTools.dateToString(date, (DateTools.Resolution)((Object)object));
                string3 = DateTools.dateToString(date2, (DateTools.Resolution)((Object)object));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.newRangeQuery(string, string2, string3, bl);
    }

    protected BooleanQuery newBooleanQuery(boolean bl) {
        return new BooleanQuery(bl);
    }

    protected BooleanClause newBooleanClause(Query query, BooleanClause.Occur occur) {
        return new BooleanClause(query, occur);
    }

    protected Query newTermQuery(Term term) {
        return new TermQuery(term);
    }

    protected PhraseQuery newPhraseQuery() {
        return new PhraseQuery();
    }

    protected MultiPhraseQuery newMultiPhraseQuery() {
        return new MultiPhraseQuery();
    }

    protected Query newPrefixQuery(Term term) {
        PrefixQuery prefixQuery = new PrefixQuery(term);
        prefixQuery.setRewriteMethod(this.multiTermRewriteMethod);
        return prefixQuery;
    }

    protected Query newFuzzyQuery(Term term, float f, int n) {
        return new FuzzyQuery(term, f, n);
    }

    protected Query newRangeQuery(String string, String string2, String string3, boolean bl) {
        TermRangeQuery termRangeQuery = new TermRangeQuery(string, string2, string3, bl, bl, this.rangeCollator);
        termRangeQuery.setRewriteMethod(this.multiTermRewriteMethod);
        return termRangeQuery;
    }

    protected Query newMatchAllDocsQuery() {
        return new MatchAllDocsQuery();
    }

    protected Query newWildcardQuery(Term term) {
        WildcardQuery wildcardQuery = new WildcardQuery(term);
        wildcardQuery.setRewriteMethod(this.multiTermRewriteMethod);
        return wildcardQuery;
    }

    protected Query getBooleanQuery(List<BooleanClause> list) throws ParseException {
        return this.getBooleanQuery(list, false);
    }

    protected Query getBooleanQuery(List<BooleanClause> list, boolean bl) throws ParseException {
        if (list.size() == 0) {
            return null;
        }
        BooleanQuery booleanQuery = this.newBooleanQuery(bl);
        for (BooleanClause booleanClause : list) {
            booleanQuery.add(booleanClause);
        }
        return booleanQuery;
    }

    protected Query getWildcardQuery(String string, String string2) throws ParseException {
        if ("*".equals(string) && "*".equals(string2)) {
            return this.newMatchAllDocsQuery();
        }
        if (!this.allowLeadingWildcard && (string2.startsWith("*") || string2.startsWith("?"))) {
            throw new ParseException("'*' or '?' not allowed as first character in WildcardQuery");
        }
        if (this.lowercaseExpandedTerms) {
            string2 = string2.toLowerCase();
        }
        Term term = new Term(string, string2);
        return this.newWildcardQuery(term);
    }

    protected Query getPrefixQuery(String string, String string2) throws ParseException {
        if (!this.allowLeadingWildcard && string2.startsWith("*")) {
            throw new ParseException("'*' not allowed as first character in PrefixQuery");
        }
        if (this.lowercaseExpandedTerms) {
            string2 = string2.toLowerCase();
        }
        Term term = new Term(string, string2);
        return this.newPrefixQuery(term);
    }

    protected Query getFuzzyQuery(String string, String string2, float f) throws ParseException {
        if (this.lowercaseExpandedTerms) {
            string2 = string2.toLowerCase();
        }
        Term term = new Term(string, string2);
        return this.newFuzzyQuery(term, f, this.fuzzyPrefixLength);
    }

    private String discardEscapeChar(String string) throws ParseException {
        char[] cArray = new char[string.length()];
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (n2 > 0) {
                n3 += QueryParser.hexToInt(c) * n2;
                if ((n2 >>>= 4) != 0) continue;
                cArray[n++] = (char)n3;
                n3 = 0;
                continue;
            }
            if (bl) {
                if (c == 'u') {
                    n2 = 4096;
                } else {
                    cArray[n] = c;
                    ++n;
                }
                bl = false;
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            cArray[n] = c;
            ++n;
        }
        if (n2 > 0) {
            throw new ParseException("Truncated unicode escape sequence.");
        }
        if (bl) {
            throw new ParseException("Term can not end with escape character.");
        }
        return new String(cArray, 0, n);
    }

    private static final int hexToInt(char c) throws ParseException {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        throw new ParseException("None-hex character in unicode escape sequence: " + c);
    }

    public static String escape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?' || c == '|' || c == '&') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("Usage: java org.apache.lucene.queryParser.QueryParser <input>");
            System.exit(0);
        }
        QueryParser queryParser = new QueryParser(Version.LUCENE_CURRENT, "field", new SimpleAnalyzer());
        Query query = queryParser.parse(stringArray[0]);
        System.out.println(query.toString("field"));
    }

    public final int Conjunction() throws ParseException {
        int n = 0;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        this.jj_consume_token(8);
                        n = 1;
                        break block0;
                    }
                    case 9: {
                        this.jj_consume_token(9);
                        n = 2;
                        break block0;
                    }
                }
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        return n;
    }

    public final int Modifiers() throws ParseException {
        int n = 0;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: 
            case 11: 
            case 12: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: {
                        this.jj_consume_token(11);
                        n = 11;
                        break block0;
                    }
                    case 12: {
                        this.jj_consume_token(12);
                        n = 10;
                        break block0;
                    }
                    case 10: {
                        this.jj_consume_token(10);
                        n = 10;
                        break block0;
                    }
                }
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        return n;
    }

    public final Query TopLevelQuery(String string) throws ParseException {
        Query query = this.Query(string);
        this.jj_consume_token(0);
        return query;
    }

    public final Query Query(String string) throws ParseException {
        ArrayList<BooleanClause> arrayList = new ArrayList<BooleanClause>();
        Query query = null;
        int n = this.Modifiers();
        Query query2 = this.Clause(string);
        this.addClause(arrayList, 0, n, query2);
        if (n == 0) {
            query = query2;
        }
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 18: 
                case 19: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            int n2 = this.Conjunction();
            n = this.Modifiers();
            query2 = this.Clause(string);
            this.addClause(arrayList, n2, n, query2);
        }
        if (arrayList.size() == 1 && query != null) {
            return query;
        }
        return this.getBooleanQuery(arrayList);
    }

    public final Query Clause(String string) throws ParseException {
        Query query;
        Token token = null;
        Token token2 = null;
        if (this.jj_2_1(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: {
                    token = this.jj_consume_token(19);
                    this.jj_consume_token(15);
                    string = this.discardEscapeChar(token.image);
                    break;
                }
                case 16: {
                    this.jj_consume_token(16);
                    this.jj_consume_token(15);
                    string = "*";
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        block5 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                query = this.Term(string);
                break;
            }
            case 13: {
                this.jj_consume_token(13);
                query = this.Query(string);
                this.jj_consume_token(14);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 17: {
                        this.jj_consume_token(17);
                        token2 = this.jj_consume_token(25);
                        break block5;
                    }
                }
                this.jj_la1[6] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (token2 != null) {
            float f = 1.0f;
            try {
                f = Float.valueOf(token2.image).floatValue();
                query.setBoost(f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return query;
    }

    public final Query Term(String string) throws ParseException {
        Query query;
        Token token = null;
        Token token2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 25: {
                Token token3;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 19: {
                        token3 = this.jj_consume_token(19);
                        break;
                    }
                    case 16: {
                        token3 = this.jj_consume_token(16);
                        bl2 = true;
                        break;
                    }
                    case 21: {
                        token3 = this.jj_consume_token(21);
                        bl = true;
                        break;
                    }
                    case 22: {
                        token3 = this.jj_consume_token(22);
                        bl2 = true;
                        break;
                    }
                    case 25: {
                        token3 = this.jj_consume_token(25);
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: {
                        token2 = this.jj_consume_token(20);
                        bl3 = true;
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                    }
                }
                block19 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 17: {
                        this.jj_consume_token(17);
                        token = this.jj_consume_token(25);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 20: {
                                token2 = this.jj_consume_token(20);
                                bl3 = true;
                                break block19;
                            }
                        }
                        this.jj_la1[10] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[11] = this.jj_gen;
                    }
                }
                String string2 = this.discardEscapeChar(token3.image);
                if (bl2) {
                    query = this.getWildcardQuery(string, string2);
                    break;
                }
                if (bl) {
                    query = this.getPrefixQuery(string, this.discardEscapeChar(token3.image.substring(0, token3.image.length() - 1)));
                    break;
                }
                if (bl3) {
                    float f = this.fuzzyMinSim;
                    try {
                        f = Float.valueOf(token2.image.substring(1)).floatValue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (f < 0.0f || f > 1.0f) {
                        throw new ParseException("Minimum similarity for a FuzzyQuery has to be between 0.0f and 1.0f !");
                    }
                    query = this.getFuzzyQuery(string, string2, f);
                    break;
                }
                query = this.hasNewAPI ? this.getFieldQuery(string, string2, false) : this.getFieldQuery(string, string2);
                break;
            }
            case 23: {
                Token token4;
                Token token5;
                this.jj_consume_token(23);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: {
                        token5 = this.jj_consume_token(29);
                        break;
                    }
                    case 28: {
                        token5 = this.jj_consume_token(28);
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 26: {
                        this.jj_consume_token(26);
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: {
                        token4 = this.jj_consume_token(29);
                        break;
                    }
                    case 28: {
                        token4 = this.jj_consume_token(28);
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(27);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 17: {
                        this.jj_consume_token(17);
                        token = this.jj_consume_token(25);
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                    }
                }
                if (token5.kind == 28) {
                    token5.image = token5.image.substring(1, token5.image.length() - 1);
                }
                if (token4.kind == 28) {
                    token4.image = token4.image.substring(1, token4.image.length() - 1);
                }
                query = this.getRangeQuery(string, this.discardEscapeChar(token5.image), this.discardEscapeChar(token4.image), true);
                break;
            }
            case 24: {
                Token token6;
                Token token7;
                this.jj_consume_token(24);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 33: {
                        token7 = this.jj_consume_token(33);
                        break;
                    }
                    case 32: {
                        token7 = this.jj_consume_token(32);
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: {
                        this.jj_consume_token(30);
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 33: {
                        token6 = this.jj_consume_token(33);
                        break;
                    }
                    case 32: {
                        token6 = this.jj_consume_token(32);
                        break;
                    }
                    default: {
                        this.jj_la1[18] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(31);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 17: {
                        this.jj_consume_token(17);
                        token = this.jj_consume_token(25);
                        break;
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                    }
                }
                if (token7.kind == 32) {
                    token7.image = token7.image.substring(1, token7.image.length() - 1);
                }
                if (token6.kind == 32) {
                    token6.image = token6.image.substring(1, token6.image.length() - 1);
                }
                query = this.getRangeQuery(string, this.discardEscapeChar(token7.image), this.discardEscapeChar(token6.image), false);
                break;
            }
            case 18: {
                Token token8 = this.jj_consume_token(18);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: {
                        token2 = this.jj_consume_token(20);
                        break;
                    }
                    default: {
                        this.jj_la1[20] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 17: {
                        this.jj_consume_token(17);
                        token = this.jj_consume_token(25);
                        break;
                    }
                    default: {
                        this.jj_la1[21] = this.jj_gen;
                    }
                }
                int n = this.phraseSlop;
                if (token2 != null) {
                    try {
                        n = Float.valueOf(token2.image.substring(1)).intValue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                query = this.getFieldQuery(string, this.discardEscapeChar(token8.image.substring(1, token8.image.length() - 1)), n);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (token != null) {
            float f = 1.0f;
            try {
                f = Float.valueOf(token.image).floatValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (query != null) {
                query.setBoost(f);
            }
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    private boolean jj_3R_3() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        return this.jj_scan_token(15);
    }

    private boolean jj_3R_2() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        return this.jj_scan_token(15);
    }

    private boolean jj_3_1() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_2()) {
            this.jj_scanpos = token;
            if (this.jj_3R_3()) {
                return true;
            }
        }
        return false;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{768, 768, 7168, 7168, 65879808, 589824, 131072, 65871872, 40435712, 0x100000, 0x100000, 131072, 0x30000000, 0x4000000, 0x30000000, 131072, 0, 0x40000000, 0, 131072, 0x100000, 131072, 65863680};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0};
    }

    protected QueryParser(CharStream charStream) {
        int n;
        this.token_source = new QueryParserTokenManager(charStream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 23; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(CharStream charStream) {
        int n;
        this.token_source.ReInit(charStream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 23; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    protected QueryParser(QueryParserTokenManager queryParserTokenManager) {
        int n;
        this.token_source = queryParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 23; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(QueryParserTokenManager queryParserTokenManager) {
        int n;
        this.token_source = queryParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 23; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        if (this.jj_scanpos.kind != n) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] nArray : this.jj_expentries) {
                if (nArray.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.clear();
        boolean[] blArray = new boolean[34];
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 23; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) == 0) continue;
                blArray[32 + n] = true;
            }
        }
        for (n2 = 0; n2 < 34; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = this.jj_expentries.get(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 1; ++i) {
            try {
                JJCalls jJCalls = this.jj_2_rtns[i];
                do {
                    if (jJCalls.gen <= this.jj_gen) continue;
                    this.jj_la = jJCalls.arg;
                    this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                        }
                    }
                } while ((jJCalls = jJCalls.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        QueryParser.jj_la1_init_0();
        QueryParser.jj_la1_init_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    public static enum Operator {
        OR,
        AND;

    }
}

