/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.index.TermVectorsReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.UnicodeUtil;

final class TermVectorsWriter {
    private IndexOutput tvx;
    private IndexOutput tvd;
    private IndexOutput tvf;
    private FieldInfos fieldInfos;
    final UnicodeUtil.UTF8Result[] utf8Results;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TermVectorsWriter(Directory directory, String string, FieldInfos fieldInfos) throws IOException {
        block3: {
            this.tvx = null;
            this.tvd = null;
            this.tvf = null;
            this.utf8Results = new UnicodeUtil.UTF8Result[]{new UnicodeUtil.UTF8Result(), new UnicodeUtil.UTF8Result()};
            boolean bl = false;
            try {
                this.tvx = directory.createOutput(IndexFileNames.segmentFileName(string, "tvx"));
                this.tvx.writeInt(4);
                this.tvd = directory.createOutput(IndexFileNames.segmentFileName(string, "tvd"));
                this.tvd.writeInt(4);
                this.tvf = directory.createOutput(IndexFileNames.segmentFileName(string, "tvf"));
                this.tvf.writeInt(4);
                bl = true;
                if (bl) break block3;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    IOUtils.closeWhileHandlingException(this.tvx, this.tvd, this.tvf);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(this.tvx, this.tvd, this.tvf);
        }
        this.fieldInfos = fieldInfos;
    }

    public final void addAllDocVectors(TermFreqVector[] termFreqVectorArray) throws IOException {
        this.tvx.writeLong(this.tvd.getFilePointer());
        this.tvx.writeLong(this.tvf.getFilePointer());
        if (termFreqVectorArray != null) {
            int n;
            int n2 = termFreqVectorArray.length;
            this.tvd.writeVInt(n2);
            long[] lArray = new long[n2];
            for (int i = 0; i < n2; ++i) {
                int n3;
                boolean bl;
                boolean bl2;
                TermPositionVector termPositionVector;
                lArray[i] = this.tvf.getFilePointer();
                int n4 = this.fieldInfos.fieldNumber(termFreqVectorArray[i].getField());
                this.tvd.writeVInt(n4);
                n = termFreqVectorArray[i].size();
                this.tvf.writeVInt(n);
                if (termFreqVectorArray[i] instanceof TermPositionVector) {
                    termPositionVector = (TermPositionVector)termFreqVectorArray[i];
                    bl2 = termPositionVector.size() > 0 && termPositionVector.getTermPositions(0) != null;
                    bl = termPositionVector.size() > 0 && termPositionVector.getOffsets(0) != null;
                    n3 = (byte)((bl2 ? 1 : 0) + (bl ? 2 : 0));
                } else {
                    termPositionVector = null;
                    n3 = 0;
                    bl2 = false;
                    bl = false;
                }
                this.tvf.writeVInt(n3);
                String[] stringArray = termFreqVectorArray[i].getTerms();
                int[] nArray = termFreqVectorArray[i].getTermFrequencies();
                int n5 = 0;
                this.utf8Results[1].length = 0;
                for (int j = 0; j < n; ++j) {
                    int n6;
                    int n7;
                    int n8;
                    Object[] objectArray;
                    UnicodeUtil.UTF16toUTF8(stringArray[j], 0, stringArray[j].length(), this.utf8Results[n5]);
                    int n9 = StringHelper.bytesDifference(this.utf8Results[1 - n5].result, this.utf8Results[1 - n5].length, this.utf8Results[n5].result, this.utf8Results[n5].length);
                    int n10 = this.utf8Results[n5].length - n9;
                    this.tvf.writeVInt(n9);
                    this.tvf.writeVInt(n10);
                    this.tvf.writeBytes(this.utf8Results[n5].result, n9, n10);
                    n5 = 1 - n5;
                    int n11 = nArray[j];
                    this.tvf.writeVInt(n11);
                    if (bl2) {
                        objectArray = termPositionVector.getTermPositions(j);
                        if (objectArray == null) {
                            throw new IllegalStateException("Trying to write positions that are null!");
                        }
                        assert (objectArray.length == n11);
                        n8 = 0;
                        for (n7 = 0; n7 < objectArray.length; ++n7) {
                            n6 = objectArray[n7];
                            this.tvf.writeVInt(n6 - n8);
                            n8 = n6;
                        }
                    }
                    if (!bl) continue;
                    objectArray = termPositionVector.getOffsets(j);
                    if (objectArray == null) {
                        throw new IllegalStateException("Trying to write offsets that are null!");
                    }
                    assert (objectArray.length == n11);
                    n8 = 0;
                    for (n7 = 0; n7 < objectArray.length; ++n7) {
                        n6 = objectArray[n7].getStartOffset();
                        int n12 = objectArray[n7].getEndOffset();
                        this.tvf.writeVInt(n6 - n8);
                        this.tvf.writeVInt(n12 - n6);
                        n8 = n12;
                    }
                }
            }
            if (n2 > 1) {
                long l = lArray[0];
                for (n = 1; n < n2; ++n) {
                    long l2 = lArray[n];
                    this.tvd.writeVLong(l2 - l);
                    l = l2;
                }
            }
        } else {
            this.tvd.writeVInt(0);
        }
    }

    final void addRawDocuments(TermVectorsReader termVectorsReader, int[] nArray, int[] nArray2, int n) throws IOException {
        long l = this.tvd.getFilePointer();
        long l2 = this.tvf.getFilePointer();
        long l3 = l;
        long l4 = l2;
        for (int i = 0; i < n; ++i) {
            this.tvx.writeLong(l);
            l += (long)nArray[i];
            this.tvx.writeLong(l2);
            l2 += (long)nArray2[i];
        }
        this.tvd.copyBytes(termVectorsReader.getTvdStream(), l - l3);
        this.tvf.copyBytes(termVectorsReader.getTvfStream(), l2 - l4);
        assert (this.tvd.getFilePointer() == l);
        assert (this.tvf.getFilePointer() == l2);
    }

    final void close() throws IOException {
        IOUtils.close(this.tvx, this.tvd, this.tvf);
    }
}

