/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermVectorsTermsWriterPerField;
import org.apache.lucene.index.TermVectorsTermsWriterPerThread;
import org.apache.lucene.index.TermsHashConsumer;
import org.apache.lucene.index.TermsHashConsumerPerField;
import org.apache.lucene.index.TermsHashConsumerPerThread;
import org.apache.lucene.index.TermsHashPerThread;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;

final class TermVectorsTermsWriter
extends TermsHashConsumer {
    final DocumentsWriter docWriter;
    PerDoc[] docFreeList = new PerDoc[1];
    int freeCount;
    IndexOutput tvx;
    IndexOutput tvd;
    IndexOutput tvf;
    int lastDocID;
    boolean hasVectors;
    int allocCount;

    public TermVectorsTermsWriter(DocumentsWriter documentsWriter) {
        this.docWriter = documentsWriter;
    }

    @Override
    public TermsHashConsumerPerThread addThread(TermsHashPerThread termsHashPerThread) {
        return new TermVectorsTermsWriterPerThread(termsHashPerThread, this);
    }

    @Override
    synchronized void flush(Map<TermsHashConsumerPerThread, Collection<TermsHashConsumerPerField>> map, SegmentWriteState segmentWriteState) throws IOException {
        if (this.tvx != null) {
            this.fill(segmentWriteState.numDocs);
            IOUtils.close(this.tvx, this.tvf, this.tvd);
            this.tvf = null;
            this.tvd = null;
            this.tvx = null;
            assert (segmentWriteState.segmentName != null);
            String string = IndexFileNames.segmentFileName(segmentWriteState.segmentName, "tvx");
            if (4L + (long)segmentWriteState.numDocs * 16L != segmentWriteState.directory.fileLength(string)) {
                throw new RuntimeException("after flush: tvx size mismatch: " + segmentWriteState.numDocs + " docs vs " + segmentWriteState.directory.fileLength(string) + " length in bytes of " + (String)string + " file exists?=" + segmentWriteState.directory.fileExists(string));
            }
            this.lastDocID = 0;
            segmentWriteState.hasVectors = this.hasVectors;
            this.hasVectors = false;
        }
        for (Map.Entry<TermsHashConsumerPerThread, Collection<TermsHashConsumerPerField>> entry : map.entrySet()) {
            for (TermsHashConsumerPerField termsHashConsumerPerField : entry.getValue()) {
                TermVectorsTermsWriterPerField termVectorsTermsWriterPerField = (TermVectorsTermsWriterPerField)termsHashConsumerPerField;
                termVectorsTermsWriterPerField.termsHashPerField.reset();
                termVectorsTermsWriterPerField.shrinkHash();
            }
            TermVectorsTermsWriterPerThread termVectorsTermsWriterPerThread = (TermVectorsTermsWriterPerThread)entry.getKey();
            termVectorsTermsWriterPerThread.termsHashPerThread.reset(true);
        }
    }

    synchronized PerDoc getPerDoc() {
        if (this.freeCount == 0) {
            ++this.allocCount;
            if (this.allocCount > this.docFreeList.length) {
                assert (this.allocCount == 1 + this.docFreeList.length);
                this.docFreeList = new PerDoc[ArrayUtil.oversize(this.allocCount, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            }
            return new PerDoc();
        }
        return this.docFreeList[--this.freeCount];
    }

    void fill(int n) throws IOException {
        if (this.lastDocID < n) {
            long l = this.tvf.getFilePointer();
            while (this.lastDocID < n) {
                this.tvx.writeLong(this.tvd.getFilePointer());
                this.tvd.writeVInt(0);
                this.tvx.writeLong(l);
                ++this.lastDocID;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void initTermVectorsWriter() throws IOException {
        if (this.tvx == null) {
            block4: {
                boolean bl = false;
                try {
                    this.hasVectors = true;
                    this.tvx = this.docWriter.directory.createOutput(IndexFileNames.segmentFileName(this.docWriter.getSegment(), "tvx"));
                    this.tvd = this.docWriter.directory.createOutput(IndexFileNames.segmentFileName(this.docWriter.getSegment(), "tvd"));
                    this.tvf = this.docWriter.directory.createOutput(IndexFileNames.segmentFileName(this.docWriter.getSegment(), "tvf"));
                    this.tvx.writeInt(4);
                    this.tvd.writeInt(4);
                    this.tvf.writeInt(4);
                    bl = true;
                    if (bl) break block4;
                }
                catch (Throwable throwable) {
                    if (!bl) {
                        IOUtils.closeWhileHandlingException(this.tvx, this.tvd, this.tvf);
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException(this.tvx, this.tvd, this.tvf);
            }
            this.lastDocID = 0;
        }
    }

    synchronized void finishDocument(PerDoc perDoc) throws IOException {
        assert (this.docWriter.writer.testPoint("TermVectorsTermsWriter.finishDocument start"));
        this.initTermVectorsWriter();
        this.fill(perDoc.docID);
        this.tvx.writeLong(this.tvd.getFilePointer());
        this.tvx.writeLong(this.tvf.getFilePointer());
        this.tvd.writeVInt(perDoc.numVectorFields);
        if (perDoc.numVectorFields > 0) {
            for (int i = 0; i < perDoc.numVectorFields; ++i) {
                this.tvd.writeVInt(perDoc.fieldNumbers[i]);
            }
            assert (0L == perDoc.fieldPointers[0]);
            long l = perDoc.fieldPointers[0];
            for (int i = 1; i < perDoc.numVectorFields; ++i) {
                long l2 = perDoc.fieldPointers[i];
                this.tvd.writeVLong(l2 - l);
                l = l2;
            }
            perDoc.perDocTvf.writeTo(this.tvf);
            perDoc.numVectorFields = 0;
        }
        assert (this.lastDocID == perDoc.docID) : "lastDocID=" + this.lastDocID + " perDoc.docID=" + perDoc.docID;
        ++this.lastDocID;
        perDoc.reset();
        this.free(perDoc);
        assert (this.docWriter.writer.testPoint("TermVectorsTermsWriter.finishDocument end"));
    }

    @Override
    public void abort() {
        this.hasVectors = false;
        try {
            IOUtils.closeWhileHandlingException(this.tvx, this.tvd, this.tvf);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        try {
            this.docWriter.directory.deleteFile(IndexFileNames.segmentFileName(this.docWriter.getSegment(), "tvx"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.docWriter.directory.deleteFile(IndexFileNames.segmentFileName(this.docWriter.getSegment(), "tvd"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.docWriter.directory.deleteFile(IndexFileNames.segmentFileName(this.docWriter.getSegment(), "tvf"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.tvf = null;
        this.tvd = null;
        this.tvx = null;
        this.lastDocID = 0;
    }

    synchronized void free(PerDoc perDoc) {
        assert (this.freeCount < this.docFreeList.length);
        this.docFreeList[this.freeCount++] = perDoc;
    }

    class PerDoc
    extends DocumentsWriter.DocWriter {
        final DocumentsWriter.PerDocBuffer buffer;
        RAMOutputStream perDocTvf;
        int numVectorFields;
        int[] fieldNumbers;
        long[] fieldPointers;

        PerDoc() {
            this.buffer = TermVectorsTermsWriter.this.docWriter.newPerDocBuffer();
            this.perDocTvf = new RAMOutputStream(this.buffer);
            this.fieldNumbers = new int[1];
            this.fieldPointers = new long[1];
        }

        void reset() {
            this.perDocTvf.reset();
            this.buffer.recycle();
            this.numVectorFields = 0;
        }

        @Override
        void abort() {
            this.reset();
            TermVectorsTermsWriter.this.free(this);
        }

        void addField(int n) {
            if (this.numVectorFields == this.fieldNumbers.length) {
                this.fieldNumbers = ArrayUtil.grow(this.fieldNumbers);
            }
            if (this.numVectorFields == this.fieldPointers.length) {
                this.fieldPointers = ArrayUtil.grow(this.fieldPointers);
            }
            this.fieldNumbers[this.numVectorFields] = n;
            this.fieldPointers[this.numVectorFields] = this.perDocTvf.getFilePointer();
            ++this.numVectorFields;
        }

        @Override
        public long sizeInBytes() {
            return this.buffer.getSizeInBytes();
        }

        @Override
        public void finish() throws IOException {
            TermVectorsTermsWriter.this.finishDocument(this);
        }
    }
}

