/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentTermEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermInfosReaderIndex;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.DoubleBarrelLRUCache;

final class TermInfosReader
implements Closeable {
    private final Directory directory;
    private final String segment;
    private final FieldInfos fieldInfos;
    private final CloseableThreadLocal<ThreadResources> threadResources = new CloseableThreadLocal();
    private final SegmentTermEnum origEnum;
    private final long size;
    private final TermInfosReaderIndex index;
    private final int indexLength;
    private final int totalIndexInterval;
    private static final int DEFAULT_CACHE_SIZE = 1024;
    private final DoubleBarrelLRUCache<CloneableTerm, TermInfoAndOrd> termsCache = new DoubleBarrelLRUCache(1024);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TermInfosReader(Directory directory, String string, FieldInfos fieldInfos, int n, int n2) throws CorruptIndexException, IOException {
        boolean bl = false;
        if (n2 < 1 && n2 != -1) {
            throw new IllegalArgumentException("indexDivisor must be -1 (don't load terms index) or greater than 0: got " + n2);
        }
        try {
            this.directory = directory;
            this.segment = string;
            this.fieldInfos = fieldInfos;
            this.origEnum = new SegmentTermEnum(this.directory.openInput(IndexFileNames.segmentFileName(this.segment, "tis"), n), this.fieldInfos, false);
            this.size = this.origEnum.size;
            if (n2 != -1) {
                this.totalIndexInterval = this.origEnum.indexInterval * n2;
                String string2 = IndexFileNames.segmentFileName(this.segment, "tii");
                SegmentTermEnum segmentTermEnum = new SegmentTermEnum(this.directory.openInput(string2, n), this.fieldInfos, true);
                try {
                    this.index = new TermInfosReaderIndex(segmentTermEnum, n2, directory.fileLength(string2), this.totalIndexInterval);
                    this.indexLength = this.index.length();
                }
                finally {
                    segmentTermEnum.close();
                }
            } else {
                this.totalIndexInterval = -1;
                this.index = null;
                this.indexLength = -1;
            }
            bl = true;
        }
        finally {
            if (!bl) {
                this.close();
            }
        }
    }

    public int getSkipInterval() {
        return this.origEnum.skipInterval;
    }

    public int getMaxSkipLevels() {
        return this.origEnum.maxSkipLevels;
    }

    @Override
    public final void close() throws IOException {
        if (this.origEnum != null) {
            this.origEnum.close();
        }
        this.threadResources.close();
    }

    final long size() {
        return this.size;
    }

    private ThreadResources getThreadResources() {
        ThreadResources threadResources = this.threadResources.get();
        if (threadResources == null) {
            threadResources = new ThreadResources();
            threadResources.termEnum = this.terms();
            this.threadResources.set(threadResources);
        }
        return threadResources;
    }

    TermInfo get(Term term) throws IOException {
        BytesRef bytesRef = new BytesRef(term.text);
        return this.get(term, false, bytesRef);
    }

    private TermInfo get(Term term, boolean bl, BytesRef bytesRef) throws IOException {
        TermInfo termInfo;
        int n;
        if (this.size == 0L) {
            return null;
        }
        this.ensureIndexIsRead();
        CloneableTerm cloneableTerm = new CloneableTerm(term);
        TermInfoAndOrd termInfoAndOrd = this.termsCache.get(cloneableTerm);
        ThreadResources threadResources = this.getThreadResources();
        if (!bl && termInfoAndOrd != null) {
            return termInfoAndOrd;
        }
        SegmentTermEnum segmentTermEnum = threadResources.termEnum;
        if (segmentTermEnum.term() != null && (segmentTermEnum.prev() != null && term.compareTo(segmentTermEnum.prev()) > 0 || term.compareTo(segmentTermEnum.term()) >= 0) && (this.indexLength == (n = (int)(segmentTermEnum.position / (long)this.totalIndexInterval) + 1) || this.index.compareTo(term, bytesRef, n) < 0)) {
            TermInfo termInfo2;
            int n2 = segmentTermEnum.scanTo(term);
            if (segmentTermEnum.term() != null && term.compareTo(segmentTermEnum.term()) == 0) {
                termInfo2 = segmentTermEnum.termInfo();
                if (n2 > 1) {
                    if (termInfoAndOrd == null) {
                        this.termsCache.put(cloneableTerm, new TermInfoAndOrd(termInfo2, segmentTermEnum.position));
                    } else {
                        assert (this.sameTermInfo(termInfo2, termInfoAndOrd, segmentTermEnum));
                        assert ((long)((int)segmentTermEnum.position) == termInfoAndOrd.termOrd);
                    }
                }
            } else {
                termInfo2 = null;
            }
            return termInfo2;
        }
        n = termInfoAndOrd != null ? (int)(termInfoAndOrd.termOrd / (long)this.totalIndexInterval) : this.index.getIndexOffset(term, bytesRef);
        this.index.seekEnum(segmentTermEnum, n);
        segmentTermEnum.scanTo(term);
        if (segmentTermEnum.term() != null && term.compareTo(segmentTermEnum.term()) == 0) {
            termInfo = segmentTermEnum.termInfo();
            if (termInfoAndOrd == null) {
                this.termsCache.put(cloneableTerm, new TermInfoAndOrd(termInfo, segmentTermEnum.position));
            } else {
                assert (this.sameTermInfo(termInfo, termInfoAndOrd, segmentTermEnum));
                assert (segmentTermEnum.position == termInfoAndOrd.termOrd);
            }
        } else {
            termInfo = null;
        }
        return termInfo;
    }

    private final boolean sameTermInfo(TermInfo termInfo, TermInfo termInfo2, SegmentTermEnum segmentTermEnum) {
        if (termInfo.docFreq != termInfo2.docFreq) {
            return false;
        }
        if (termInfo.freqPointer != termInfo2.freqPointer) {
            return false;
        }
        if (termInfo.proxPointer != termInfo2.proxPointer) {
            return false;
        }
        return termInfo.docFreq < segmentTermEnum.skipInterval || termInfo.skipOffset == termInfo2.skipOffset;
    }

    private void ensureIndexIsRead() {
        if (this.index == null) {
            throw new IllegalStateException("terms index was not loaded when this reader was created");
        }
    }

    final long getPosition(Term term) throws IOException {
        if (this.size == 0L) {
            return -1L;
        }
        this.ensureIndexIsRead();
        BytesRef bytesRef = new BytesRef(term.text);
        int n = this.index.getIndexOffset(term, bytesRef);
        SegmentTermEnum segmentTermEnum = this.getThreadResources().termEnum;
        this.index.seekEnum(segmentTermEnum, n);
        while (term.compareTo(segmentTermEnum.term()) > 0 && segmentTermEnum.next()) {
        }
        if (term.compareTo(segmentTermEnum.term()) == 0) {
            return segmentTermEnum.position;
        }
        return -1L;
    }

    public SegmentTermEnum terms() {
        return (SegmentTermEnum)this.origEnum.clone();
    }

    public SegmentTermEnum terms(Term term) throws IOException {
        BytesRef bytesRef = new BytesRef(term.text);
        this.get(term, true, bytesRef);
        return (SegmentTermEnum)this.getThreadResources().termEnum.clone();
    }

    private static final class ThreadResources {
        SegmentTermEnum termEnum;

        private ThreadResources() {
        }
    }

    private static class CloneableTerm
    extends DoubleBarrelLRUCache.CloneableKey {
        private final Term term;

        public CloneableTerm(Term term) {
            this.term = new Term(term.field(), term.text());
        }

        @Override
        public Object clone() {
            return new CloneableTerm(this.term);
        }

        public boolean equals(Object object) {
            CloneableTerm cloneableTerm = (CloneableTerm)object;
            return this.term.equals(cloneableTerm.term);
        }

        public int hashCode() {
            return this.term.hashCode();
        }
    }

    private static final class TermInfoAndOrd
    extends TermInfo {
        final long termOrd;

        public TermInfoAndOrd(TermInfo termInfo, long l) {
            super(termInfo);
            assert (l >= 0L);
            this.termOrd = l;
        }
    }
}

