/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.lucene.index.TermVectorEntry;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.index.TermVectorOffsetInfo;

public class SortedTermVectorMapper
extends TermVectorMapper {
    private SortedSet<TermVectorEntry> currentSet;
    private Map<String, TermVectorEntry> termToTVE = new HashMap<String, TermVectorEntry>();
    private boolean storeOffsets;
    private boolean storePositions;
    public static final String ALL = "_ALL_";

    public SortedTermVectorMapper(Comparator<TermVectorEntry> comparator) {
        this(false, false, comparator);
    }

    public SortedTermVectorMapper(boolean bl, boolean bl2, Comparator<TermVectorEntry> comparator) {
        super(bl, bl2);
        this.currentSet = new TreeSet<TermVectorEntry>(comparator);
    }

    @Override
    public void map(String string, int n, TermVectorOffsetInfo[] termVectorOffsetInfoArray, int[] nArray) {
        TermVectorEntry termVectorEntry = this.termToTVE.get(string);
        if (termVectorEntry == null) {
            termVectorEntry = new TermVectorEntry(ALL, string, n, (TermVectorOffsetInfo[])(this.storeOffsets ? termVectorOffsetInfoArray : null), (int[])(this.storePositions ? nArray : null));
            this.termToTVE.put(string, termVectorEntry);
            this.currentSet.add(termVectorEntry);
        } else {
            TermVectorOffsetInfo[] termVectorOffsetInfoArray2;
            Object[] objectArray;
            termVectorEntry.setFrequency(termVectorEntry.getFrequency() + n);
            if (this.storeOffsets) {
                objectArray = termVectorEntry.getOffsets();
                if (objectArray != null && termVectorOffsetInfoArray != null && termVectorOffsetInfoArray.length > 0) {
                    termVectorOffsetInfoArray2 = new TermVectorOffsetInfo[objectArray.length + termVectorOffsetInfoArray.length];
                    System.arraycopy(objectArray, 0, termVectorOffsetInfoArray2, 0, objectArray.length);
                    System.arraycopy(termVectorOffsetInfoArray, 0, termVectorOffsetInfoArray2, objectArray.length, termVectorOffsetInfoArray.length);
                    termVectorEntry.setOffsets(termVectorOffsetInfoArray2);
                } else if (objectArray == null && termVectorOffsetInfoArray != null && termVectorOffsetInfoArray.length > 0) {
                    termVectorEntry.setOffsets(termVectorOffsetInfoArray);
                }
            }
            if (this.storePositions) {
                objectArray = termVectorEntry.getPositions();
                if (objectArray != null && nArray != null && nArray.length > 0) {
                    termVectorOffsetInfoArray2 = (TermVectorOffsetInfo[])new int[objectArray.length + nArray.length];
                    System.arraycopy(objectArray, 0, termVectorOffsetInfoArray2, 0, objectArray.length);
                    System.arraycopy(nArray, 0, termVectorOffsetInfoArray2, objectArray.length, nArray.length);
                    termVectorEntry.setPositions((int[])termVectorOffsetInfoArray2);
                } else if (objectArray == null && nArray != null && nArray.length > 0) {
                    termVectorEntry.setPositions(nArray);
                }
            }
        }
    }

    @Override
    public void setExpectations(String string, int n, boolean bl, boolean bl2) {
        this.storeOffsets = bl;
        this.storePositions = bl2;
    }

    public SortedSet<TermVectorEntry> getTermVectorEntrySet() {
        return this.currentSet;
    }
}

