/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.DefaultSkipListReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentTermEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BitVector;

class SegmentTermDocs
implements TermDocs {
    protected SegmentReader parent;
    protected IndexInput freqStream;
    protected int count;
    protected int df;
    protected BitVector deletedDocs;
    int doc = 0;
    int freq;
    private int skipInterval;
    private int maxSkipLevels;
    private DefaultSkipListReader skipListReader;
    private long freqBasePointer;
    private long proxBasePointer;
    private long skipPointer;
    private boolean haveSkipped;
    protected boolean currentFieldStoresPayloads;
    protected FieldInfo.IndexOptions indexOptions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SegmentTermDocs(SegmentReader segmentReader) {
        this.parent = segmentReader;
        this.freqStream = (IndexInput)segmentReader.core.freqStream.clone();
        SegmentReader segmentReader2 = segmentReader;
        synchronized (segmentReader2) {
            this.deletedDocs = segmentReader.deletedDocs;
        }
        this.skipInterval = segmentReader.core.getTermsReader().getSkipInterval();
        this.maxSkipLevels = segmentReader.core.getTermsReader().getMaxSkipLevels();
    }

    @Override
    public void seek(Term term) throws IOException {
        TermInfo termInfo = this.parent.core.getTermsReader().get(term);
        this.seek(termInfo, term);
    }

    @Override
    public void seek(TermEnum termEnum) throws IOException {
        TermInfo termInfo;
        Term term;
        if (termEnum instanceof SegmentTermEnum && ((SegmentTermEnum)termEnum).fieldInfos == this.parent.core.fieldInfos) {
            SegmentTermEnum segmentTermEnum = (SegmentTermEnum)termEnum;
            term = segmentTermEnum.term();
            termInfo = segmentTermEnum.termInfo();
        } else {
            term = termEnum.term();
            termInfo = this.parent.core.getTermsReader().get(term);
        }
        this.seek(termInfo, term);
    }

    void seek(TermInfo termInfo, Term term) throws IOException {
        this.count = 0;
        FieldInfo fieldInfo = this.parent.core.fieldInfos.fieldInfo(term.field);
        this.indexOptions = fieldInfo != null ? fieldInfo.indexOptions : FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
        boolean bl = this.currentFieldStoresPayloads = fieldInfo != null ? fieldInfo.storePayloads : false;
        if (termInfo == null) {
            this.df = 0;
        } else {
            this.df = termInfo.docFreq;
            this.doc = 0;
            this.freqBasePointer = termInfo.freqPointer;
            this.proxBasePointer = termInfo.proxPointer;
            this.skipPointer = this.freqBasePointer + (long)termInfo.skipOffset;
            this.freqStream.seek(this.freqBasePointer);
            this.haveSkipped = false;
        }
    }

    @Override
    public void close() throws IOException {
        this.freqStream.close();
        if (this.skipListReader != null) {
            this.skipListReader.close();
        }
    }

    @Override
    public final int doc() {
        return this.doc;
    }

    @Override
    public final int freq() {
        return this.freq;
    }

    protected void skippingDoc() throws IOException {
    }

    @Override
    public boolean next() throws IOException {
        while (true) {
            if (this.count == this.df) {
                return false;
            }
            int n = this.freqStream.readVInt();
            if (this.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY) {
                this.doc += n;
                this.freq = 1;
            } else {
                this.doc += n >>> 1;
                this.freq = (n & 1) != 0 ? 1 : this.freqStream.readVInt();
            }
            ++this.count;
            if (this.deletedDocs == null || !this.deletedDocs.get(this.doc)) break;
            this.skippingDoc();
        }
        return true;
    }

    @Override
    public int read(int[] nArray, int[] nArray2) throws IOException {
        int n = nArray.length;
        if (this.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY) {
            return this.readNoTf(nArray, nArray2, n);
        }
        int n2 = 0;
        while (n2 < n && this.count < this.df) {
            int n3 = this.freqStream.readVInt();
            this.doc += n3 >>> 1;
            this.freq = (n3 & 1) != 0 ? 1 : this.freqStream.readVInt();
            ++this.count;
            if (this.deletedDocs != null && this.deletedDocs.get(this.doc)) continue;
            nArray[n2] = this.doc;
            nArray2[n2] = this.freq;
            ++n2;
        }
        return n2;
    }

    private final int readNoTf(int[] nArray, int[] nArray2, int n) throws IOException {
        int n2 = 0;
        while (n2 < n && this.count < this.df) {
            this.doc += this.freqStream.readVInt();
            ++this.count;
            if (this.deletedDocs != null && this.deletedDocs.get(this.doc)) continue;
            nArray[n2] = this.doc;
            nArray2[n2] = 1;
            ++n2;
        }
        return n2;
    }

    protected void skipProx(long l, int n) throws IOException {
    }

    @Override
    public boolean skipTo(int n) throws IOException {
        if (n - this.skipInterval >= this.doc && this.df >= this.skipInterval) {
            int n2;
            if (this.skipListReader == null) {
                this.skipListReader = new DefaultSkipListReader((IndexInput)this.freqStream.clone(), this.maxSkipLevels, this.skipInterval);
            }
            if (!this.haveSkipped) {
                this.skipListReader.init(this.skipPointer, this.freqBasePointer, this.proxBasePointer, this.df, this.currentFieldStoresPayloads);
                this.haveSkipped = true;
            }
            if ((n2 = this.skipListReader.skipTo(n)) > this.count) {
                this.freqStream.seek(this.skipListReader.getFreqPointer());
                this.skipProx(this.skipListReader.getProxPointer(), this.skipListReader.getPayloadLength());
                this.doc = this.skipListReader.getDoc();
                this.count = n2;
            }
        }
        do {
            if (this.next()) continue;
            return false;
        } while (n > this.doc);
        return true;
    }
}

