/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.CompoundFileReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldsReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.ChecksumIndexOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.NoSuchDirectoryException;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.ThreadInterruptedException;

public final class SegmentInfos
implements Cloneable,
Iterable<SegmentInfo> {
    public static final int FORMAT = -1;
    public static final int FORMAT_LOCKLESS = -2;
    public static final int FORMAT_SINGLE_NORM_FILE = -3;
    public static final int FORMAT_SHARED_DOC_STORE = -4;
    public static final int FORMAT_CHECKSUM = -5;
    public static final int FORMAT_DEL_COUNT = -6;
    public static final int FORMAT_HAS_PROX = -7;
    public static final int FORMAT_USER_DATA = -8;
    public static final int FORMAT_DIAGNOSTICS = -9;
    public static final int FORMAT_HAS_VECTORS = -10;
    public static final int FORMAT_3_1 = -11;
    public static final int CURRENT_FORMAT = -11;
    public static final int FORMAT_MINIMUM = -1;
    public static final int FORMAT_MAXIMUM = -11;
    public int counter = 0;
    long version = System.currentTimeMillis();
    private long generation = 0L;
    private long lastGeneration = 0L;
    private Map<String, String> userData = Collections.emptyMap();
    private int format;
    private List<SegmentInfo> segments = new ArrayList<SegmentInfo>();
    private Set<SegmentInfo> segmentSet = new HashSet<SegmentInfo>();
    private transient List<SegmentInfo> cachedUnmodifiableList;
    private transient Set<SegmentInfo> cachedUnmodifiableSet;
    private static PrintStream infoStream = null;
    ChecksumIndexOutput pendingSegnOutput;
    private static int defaultGenFileRetryCount = 10;
    private static int defaultGenFileRetryPauseMsec = 50;
    private static int defaultGenLookaheadCount = 10;

    public void setFormat(int n) {
        this.format = n;
    }

    public int getFormat() {
        return this.format;
    }

    public SegmentInfo info(int n) {
        return this.segments.get(n);
    }

    public static long getCurrentSegmentGeneration(String[] stringArray) {
        if (stringArray == null) {
            return -1L;
        }
        long l = -1L;
        for (int i = 0; i < stringArray.length; ++i) {
            long l2;
            String string = stringArray[i];
            if (!string.startsWith("segments") || string.equals("segments.gen") || (l2 = SegmentInfos.generationFromSegmentsFileName(string)) <= l) continue;
            l = l2;
        }
        return l;
    }

    public static long getCurrentSegmentGeneration(Directory directory) throws IOException {
        try {
            return SegmentInfos.getCurrentSegmentGeneration(directory.listAll());
        }
        catch (NoSuchDirectoryException noSuchDirectoryException) {
            return -1L;
        }
    }

    public static String getCurrentSegmentFileName(String[] stringArray) throws IOException {
        return IndexFileNames.fileNameFromGeneration("segments", "", SegmentInfos.getCurrentSegmentGeneration(stringArray));
    }

    public static String getCurrentSegmentFileName(Directory directory) throws IOException {
        return IndexFileNames.fileNameFromGeneration("segments", "", SegmentInfos.getCurrentSegmentGeneration(directory));
    }

    public String getCurrentSegmentFileName() {
        return IndexFileNames.fileNameFromGeneration("segments", "", this.lastGeneration);
    }

    public static long generationFromSegmentsFileName(String string) {
        if (string.equals("segments")) {
            return 0L;
        }
        if (string.startsWith("segments")) {
            return Long.parseLong(string.substring(1 + "segments".length()), 36);
        }
        throw new IllegalArgumentException("fileName \"" + string + "\" is not a segments file");
    }

    public String getNextSegmentFileName() {
        long l = this.generation == -1L ? 1L : this.generation + 1L;
        return IndexFileNames.fileNameFromGeneration("segments", "", l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void read(Directory directory, String string) throws CorruptIndexException, IOException {
        boolean bl = false;
        this.clear();
        ChecksumIndexInput checksumIndexInput = new ChecksumIndexInput(directory.openInput(string));
        this.lastGeneration = this.generation = SegmentInfos.generationFromSegmentsFileName(string);
        try {
            long l;
            long l2;
            int n = checksumIndexInput.readInt();
            if (n > -1) {
                throw new IndexFormatTooOldException(checksumIndexInput, n, -1, -11);
            }
            if (n < -11) {
                throw new IndexFormatTooNewException(checksumIndexInput, n, -1, -11);
            }
            this.version = checksumIndexInput.readLong();
            this.counter = checksumIndexInput.readInt();
            for (int i = checksumIndexInput.readInt(); i > 0; --i) {
                SegmentInfo segmentInfo = new SegmentInfo(directory, n, checksumIndexInput);
                if (segmentInfo.getVersion() == null) {
                    Directory directory2 = directory;
                    if (segmentInfo.getDocStoreOffset() != -1) {
                        if (segmentInfo.getDocStoreIsCompoundFile()) {
                            directory2 = new CompoundFileReader(directory2, IndexFileNames.segmentFileName(segmentInfo.getDocStoreSegment(), "cfx"), 1024);
                        }
                    } else if (segmentInfo.getUseCompoundFile()) {
                        directory2 = new CompoundFileReader(directory2, IndexFileNames.segmentFileName(segmentInfo.name, "cfs"), 1024);
                    }
                    try {
                        String string2 = segmentInfo.getDocStoreOffset() != -1 ? segmentInfo.getDocStoreSegment() : segmentInfo.name;
                        segmentInfo.setVersion(FieldsReader.detectCodeVersion(directory2, string2));
                    }
                    finally {
                        if (directory2 != directory) {
                            directory2.close();
                        }
                    }
                }
                this.add(segmentInfo);
            }
            if (n >= 0) {
                this.version = checksumIndexInput.getFilePointer() >= checksumIndexInput.length() ? System.currentTimeMillis() : checksumIndexInput.readLong();
            }
            this.userData = n <= -8 ? (n <= -9 ? checksumIndexInput.readStringStringMap() : (0 != checksumIndexInput.readByte() ? Collections.singletonMap("userData", checksumIndexInput.readString()) : Collections.emptyMap())) : Collections.emptyMap();
            if (n <= -5 && (l2 = checksumIndexInput.getChecksum()) != (l = checksumIndexInput.readLong())) {
                throw new CorruptIndexException("checksum mismatch in segments file (resource: " + checksumIndexInput + ")");
            }
            bl = true;
        }
        finally {
            checksumIndexInput.close();
            if (!bl) {
                this.clear();
            }
        }
    }

    public final void read(Directory directory) throws CorruptIndexException, IOException {
        this.lastGeneration = -1L;
        this.generation = -1L;
        new FindSegmentsFile(directory){

            @Override
            protected Object doBody(String string) throws CorruptIndexException, IOException {
                SegmentInfos.this.read(this.directory, string);
                return null;
            }
        }.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void write(Directory directory) throws IOException {
        String string = this.getNextSegmentFileName();
        this.generation = this.generation == -1L ? 1L : ++this.generation;
        ChecksumIndexOutput checksumIndexOutput = new ChecksumIndexOutput(directory.createOutput(string));
        boolean bl = false;
        try {
            checksumIndexOutput.writeInt(-11);
            checksumIndexOutput.writeLong(this.version);
            checksumIndexOutput.writeInt(this.counter);
            checksumIndexOutput.writeInt(this.size());
            for (SegmentInfo segmentInfo : this) {
                segmentInfo.write(checksumIndexOutput);
            }
            checksumIndexOutput.writeStringStringMap(this.userData);
            checksumIndexOutput.prepareCommit();
            this.pendingSegnOutput = checksumIndexOutput;
            return;
        }
        catch (Throwable throwable) {
            if (bl) throw throwable;
            IOUtils.closeWhileHandlingException(checksumIndexOutput);
            try {
                directory.deleteFile(string);
                throw throwable;
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void pruneDeletedSegments() throws IOException {
        Iterator<SegmentInfo> iterator = this.segments.iterator();
        while (iterator.hasNext()) {
            SegmentInfo segmentInfo = iterator.next();
            if (segmentInfo.getDelCount() != segmentInfo.docCount) continue;
            iterator.remove();
            this.segmentSet.remove(segmentInfo);
        }
        assert (this.segmentSet.size() == this.segments.size());
    }

    public Object clone() {
        try {
            SegmentInfos segmentInfos = (SegmentInfos)super.clone();
            segmentInfos.segments = new ArrayList<SegmentInfo>(this.size());
            segmentInfos.segmentSet = new HashSet<SegmentInfo>(this.size());
            segmentInfos.cachedUnmodifiableList = null;
            segmentInfos.cachedUnmodifiableSet = null;
            for (SegmentInfo segmentInfo : this) {
                segmentInfos.add((SegmentInfo)segmentInfo.clone());
            }
            segmentInfos.userData = new HashMap<String, String>(this.userData);
            return segmentInfos;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("should not happen", cloneNotSupportedException);
        }
    }

    public long getVersion() {
        return this.version;
    }

    public long getGeneration() {
        return this.generation;
    }

    public long getLastGeneration() {
        return this.lastGeneration;
    }

    public static long readCurrentVersion(Directory directory) throws CorruptIndexException, IOException {
        SegmentInfos segmentInfos = new SegmentInfos();
        segmentInfos.read(directory);
        return segmentInfos.version;
    }

    public static Map<String, String> readCurrentUserData(Directory directory) throws CorruptIndexException, IOException {
        SegmentInfos segmentInfos = new SegmentInfos();
        segmentInfos.read(directory);
        return segmentInfos.getUserData();
    }

    public static void setInfoStream(PrintStream printStream) {
        infoStream = printStream;
    }

    public static void setDefaultGenFileRetryCount(int n) {
        defaultGenFileRetryCount = n;
    }

    public static int getDefaultGenFileRetryCount() {
        return defaultGenFileRetryCount;
    }

    public static void setDefaultGenFileRetryPauseMsec(int n) {
        defaultGenFileRetryPauseMsec = n;
    }

    public static int getDefaultGenFileRetryPauseMsec() {
        return defaultGenFileRetryPauseMsec;
    }

    public static void setDefaultGenLookaheadCount(int n) {
        defaultGenLookaheadCount = n;
    }

    public static int getDefaultGenLookahedCount() {
        return defaultGenLookaheadCount;
    }

    public static PrintStream getInfoStream() {
        return infoStream;
    }

    private static void message(String string) {
        infoStream.println("SIS [" + Thread.currentThread().getName() + "]: " + string);
    }

    @Deprecated
    public SegmentInfos range(int n, int n2) {
        SegmentInfos segmentInfos = new SegmentInfos();
        segmentInfos.addAll(this.segments.subList(n, n2));
        return segmentInfos;
    }

    void updateGeneration(SegmentInfos segmentInfos) {
        this.lastGeneration = segmentInfos.lastGeneration;
        this.generation = segmentInfos.generation;
    }

    final void rollbackCommit(Directory directory) throws IOException {
        if (this.pendingSegnOutput != null) {
            try {
                this.pendingSegnOutput.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                String string = IndexFileNames.fileNameFromGeneration("segments", "", this.generation);
                directory.deleteFile(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.pendingSegnOutput = null;
        }
    }

    final void prepareCommit(Directory directory) throws IOException {
        if (this.pendingSegnOutput != null) {
            throw new IllegalStateException("prepareCommit was already called");
        }
        this.write(directory);
    }

    public Collection<String> files(Directory directory, boolean bl) throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        if (bl) {
            hashSet.add(this.getCurrentSegmentFileName());
        }
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            SegmentInfo segmentInfo = this.info(i);
            if (segmentInfo.dir != directory) continue;
            hashSet.addAll(this.info(i).files());
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void finishCommit(Directory directory) throws IOException {
        if (this.pendingSegnOutput == null) {
            throw new IllegalStateException("prepareCommit was not called");
        }
        boolean bl = false;
        try {
            this.pendingSegnOutput.finishCommit();
            this.pendingSegnOutput.close();
            this.pendingSegnOutput = null;
            bl = true;
        }
        finally {
            if (!bl) {
                this.rollbackCommit(directory);
            }
        }
        String string = IndexFileNames.fileNameFromGeneration("segments", "", this.generation);
        bl = false;
        try {
            directory.sync(Collections.singleton(string));
            bl = true;
        }
        finally {
            if (!bl) {
                try {
                    directory.deleteFile(string);
                }
                catch (Throwable throwable) {}
            }
        }
        this.lastGeneration = this.generation;
        try {
            IndexOutput indexOutput = directory.createOutput("segments.gen");
            try {
                indexOutput.writeInt(-2);
                indexOutput.writeLong(this.generation);
                indexOutput.writeLong(this.generation);
            }
            finally {
                indexOutput.close();
            }
        }
        catch (ThreadInterruptedException threadInterruptedException) {
            throw threadInterruptedException;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    final void commit(Directory directory) throws IOException {
        this.prepareCommit(directory);
        this.finishCommit(directory);
    }

    public String toString(Directory directory) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getCurrentSegmentFileName()).append(": ");
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(' ');
            }
            SegmentInfo segmentInfo = this.info(i);
            stringBuilder.append(segmentInfo.toString(directory, 0));
        }
        return stringBuilder.toString();
    }

    public Map<String, String> getUserData() {
        return this.userData;
    }

    void setUserData(Map<String, String> map) {
        this.userData = map == null ? Collections.emptyMap() : map;
    }

    void replace(SegmentInfos segmentInfos) {
        this.rollbackSegmentInfos(segmentInfos.asList());
        this.lastGeneration = segmentInfos.lastGeneration;
    }

    public int totalDocCount() {
        int n = 0;
        for (SegmentInfo segmentInfo : this) {
            n += segmentInfo.docCount;
        }
        return n;
    }

    public void changed() {
        ++this.version;
    }

    void applyMergeChanges(MergePolicy.OneMerge oneMerge, boolean bl) {
        HashSet<SegmentInfo> hashSet = new HashSet<SegmentInfo>(oneMerge.segments);
        boolean bl2 = false;
        int n = 0;
        int n2 = this.segments.size();
        for (int i = 0; i < n2; ++i) {
            assert (i >= n);
            SegmentInfo segmentInfo = this.segments.get(i);
            if (hashSet.contains(segmentInfo)) {
                if (bl2 || bl) continue;
                this.segments.set(i, oneMerge.info);
                bl2 = true;
                ++n;
                continue;
            }
            this.segments.set(n, segmentInfo);
            ++n;
        }
        if (!bl2 && !bl) {
            this.segments.add(0, oneMerge.info);
        }
        this.segments.subList(n, this.segments.size()).clear();
        if (!bl) {
            this.segmentSet.add(oneMerge.info);
        }
        this.segmentSet.removeAll(hashSet);
        assert (this.segmentSet.size() == this.segments.size());
    }

    List<SegmentInfo> createBackupSegmentInfos(boolean bl) {
        if (bl) {
            ArrayList<SegmentInfo> arrayList = new ArrayList<SegmentInfo>(this.size());
            for (SegmentInfo segmentInfo : this) {
                arrayList.add((SegmentInfo)segmentInfo.clone());
            }
            return arrayList;
        }
        return new ArrayList<SegmentInfo>(this.segments);
    }

    void rollbackSegmentInfos(List<SegmentInfo> list) {
        this.clear();
        this.addAll(list);
    }

    @Override
    public Iterator<SegmentInfo> iterator() {
        return this.asList().iterator();
    }

    public List<SegmentInfo> asList() {
        if (this.cachedUnmodifiableList == null) {
            this.cachedUnmodifiableList = Collections.unmodifiableList(this.segments);
        }
        return this.cachedUnmodifiableList;
    }

    public Set<SegmentInfo> asSet() {
        if (this.cachedUnmodifiableSet == null) {
            this.cachedUnmodifiableSet = Collections.unmodifiableSet(this.segmentSet);
        }
        return this.cachedUnmodifiableSet;
    }

    public int size() {
        return this.segments.size();
    }

    public void add(SegmentInfo segmentInfo) {
        if (this.segmentSet.contains(segmentInfo)) {
            throw new IllegalStateException("Cannot add the same segment two times to this SegmentInfos instance");
        }
        this.segments.add(segmentInfo);
        this.segmentSet.add(segmentInfo);
        assert (this.segmentSet.size() == this.segments.size());
    }

    public void addAll(Iterable<SegmentInfo> iterable) {
        for (SegmentInfo segmentInfo : iterable) {
            this.add(segmentInfo);
        }
    }

    public void clear() {
        this.segments.clear();
        this.segmentSet.clear();
    }

    public void remove(SegmentInfo segmentInfo) {
        int n = this.indexOf(segmentInfo);
        if (n >= 0) {
            this.remove(n);
        }
    }

    public void remove(int n) {
        this.segmentSet.remove(this.segments.remove(n));
        assert (this.segmentSet.size() == this.segments.size());
    }

    public boolean contains(SegmentInfo segmentInfo) {
        return this.segmentSet.contains(segmentInfo);
    }

    public int indexOf(SegmentInfo segmentInfo) {
        if (this.segmentSet.contains(segmentInfo)) {
            return this.segments.indexOf(segmentInfo);
        }
        return -1;
    }

    public static abstract class FindSegmentsFile {
        final Directory directory;

        public FindSegmentsFile(Directory directory) {
            this.directory = directory;
        }

        public Object run() throws CorruptIndexException, IOException {
            return this.run(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object run(IndexCommit indexCommit) throws CorruptIndexException, IOException {
            if (indexCommit != null) {
                if (this.directory == indexCommit.getDirectory()) return this.doBody(indexCommit.getSegmentsFileName());
                throw new IOException("the specified commit does not match the specified Directory");
            }
            String string = null;
            long l = -1L;
            long l2 = 0L;
            int n = 0;
            IOException iOException = null;
            int n2 = 0;
            boolean bl = true;
            while (true) {
                Object[] objectArray;
                if (bl) {
                    objectArray = null;
                    long l3 = -1L;
                    objectArray = this.directory.listAll();
                    if (objectArray != null) {
                        l3 = SegmentInfos.getCurrentSegmentGeneration((String[])objectArray);
                    }
                    if (infoStream != null) {
                        SegmentInfos.message("directory listing genA=" + l3);
                    }
                    long l4 = -1L;
                    for (int i = 0; i < defaultGenFileRetryCount; ++i) {
                        IndexInput indexInput;
                        block33: {
                            indexInput = null;
                            try {
                                indexInput = this.directory.openInput("segments.gen");
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                if (infoStream == null) break;
                                SegmentInfos.message("segments.gen open: FileNotFoundException " + fileNotFoundException);
                                break;
                            }
                            catch (IOException iOException2) {
                                if (infoStream == null) break block33;
                                SegmentInfos.message("segments.gen open: IOException " + iOException2);
                            }
                        }
                        if (indexInput != null) {
                            try {
                                int n3 = indexInput.readInt();
                                if (n3 == -2) {
                                    long l5 = indexInput.readLong();
                                    long l6 = indexInput.readLong();
                                    if (infoStream != null) {
                                        SegmentInfos.message("fallback check: " + l5 + "; " + l6);
                                    }
                                    if (l5 == l6) {
                                        l4 = l5;
                                        break;
                                    }
                                }
                            }
                            catch (IOException iOException3) {
                            }
                            finally {
                                indexInput.close();
                            }
                        }
                        try {
                            Thread.sleep(defaultGenFileRetryPauseMsec);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            throw new ThreadInterruptedException(interruptedException);
                        }
                    }
                    if (infoStream != null) {
                        SegmentInfos.message("segments.gen check: genB=" + l4);
                    }
                    if ((l2 = l3 > l4 ? l3 : l4) == -1L) {
                        throw new IndexNotFoundException("no segments* file found in " + this.directory + ": files: " + Arrays.toString(objectArray));
                    }
                }
                if (bl && l == l2 && n2 >= 2) {
                    bl = false;
                }
                if (!bl) {
                    if (n >= defaultGenLookaheadCount) throw iOException;
                    ++l2;
                    ++n;
                    if (infoStream != null) {
                        SegmentInfos.message("look ahead increment gen to " + l2);
                    }
                } else {
                    n2 = l == l2 ? ++n2 : 0;
                }
                l = l2;
                string = IndexFileNames.fileNameFromGeneration("segments", "", l2);
                try {
                    objectArray = this.doBody(string);
                    if (infoStream == null) return objectArray;
                    SegmentInfos.message("success on " + string);
                    return objectArray;
                }
                catch (IOException iOException4) {
                    String string2;
                    boolean bl2;
                    if (iOException == null) {
                        iOException = iOException4;
                    }
                    if (infoStream != null) {
                        SegmentInfos.message("primary Exception on '" + string + "': " + iOException4 + "'; will retry: retryCount=" + n2 + "; gen = " + l2);
                    }
                    if (l2 <= 1L || !bl || n2 != 1 || !(bl2 = this.directory.fileExists(string2 = IndexFileNames.fileNameFromGeneration("segments", "", l2 - 1L)))) continue;
                    if (infoStream != null) {
                        SegmentInfos.message("fallback to prior segment file '" + string2 + "'");
                    }
                    try {
                        Object object = this.doBody(string2);
                        if (infoStream == null) return object;
                        SegmentInfos.message("success on fallback " + string2);
                        return object;
                    }
                    catch (IOException iOException5) {
                        if (infoStream == null) continue;
                        SegmentInfos.message("secondary Exception on '" + string2 + "': " + iOException5 + "'; will retry");
                        continue;
                    }
                }
                break;
            }
        }

        protected abstract Object doBody(String var1) throws CorruptIndexException, IOException;
    }
}

