/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.ByteSliceReader;
import org.apache.lucene.index.CharBlockPool;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FreqProxTermsWriterPerField;

final class FreqProxFieldMergeState {
    final FreqProxTermsWriterPerField field;
    final int numPostings;
    final CharBlockPool charPool;
    final int[] termIDs;
    final FreqProxTermsWriterPerField.FreqProxPostingsArray postings;
    int currentTermID;
    char[] text;
    int textOffset;
    private int postingUpto = -1;
    final ByteSliceReader freq = new ByteSliceReader();
    final ByteSliceReader prox = new ByteSliceReader();
    int docID;
    int termFreq;

    public FreqProxFieldMergeState(FreqProxTermsWriterPerField freqProxTermsWriterPerField) {
        this.field = freqProxTermsWriterPerField;
        this.charPool = freqProxTermsWriterPerField.perThread.termsHashPerThread.charPool;
        this.numPostings = freqProxTermsWriterPerField.termsHashPerField.numPostings;
        this.termIDs = freqProxTermsWriterPerField.termsHashPerField.sortPostings();
        this.postings = (FreqProxTermsWriterPerField.FreqProxPostingsArray)freqProxTermsWriterPerField.termsHashPerField.postingsArray;
    }

    boolean nextTerm() throws IOException {
        ++this.postingUpto;
        if (this.postingUpto == this.numPostings) {
            return false;
        }
        this.currentTermID = this.termIDs[this.postingUpto];
        this.docID = 0;
        int n = this.postings.textStarts[this.currentTermID];
        this.text = this.charPool.buffers[n >> 14];
        this.textOffset = n & 0x3FFF;
        this.field.termsHashPerField.initReader(this.freq, this.currentTermID, 0);
        if (this.field.fieldInfo.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
            this.field.termsHashPerField.initReader(this.prox, this.currentTermID, 1);
        }
        boolean bl = this.nextDoc();
        assert (bl);
        return true;
    }

    public String termText() {
        int n = this.textOffset;
        while (this.text[n] != '\uffff') {
            ++n;
        }
        return new String(this.text, this.textOffset, n - this.textOffset);
    }

    public boolean nextDoc() throws IOException {
        if (this.freq.eof()) {
            if (this.postings.lastDocCodes[this.currentTermID] != -1) {
                this.docID = this.postings.lastDocIDs[this.currentTermID];
                if (this.field.indexOptions != FieldInfo.IndexOptions.DOCS_ONLY) {
                    this.termFreq = this.postings.docFreqs[this.currentTermID];
                }
                this.postings.lastDocCodes[this.currentTermID] = -1;
                return true;
            }
            return false;
        }
        int n = this.freq.readVInt();
        if (this.field.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY) {
            this.docID += n;
        } else {
            this.docID += n >>> 1;
            this.termFreq = (n & 1) != 0 ? 1 : this.freq.readVInt();
        }
        assert (this.docID != this.postings.lastDocIDs[this.currentTermID]);
        return true;
    }
}

