/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.MapBackedSet;

public class FilterIndexReader
extends IndexReader {
    protected IndexReader in;

    public FilterIndexReader(IndexReader indexReader) {
        this.in = indexReader;
        this.readerFinishedListeners = new MapBackedSet(new ConcurrentHashMap());
    }

    @Override
    public Directory directory() {
        this.ensureOpen();
        return this.in.directory();
    }

    @Override
    public TermFreqVector[] getTermFreqVectors(int n) throws IOException {
        this.ensureOpen();
        return this.in.getTermFreqVectors(n);
    }

    @Override
    public TermFreqVector getTermFreqVector(int n, String string) throws IOException {
        this.ensureOpen();
        return this.in.getTermFreqVector(n, string);
    }

    @Override
    public void getTermFreqVector(int n, String string, TermVectorMapper termVectorMapper) throws IOException {
        this.ensureOpen();
        this.in.getTermFreqVector(n, string, termVectorMapper);
    }

    @Override
    public void getTermFreqVector(int n, TermVectorMapper termVectorMapper) throws IOException {
        this.ensureOpen();
        this.in.getTermFreqVector(n, termVectorMapper);
    }

    @Override
    public int numDocs() {
        return this.in.numDocs();
    }

    @Override
    public int maxDoc() {
        return this.in.maxDoc();
    }

    @Override
    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        this.ensureOpen();
        return this.in.document(n, fieldSelector);
    }

    @Override
    public boolean isDeleted(int n) {
        return this.in.isDeleted(n);
    }

    @Override
    public boolean hasDeletions() {
        this.ensureOpen();
        return this.in.hasDeletions();
    }

    @Override
    protected void doUndeleteAll() throws CorruptIndexException, IOException {
        this.in.undeleteAll();
    }

    @Override
    public boolean hasNorms(String string) throws IOException {
        this.ensureOpen();
        return this.in.hasNorms(string);
    }

    @Override
    public byte[] norms(String string) throws IOException {
        this.ensureOpen();
        return this.in.norms(string);
    }

    @Override
    public void norms(String string, byte[] byArray, int n) throws IOException {
        this.ensureOpen();
        this.in.norms(string, byArray, n);
    }

    @Override
    protected void doSetNorm(int n, String string, byte by) throws CorruptIndexException, IOException {
        this.in.setNorm(n, string, by);
    }

    @Override
    public TermEnum terms() throws IOException {
        this.ensureOpen();
        return this.in.terms();
    }

    @Override
    public TermEnum terms(Term term) throws IOException {
        this.ensureOpen();
        return this.in.terms(term);
    }

    @Override
    public int docFreq(Term term) throws IOException {
        this.ensureOpen();
        return this.in.docFreq(term);
    }

    @Override
    public TermDocs termDocs() throws IOException {
        this.ensureOpen();
        return this.in.termDocs();
    }

    @Override
    public TermDocs termDocs(Term term) throws IOException {
        this.ensureOpen();
        return this.in.termDocs(term);
    }

    @Override
    public TermPositions termPositions() throws IOException {
        this.ensureOpen();
        return this.in.termPositions();
    }

    @Override
    protected void doDelete(int n) throws CorruptIndexException, IOException {
        this.in.deleteDocument(n);
    }

    @Override
    protected void doCommit(Map<String, String> map) throws IOException {
        this.in.commit(map);
    }

    @Override
    protected void doClose() throws IOException {
        this.in.close();
    }

    @Override
    public Collection<String> getFieldNames(IndexReader.FieldOption fieldOption) {
        this.ensureOpen();
        return this.in.getFieldNames(fieldOption);
    }

    @Override
    public long getVersion() {
        this.ensureOpen();
        return this.in.getVersion();
    }

    @Override
    public boolean isCurrent() throws CorruptIndexException, IOException {
        this.ensureOpen();
        return this.in.isCurrent();
    }

    @Override
    @Deprecated
    public boolean isOptimized() {
        this.ensureOpen();
        return this.in.isOptimized();
    }

    @Override
    public IndexReader[] getSequentialSubReaders() {
        return this.in.getSequentialSubReaders();
    }

    @Override
    public Map<String, String> getCommitUserData() {
        return this.in.getCommitUserData();
    }

    @Override
    public Object getCoreCacheKey() {
        return this.in.getCoreCacheKey();
    }

    @Override
    public Object getDeletesCacheKey() {
        return this.in.getDeletesCacheKey();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("FilterReader(");
        stringBuilder.append(this.in);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public void addReaderFinishedListener(IndexReader.ReaderFinishedListener readerFinishedListener) {
        super.addReaderFinishedListener(readerFinishedListener);
        this.in.addReaderFinishedListener(readerFinishedListener);
    }

    @Override
    public void removeReaderFinishedListener(IndexReader.ReaderFinishedListener readerFinishedListener) {
        super.removeReaderFinishedListener(readerFinishedListener);
        this.in.removeReaderFinishedListener(readerFinishedListener);
    }

    public static class FilterTermEnum
    extends TermEnum {
        protected TermEnum in;

        public FilterTermEnum(TermEnum termEnum) {
            this.in = termEnum;
        }

        @Override
        public boolean next() throws IOException {
            return this.in.next();
        }

        @Override
        public Term term() {
            return this.in.term();
        }

        @Override
        public int docFreq() {
            return this.in.docFreq();
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }

    public static class FilterTermPositions
    extends FilterTermDocs
    implements TermPositions {
        public FilterTermPositions(TermPositions termPositions) {
            super(termPositions);
        }

        @Override
        public int nextPosition() throws IOException {
            return ((TermPositions)this.in).nextPosition();
        }

        @Override
        public int getPayloadLength() {
            return ((TermPositions)this.in).getPayloadLength();
        }

        @Override
        public byte[] getPayload(byte[] byArray, int n) throws IOException {
            return ((TermPositions)this.in).getPayload(byArray, n);
        }

        @Override
        public boolean isPayloadAvailable() {
            return ((TermPositions)this.in).isPayloadAvailable();
        }
    }

    public static class FilterTermDocs
    implements TermDocs {
        protected TermDocs in;

        public FilterTermDocs(TermDocs termDocs) {
            this.in = termDocs;
        }

        @Override
        public void seek(Term term) throws IOException {
            this.in.seek(term);
        }

        @Override
        public void seek(TermEnum termEnum) throws IOException {
            this.in.seek(termEnum);
        }

        @Override
        public int doc() {
            return this.in.doc();
        }

        @Override
        public int freq() {
            return this.in.freq();
        }

        @Override
        public boolean next() throws IOException {
            return this.in.next();
        }

        @Override
        public int read(int[] nArray, int[] nArray2) throws IOException {
            return this.in.read(nArray, nArray2);
        }

        @Override
        public boolean skipTo(int n) throws IOException {
            return this.in.skipTo(n);
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }
}

