/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.apache.lucene.index.DocConsumer;
import org.apache.lucene.index.DocConsumerPerThread;
import org.apache.lucene.index.DocFieldConsumer;
import org.apache.lucene.index.DocFieldConsumerPerField;
import org.apache.lucene.index.DocFieldConsumerPerThread;
import org.apache.lucene.index.DocFieldProcessorPerThread;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.DocumentsWriterThreadState;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.StoredFieldsWriter;

final class DocFieldProcessor
extends DocConsumer {
    final DocumentsWriter docWriter;
    final FieldInfos fieldInfos;
    final DocFieldConsumer consumer;
    final StoredFieldsWriter fieldsWriter;

    public DocFieldProcessor(DocumentsWriter documentsWriter, DocFieldConsumer docFieldConsumer) {
        this.docWriter = documentsWriter;
        this.consumer = docFieldConsumer;
        this.fieldInfos = documentsWriter.getFieldInfos();
        docFieldConsumer.setFieldInfos(this.fieldInfos);
        this.fieldsWriter = new StoredFieldsWriter(documentsWriter, this.fieldInfos);
    }

    @Override
    public void flush(Collection<DocConsumerPerThread> collection, SegmentWriteState segmentWriteState) throws IOException {
        HashMap<DocFieldConsumerPerThread, Collection<DocFieldConsumerPerField>> hashMap = new HashMap<DocFieldConsumerPerThread, Collection<DocFieldConsumerPerField>>();
        for (DocConsumerPerThread docConsumerPerThread : collection) {
            DocFieldProcessorPerThread docFieldProcessorPerThread = (DocFieldProcessorPerThread)docConsumerPerThread;
            hashMap.put(docFieldProcessorPerThread.consumer, docFieldProcessorPerThread.fields());
            docFieldProcessorPerThread.trimFields(segmentWriteState);
        }
        this.fieldsWriter.flush(segmentWriteState);
        this.consumer.flush(hashMap, segmentWriteState);
        String string = IndexFileNames.segmentFileName(segmentWriteState.segmentName, "fnm");
        this.fieldInfos.write(segmentWriteState.directory, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        try {
            this.fieldsWriter.abort();
        }
        finally {
            this.consumer.abort();
        }
    }

    @Override
    public boolean freeRAM() {
        return this.consumer.freeRAM();
    }

    @Override
    public DocConsumerPerThread addThread(DocumentsWriterThreadState documentsWriterThreadState) throws IOException {
        return new DocFieldProcessorPerThread(documentsWriterThreadState, this);
    }
}

