/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;

public final class CompoundFileWriter {
    static final int FORMAT_PRE_VERSION = 0;
    static final int FORMAT_NO_SEGMENT_PREFIX = -1;
    static final int FORMAT_CURRENT = -1;
    private Directory directory;
    private String fileName;
    private HashSet<String> ids;
    private LinkedList<FileEntry> entries;
    private boolean merged = false;
    private SegmentMerger.CheckAbort checkAbort;

    public CompoundFileWriter(Directory directory, String string) {
        this(directory, string, null);
    }

    CompoundFileWriter(Directory directory, String string, SegmentMerger.CheckAbort checkAbort) {
        if (directory == null) {
            throw new NullPointerException("directory cannot be null");
        }
        if (string == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.checkAbort = checkAbort;
        this.directory = directory;
        this.fileName = string;
        this.ids = new HashSet();
        this.entries = new LinkedList();
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public String getName() {
        return this.fileName;
    }

    public void addFile(String string) {
        this.addFile(string, this.directory);
    }

    public void addFile(String string, Directory directory) {
        if (this.merged) {
            throw new IllegalStateException("Can't add extensions after merge has been called");
        }
        if (string == null) {
            throw new NullPointerException("file cannot be null");
        }
        if (!this.ids.add(string)) {
            throw new IllegalArgumentException("File " + string + " already added");
        }
        FileEntry fileEntry = new FileEntry();
        fileEntry.file = string;
        fileEntry.dir = directory;
        this.entries.add(fileEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.merged) {
            throw new IllegalStateException("Merge already performed");
        }
        if (this.entries.isEmpty()) {
            throw new IllegalStateException("No entries to merge have been defined");
        }
        this.merged = true;
        IndexOutput indexOutput = this.directory.createOutput(this.fileName);
        IOException iOException = null;
        try {
            indexOutput.writeVInt(-1);
            indexOutput.writeVInt(this.entries.size());
            long l = 0L;
            for (FileEntry fileEntry : this.entries) {
                fileEntry.directoryOffset = indexOutput.getFilePointer();
                indexOutput.writeLong(0L);
                indexOutput.writeString(IndexFileNames.stripSegmentName(fileEntry.file));
                l += fileEntry.dir.fileLength(fileEntry.file);
            }
            long l2 = l + indexOutput.getFilePointer();
            indexOutput.setLength(l2);
            for (FileEntry fileEntry : this.entries) {
                fileEntry.dataOffset = indexOutput.getFilePointer();
                this.copyFile(fileEntry, indexOutput);
            }
            for (FileEntry fileEntry : this.entries) {
                indexOutput.seek(fileEntry.directoryOffset);
                indexOutput.writeLong(fileEntry.dataOffset);
            }
            assert (l2 == indexOutput.length());
            IndexOutput indexOutput2 = indexOutput;
            indexOutput = null;
            indexOutput2.close();
        }
        catch (IOException iOException2) {
            try {
                iOException = iOException2;
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(iOException, indexOutput);
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(iOException, indexOutput);
        }
        IOUtils.closeWhileHandlingException(iOException, indexOutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(FileEntry fileEntry, IndexOutput indexOutput) throws IOException {
        IndexInput indexInput = fileEntry.dir.openInput(fileEntry.file);
        try {
            long l;
            long l2;
            long l3 = indexOutput.getFilePointer();
            long l4 = indexInput.length();
            indexOutput.copyBytes(indexInput, l4);
            if (this.checkAbort != null) {
                this.checkAbort.work(l4);
            }
            if ((l2 = (l = indexOutput.getFilePointer()) - l3) != l4) {
                throw new IOException("Difference in the output file offsets " + l2 + " does not match the original file length " + l4);
            }
        }
        finally {
            indexInput.close();
        }
    }

    private static final class FileEntry {
        String file;
        long directoryOffset;
        long dataOffset;
        Directory dir;

        private FileEntry() {
        }
    }
}

