/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;

public abstract class AbstractAllTermDocs
implements TermDocs {
    protected int maxDoc;
    protected int doc = -1;

    protected AbstractAllTermDocs(int n) {
        this.maxDoc = n;
    }

    @Override
    public void seek(Term term) throws IOException {
        if (term != null) {
            throw new UnsupportedOperationException();
        }
        this.doc = -1;
    }

    @Override
    public void seek(TermEnum termEnum) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int doc() {
        return this.doc;
    }

    @Override
    public int freq() {
        return 1;
    }

    @Override
    public boolean next() throws IOException {
        return this.skipTo(this.doc + 1);
    }

    @Override
    public int read(int[] nArray, int[] nArray2) throws IOException {
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n && this.doc < this.maxDoc) {
            if (!this.isDeleted(this.doc)) {
                nArray[n2] = this.doc;
                nArray2[n2] = 1;
                ++n2;
            }
            ++this.doc;
        }
        return n2;
    }

    @Override
    public boolean skipTo(int n) throws IOException {
        this.doc = n;
        while (this.doc < this.maxDoc) {
            if (!this.isDeleted(this.doc)) {
                return true;
            }
            ++this.doc;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
    }

    public abstract boolean isDeleted(int var1);
}

