/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.util.StringHelper;

public abstract class AbstractField
implements Fieldable {
    protected String name = "body";
    protected boolean storeTermVector = false;
    protected boolean storeOffsetWithTermVector = false;
    protected boolean storePositionWithTermVector = false;
    protected boolean omitNorms = false;
    protected boolean isStored = false;
    protected boolean isIndexed = true;
    protected boolean isTokenized = true;
    protected boolean isBinary = false;
    protected boolean lazy = false;
    protected FieldInfo.IndexOptions indexOptions = FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
    protected float boost = 1.0f;
    protected Object fieldsData = null;
    protected TokenStream tokenStream;
    protected int binaryLength;
    protected int binaryOffset;

    protected AbstractField() {
    }

    protected AbstractField(String string, Field.Store store, Field.Index index, Field.TermVector termVector) {
        if (string == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.name = StringHelper.intern(string);
        this.isStored = store.isStored();
        this.isIndexed = index.isIndexed();
        this.isTokenized = index.isAnalyzed();
        this.omitNorms = index.omitNorms();
        this.isBinary = false;
        this.setStoreTermVector(termVector);
    }

    @Override
    public void setBoost(float f) {
        this.boost = f;
    }

    @Override
    public float getBoost() {
        return this.boost;
    }

    @Override
    public String name() {
        return this.name;
    }

    protected void setStoreTermVector(Field.TermVector termVector) {
        this.storeTermVector = termVector.isStored();
        this.storePositionWithTermVector = termVector.withPositions();
        this.storeOffsetWithTermVector = termVector.withOffsets();
    }

    @Override
    public final boolean isStored() {
        return this.isStored;
    }

    @Override
    public final boolean isIndexed() {
        return this.isIndexed;
    }

    @Override
    public final boolean isTokenized() {
        return this.isTokenized;
    }

    @Override
    public final boolean isTermVectorStored() {
        return this.storeTermVector;
    }

    @Override
    public boolean isStoreOffsetWithTermVector() {
        return this.storeOffsetWithTermVector;
    }

    @Override
    public boolean isStorePositionWithTermVector() {
        return this.storePositionWithTermVector;
    }

    @Override
    public final boolean isBinary() {
        return this.isBinary;
    }

    @Override
    public byte[] getBinaryValue() {
        return this.getBinaryValue(null);
    }

    @Override
    public byte[] getBinaryValue(byte[] byArray) {
        if (this.isBinary || this.fieldsData instanceof byte[]) {
            return (byte[])this.fieldsData;
        }
        return null;
    }

    @Override
    public int getBinaryLength() {
        if (this.isBinary) {
            return this.binaryLength;
        }
        if (this.fieldsData instanceof byte[]) {
            return ((byte[])this.fieldsData).length;
        }
        return 0;
    }

    @Override
    public int getBinaryOffset() {
        return this.binaryOffset;
    }

    @Override
    public boolean getOmitNorms() {
        return this.omitNorms;
    }

    @Deprecated
    public boolean getOmitTermFreqAndPositions() {
        return this.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY;
    }

    @Override
    public FieldInfo.IndexOptions getIndexOptions() {
        return this.indexOptions;
    }

    @Override
    public void setOmitNorms(boolean bl) {
        this.omitNorms = bl;
    }

    @Deprecated
    public void setOmitTermFreqAndPositions(boolean bl) {
        this.indexOptions = bl ? FieldInfo.IndexOptions.DOCS_ONLY : FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
    }

    @Override
    public void setIndexOptions(FieldInfo.IndexOptions indexOptions) {
        this.indexOptions = indexOptions;
    }

    @Override
    public boolean isLazy() {
        return this.lazy;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isStored) {
            stringBuilder.append("stored");
        }
        if (this.isIndexed) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("indexed");
        }
        if (this.isTokenized) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("tokenized");
        }
        if (this.storeTermVector) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("termVector");
        }
        if (this.storeOffsetWithTermVector) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("termVectorOffsets");
        }
        if (this.storePositionWithTermVector) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("termVectorPosition");
        }
        if (this.isBinary) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("binary");
        }
        if (this.omitNorms) {
            stringBuilder.append(",omitNorms");
        }
        if (this.indexOptions != FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
            stringBuilder.append(",indexOptions=");
            stringBuilder.append((Object)this.indexOptions);
        }
        if (this.lazy) {
            stringBuilder.append(",lazy");
        }
        stringBuilder.append('<');
        stringBuilder.append(this.name);
        stringBuilder.append(':');
        if (this.fieldsData != null && !this.lazy) {
            stringBuilder.append(this.fieldsData);
        }
        stringBuilder.append('>');
        return stringBuilder.toString();
    }
}

