/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;

public abstract class ReusableAnalyzerBase
extends Analyzer {
    protected abstract TokenStreamComponents createComponents(String var1, Reader var2);

    @Override
    public final TokenStream reusableTokenStream(String string, Reader reader) throws IOException {
        TokenStreamComponents tokenStreamComponents = (TokenStreamComponents)this.getPreviousTokenStream();
        Reader reader2 = this.initReader(reader);
        if (tokenStreamComponents == null || !tokenStreamComponents.reset(reader2)) {
            tokenStreamComponents = this.createComponents(string, reader2);
            this.setPreviousTokenStream(tokenStreamComponents);
        }
        return tokenStreamComponents.getTokenStream();
    }

    @Override
    public final TokenStream tokenStream(String string, Reader reader) {
        return this.createComponents(string, this.initReader(reader)).getTokenStream();
    }

    protected Reader initReader(Reader reader) {
        return reader;
    }

    public static class TokenStreamComponents {
        protected final Tokenizer source;
        protected final TokenStream sink;

        public TokenStreamComponents(Tokenizer tokenizer, TokenStream tokenStream) {
            this.source = tokenizer;
            this.sink = tokenStream;
        }

        public TokenStreamComponents(Tokenizer tokenizer) {
            this.source = tokenizer;
            this.sink = tokenizer;
        }

        protected boolean reset(Reader reader) throws IOException {
            this.source.reset(reader);
            return true;
        }

        protected TokenStream getTokenStream() {
            return this.sink;
        }
    }
}

