/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import org.apache.lucene.analysis.BaseCharFilter;
import org.apache.lucene.analysis.CharReader;
import org.apache.lucene.analysis.CharStream;
import org.apache.lucene.analysis.NormalizeCharMap;

public class MappingCharFilter
extends BaseCharFilter {
    private final NormalizeCharMap normMap;
    private LinkedList<Character> buffer;
    private String replacement;
    private int charPointer;
    private int nextCharCounter;

    public MappingCharFilter(NormalizeCharMap normalizeCharMap, CharStream charStream) {
        super(charStream);
        this.normMap = normalizeCharMap;
    }

    public MappingCharFilter(NormalizeCharMap normalizeCharMap, Reader reader) {
        super(CharReader.get(reader));
        this.normMap = normalizeCharMap;
    }

    @Override
    public int read() throws IOException {
        block0: while (this.replacement == null || this.charPointer >= this.replacement.length()) {
            NormalizeCharMap normalizeCharMap;
            int n = this.nextChar();
            if (n == -1) {
                return -1;
            }
            NormalizeCharMap normalizeCharMap2 = normalizeCharMap = this.normMap.submap != null ? this.normMap.submap.get(Character.valueOf((char)n)) : null;
            if (normalizeCharMap == null) {
                return n;
            }
            NormalizeCharMap normalizeCharMap3 = this.match(normalizeCharMap);
            if (normalizeCharMap3 == null) {
                return n;
            }
            this.replacement = normalizeCharMap3.normStr;
            this.charPointer = 0;
            if (normalizeCharMap3.diff == 0) continue;
            int n2 = this.getLastCumulativeDiff();
            if (normalizeCharMap3.diff < 0) {
                int n3 = 0;
                while (true) {
                    if (n3 >= -normalizeCharMap3.diff) continue block0;
                    this.addOffCorrectMap(this.nextCharCounter + n3 - n2, n2 - 1 - n3);
                    ++n3;
                }
            }
            this.addOffCorrectMap(this.nextCharCounter - normalizeCharMap3.diff - n2, n2 + normalizeCharMap3.diff);
        }
        return this.replacement.charAt(this.charPointer++);
    }

    private int nextChar() throws IOException {
        ++this.nextCharCounter;
        if (this.buffer != null && !this.buffer.isEmpty()) {
            return this.buffer.removeFirst().charValue();
        }
        return this.input.read();
    }

    private void pushChar(int n) {
        --this.nextCharCounter;
        if (this.buffer == null) {
            this.buffer = new LinkedList();
        }
        this.buffer.addFirst(Character.valueOf((char)n));
    }

    private void pushLastChar(int n) {
        if (this.buffer == null) {
            this.buffer = new LinkedList();
        }
        this.buffer.addLast(Character.valueOf((char)n));
    }

    private NormalizeCharMap match(NormalizeCharMap normalizeCharMap) throws IOException {
        int n;
        NormalizeCharMap normalizeCharMap2 = null;
        if (normalizeCharMap.submap != null && (n = this.nextChar()) != -1) {
            NormalizeCharMap normalizeCharMap3 = normalizeCharMap.submap.get(Character.valueOf((char)n));
            if (normalizeCharMap3 != null) {
                normalizeCharMap2 = this.match(normalizeCharMap3);
            }
            if (normalizeCharMap2 == null) {
                this.pushChar(n);
            }
        }
        if (normalizeCharMap2 == null && normalizeCharMap.normStr != null) {
            normalizeCharMap2 = normalizeCharMap;
        }
        return normalizeCharMap2;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        char[] cArray2 = new char[n2];
        int n5 = this.input.read(cArray2, 0, n2);
        if (n5 != -1) {
            for (n4 = 0; n4 < n5; ++n4) {
                this.pushLastChar(cArray2[n4]);
            }
        }
        n5 = 0;
        for (n4 = n; n4 < n + n2 && (n3 = this.read()) != -1; ++n4) {
            cArray[n4] = (char)n3;
            ++n5;
        }
        return n5 == 0 ? -1 : n5;
    }
}

