/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.util.CharacterUtils;
import org.apache.lucene.util.Version;

public class CharArrayMap<V>
extends AbstractMap<Object, V> {
    private static final CharArrayMap<?> EMPTY_MAP = new EmptyCharArrayMap();
    private static final int INIT_SIZE = 8;
    private final CharacterUtils charUtils;
    private boolean ignoreCase;
    private int count;
    final Version matchVersion;
    char[][] keys;
    V[] values;
    private EntrySet entrySet = null;
    private CharArraySet keySet = null;

    public CharArrayMap(Version version, int n, boolean bl) {
        int n2;
        this.ignoreCase = bl;
        for (n2 = 8; n + (n >> 2) > n2; n2 <<= 1) {
        }
        this.keys = new char[n2][];
        this.values = new Object[n2];
        this.charUtils = CharacterUtils.getInstance(version);
        this.matchVersion = version;
    }

    public CharArrayMap(Version version, Map<?, ? extends V> map, boolean bl) {
        this(version, map.size(), bl);
        this.putAll(map);
    }

    private CharArrayMap(CharArrayMap<V> charArrayMap) {
        this.keys = charArrayMap.keys;
        this.values = charArrayMap.values;
        this.ignoreCase = charArrayMap.ignoreCase;
        this.count = charArrayMap.count;
        this.charUtils = charArrayMap.charUtils;
        this.matchVersion = charArrayMap.matchVersion;
    }

    @Override
    public void clear() {
        this.count = 0;
        Arrays.fill((Object[])this.keys, null);
        Arrays.fill(this.values, null);
    }

    public boolean containsKey(char[] cArray, int n, int n2) {
        return this.keys[this.getSlot(cArray, n, n2)] != null;
    }

    public boolean containsKey(CharSequence charSequence) {
        return this.keys[this.getSlot(charSequence)] != null;
    }

    @Override
    public boolean containsKey(Object object) {
        if (object instanceof char[]) {
            char[] cArray = (char[])object;
            return this.containsKey(cArray, 0, cArray.length);
        }
        return this.containsKey(object.toString());
    }

    public V get(char[] cArray, int n, int n2) {
        return this.values[this.getSlot(cArray, n, n2)];
    }

    public V get(CharSequence charSequence) {
        return this.values[this.getSlot(charSequence)];
    }

    @Override
    public V get(Object object) {
        if (object instanceof char[]) {
            char[] cArray = (char[])object;
            return this.get(cArray, 0, cArray.length);
        }
        return this.get(object.toString());
    }

    private int getSlot(char[] cArray, int n, int n2) {
        int n3 = this.getHashCode(cArray, n, n2);
        int n4 = n3 & this.keys.length - 1;
        char[] cArray2 = this.keys[n4];
        if (cArray2 != null && !this.equals(cArray, n, n2, cArray2)) {
            int n5 = (n3 >> 8) + n3 | 1;
            while ((cArray2 = this.keys[n4 = (n3 += n5) & this.keys.length - 1]) != null && !this.equals(cArray, n, n2, cArray2)) {
            }
        }
        return n4;
    }

    private int getSlot(CharSequence charSequence) {
        int n = this.getHashCode(charSequence);
        int n2 = n & this.keys.length - 1;
        char[] cArray = this.keys[n2];
        if (cArray != null && !this.equals(charSequence, cArray)) {
            int n3 = (n >> 8) + n | 1;
            while ((cArray = this.keys[n2 = (n += n3) & this.keys.length - 1]) != null && !this.equals(charSequence, cArray)) {
            }
        }
        return n2;
    }

    @Override
    public V put(CharSequence charSequence, V v) {
        return this.put(((Object)charSequence).toString(), v);
    }

    @Override
    public V put(Object object, V v) {
        if (object instanceof char[]) {
            return this.put((char[])object, v);
        }
        return this.put(object.toString(), v);
    }

    @Override
    public V put(String string, V v) {
        return this.put(string.toCharArray(), v);
    }

    @Override
    public V put(char[] cArray, V v) {
        int n;
        if (this.ignoreCase) {
            for (n = 0; n < cArray.length; n += Character.toChars(Character.toLowerCase(this.charUtils.codePointAt(cArray, n)), cArray, n)) {
            }
        }
        if (this.keys[n = this.getSlot(cArray, 0, cArray.length)] != null) {
            V v2 = this.values[n];
            this.values[n] = v;
            return v2;
        }
        this.keys[n] = cArray;
        this.values[n] = v;
        ++this.count;
        if (this.count + (this.count >> 2) > this.keys.length) {
            this.rehash();
        }
        return null;
    }

    private void rehash() {
        assert (this.keys.length == this.values.length);
        int n = 2 * this.keys.length;
        char[][] cArray = this.keys;
        V[] VArray = this.values;
        this.keys = new char[n][];
        this.values = new Object[n];
        for (int i = 0; i < cArray.length; ++i) {
            char[] cArray2 = cArray[i];
            if (cArray2 == null) continue;
            int n2 = this.getSlot(cArray2, 0, cArray2.length);
            this.keys[n2] = cArray2;
            this.values[n2] = VArray[i];
        }
    }

    private boolean equals(char[] cArray, int n, int n2, char[] cArray2) {
        if (n2 != cArray2.length) {
            return false;
        }
        int n3 = n + n2;
        if (this.ignoreCase) {
            int n4;
            for (int i = 0; i < n2; i += Character.charCount(n4)) {
                n4 = this.charUtils.codePointAt(cArray, n + i, n3);
                if (Character.toLowerCase(n4) == this.charUtils.codePointAt(cArray2, i)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                if (cArray[n + i] == cArray2[i]) continue;
                return false;
            }
        }
        return true;
    }

    private boolean equals(CharSequence charSequence, char[] cArray) {
        int n = charSequence.length();
        if (n != cArray.length) {
            return false;
        }
        if (this.ignoreCase) {
            int n2;
            for (int i = 0; i < n; i += Character.charCount(n2)) {
                n2 = this.charUtils.codePointAt(charSequence, i);
                if (Character.toLowerCase(n2) == this.charUtils.codePointAt(cArray, i)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (charSequence.charAt(i) == cArray[i]) continue;
                return false;
            }
        }
        return true;
    }

    private int getHashCode(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new NullPointerException();
        }
        int n3 = 0;
        int n4 = n + n2;
        if (this.ignoreCase) {
            int n5;
            for (int i = n; i < n4; i += Character.charCount(n5)) {
                n5 = this.charUtils.codePointAt(cArray, i, n4);
                n3 = n3 * 31 + Character.toLowerCase(n5);
            }
        } else {
            for (int i = n; i < n4; ++i) {
                n3 = n3 * 31 + cArray[i];
            }
        }
        return n3;
    }

    private int getHashCode(CharSequence charSequence) {
        if (charSequence == null) {
            throw new NullPointerException();
        }
        int n = 0;
        int n2 = charSequence.length();
        if (this.ignoreCase) {
            int n3;
            for (int i = 0; i < n2; i += Character.charCount(n3)) {
                n3 = this.charUtils.codePointAt(charSequence, i);
                n = n * 31 + Character.toLowerCase(n3);
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                n = n * 31 + charSequence.charAt(i);
            }
        }
        return n;
    }

    @Override
    public V remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        for (Map.Entry entry : this.entrySet()) {
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry);
        }
        return stringBuilder.append('}').toString();
    }

    EntrySet createEntrySet() {
        return new EntrySet(true);
    }

    public final EntrySet entrySet() {
        if (this.entrySet == null) {
            this.entrySet = this.createEntrySet();
        }
        return this.entrySet;
    }

    final Set<Object> originalKeySet() {
        return super.keySet();
    }

    public final CharArraySet keySet() {
        if (this.keySet == null) {
            this.keySet = new CharArraySet(this){

                @Override
                public boolean add(Object object) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean add(CharSequence charSequence) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean add(String string) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean add(char[] cArray) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return this.keySet;
    }

    public static <V> CharArrayMap<V> unmodifiableMap(CharArrayMap<V> charArrayMap) {
        if (charArrayMap == null) {
            throw new NullPointerException("Given map is null");
        }
        if (charArrayMap == CharArrayMap.emptyMap() || charArrayMap.isEmpty()) {
            return CharArrayMap.emptyMap();
        }
        if (charArrayMap instanceof UnmodifiableCharArrayMap) {
            return charArrayMap;
        }
        return new UnmodifiableCharArrayMap<V>(charArrayMap);
    }

    public static <V> CharArrayMap<V> copy(Version version, Map<?, ? extends V> map) {
        if (map == EMPTY_MAP) {
            return CharArrayMap.emptyMap();
        }
        if (map instanceof CharArrayMap) {
            CharArrayMap<V> charArrayMap = (CharArrayMap<V>)map;
            char[][] cArrayArray = new char[charArrayMap.keys.length][];
            System.arraycopy(charArrayMap.keys, 0, cArrayArray, 0, cArrayArray.length);
            Object[] objectArray = new Object[charArrayMap.values.length];
            System.arraycopy(charArrayMap.values, 0, objectArray, 0, objectArray.length);
            charArrayMap = new CharArrayMap<V>(charArrayMap);
            charArrayMap.keys = cArrayArray;
            charArrayMap.values = objectArray;
            return charArrayMap;
        }
        return new CharArrayMap<V>(version, map, false);
    }

    public static <V> CharArrayMap<V> emptyMap() {
        return EMPTY_MAP;
    }

    private static final class EmptyCharArrayMap<V>
    extends UnmodifiableCharArrayMap<V> {
        EmptyCharArrayMap() {
            super(new CharArrayMap(Version.LUCENE_CURRENT, 0, false));
        }

        @Override
        public boolean containsKey(char[] cArray, int n, int n2) {
            if (cArray == null) {
                throw new NullPointerException();
            }
            return false;
        }

        @Override
        public boolean containsKey(CharSequence charSequence) {
            if (charSequence == null) {
                throw new NullPointerException();
            }
            return false;
        }

        @Override
        public boolean containsKey(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            return false;
        }

        @Override
        public V get(char[] cArray, int n, int n2) {
            if (cArray == null) {
                throw new NullPointerException();
            }
            return null;
        }

        @Override
        public V get(CharSequence charSequence) {
            if (charSequence == null) {
                throw new NullPointerException();
            }
            return null;
        }

        @Override
        public V get(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            return null;
        }
    }

    static class UnmodifiableCharArrayMap<V>
    extends CharArrayMap<V> {
        UnmodifiableCharArrayMap(CharArrayMap<V> charArrayMap) {
            super(charArrayMap);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V put(Object object, V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V put(char[] cArray, V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V put(CharSequence charSequence, V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V put(String string, V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        EntrySet createEntrySet() {
            return new EntrySet(false);
        }
    }

    public final class EntrySet
    extends AbstractSet<Map.Entry<Object, V>> {
        private final boolean allowModify;

        private EntrySet(boolean bl) {
            this.allowModify = bl;
        }

        public EntryIterator iterator() {
            return new EntryIterator(this.allowModify);
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            Object v = entry.getValue();
            Object v2 = CharArrayMap.this.get(k);
            return v2 == null ? v == null : v2.equals(v);
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return CharArrayMap.this.count;
        }

        @Override
        public void clear() {
            if (!this.allowModify) {
                throw new UnsupportedOperationException();
            }
            CharArrayMap.this.clear();
        }
    }

    private final class MapEntry
    implements Map.Entry<Object, V> {
        private final int pos;
        private final boolean allowModify;

        private MapEntry(int n, boolean bl) {
            this.pos = n;
            this.allowModify = bl;
        }

        @Override
        public Object getKey() {
            return CharArrayMap.this.keys[this.pos].clone();
        }

        @Override
        public V getValue() {
            return CharArrayMap.this.values[this.pos];
        }

        @Override
        public V setValue(V v) {
            if (!this.allowModify) {
                throw new UnsupportedOperationException();
            }
            Object v2 = CharArrayMap.this.values[this.pos];
            CharArrayMap.this.values[this.pos] = v;
            return v2;
        }

        public String toString() {
            return CharArrayMap.this.keys[this.pos] + '=' + (CharArrayMap.this.values[this.pos] == CharArrayMap.this ? "(this Map)" : CharArrayMap.this.values[this.pos]);
        }
    }

    public class EntryIterator
    implements Iterator<Map.Entry<Object, V>> {
        private int pos = -1;
        private int lastPos;
        private final boolean allowModify;

        private EntryIterator(boolean bl) {
            this.allowModify = bl;
            this.goNext();
        }

        private void goNext() {
            this.lastPos = this.pos++;
            while (this.pos < CharArrayMap.this.keys.length && CharArrayMap.this.keys[this.pos] == null) {
                ++this.pos;
            }
        }

        @Override
        public boolean hasNext() {
            return this.pos < CharArrayMap.this.keys.length;
        }

        public char[] nextKey() {
            this.goNext();
            return CharArrayMap.this.keys[this.lastPos];
        }

        public String nextKeyString() {
            return new String(this.nextKey());
        }

        public V currentValue() {
            return CharArrayMap.this.values[this.lastPos];
        }

        public V setValue(V v) {
            if (!this.allowModify) {
                throw new UnsupportedOperationException();
            }
            Object v2 = CharArrayMap.this.values[this.lastPos];
            CharArrayMap.this.values[this.lastPos] = v;
            return v2;
        }

        @Override
        public Map.Entry<Object, V> next() {
            this.goNext();
            return new MapEntry(this.lastPos, this.allowModify);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

