/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Modifier;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.CloseableThreadLocal;

public abstract class Analyzer
implements Closeable {
    private CloseableThreadLocal<Object> tokenStreams = new CloseableThreadLocal();

    protected Analyzer() {
        assert (this.assertFinal());
    }

    private boolean assertFinal() {
        try {
            Class<?> clazz = this.getClass();
            if (!clazz.desiredAssertionStatus()) {
                return true;
            }
            assert (clazz.isAnonymousClass() || (clazz.getModifiers() & 0x12) != 0 || Modifier.isFinal(clazz.getMethod("tokenStream", String.class, Reader.class).getModifiers()) && Modifier.isFinal(clazz.getMethod("reusableTokenStream", String.class, Reader.class).getModifiers())) : "Analyzer implementation classes or at least their tokenStream() and reusableTokenStream() implementations must be final";
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public abstract TokenStream tokenStream(String var1, Reader var2);

    public TokenStream reusableTokenStream(String string, Reader reader) throws IOException {
        return this.tokenStream(string, reader);
    }

    protected Object getPreviousTokenStream() {
        try {
            return this.tokenStreams.get();
        }
        catch (NullPointerException nullPointerException) {
            if (this.tokenStreams == null) {
                throw new AlreadyClosedException("this Analyzer is closed");
            }
            throw nullPointerException;
        }
    }

    protected void setPreviousTokenStream(Object object) {
        try {
            this.tokenStreams.set(object);
        }
        catch (NullPointerException nullPointerException) {
            if (this.tokenStreams == null) {
                throw new AlreadyClosedException("this Analyzer is closed");
            }
            throw nullPointerException;
        }
    }

    public int getPositionIncrementGap(String string) {
        return 0;
    }

    public int getOffsetGap(Fieldable fieldable) {
        if (fieldable.isTokenized()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void close() {
        this.tokenStreams.close();
        this.tokenStreams = null;
    }
}

