/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.alexandria.db;

import com.frostwire.alexandria.InternetRadioStation;
import com.frostwire.alexandria.db.InternetRadioStationsData;
import com.frostwire.alexandria.db.LibraryDatabase;
import java.util.ArrayList;
import java.util.List;

public class InternetRadioStationDB {
    private InternetRadioStationDB() {
    }

    public static void fill(LibraryDatabase libraryDatabase, InternetRadioStation internetRadioStation) {
        List<List<Object>> list = libraryDatabase.query("SELECT internetRadioStationId, name, description, url, bitrate, type, website, genre, pls, bookmarked FROM InternetRadioStations WHERE internetRadioStationId = ?", internetRadioStation.getId());
        if (list.size() > 0) {
            List<Object> list2 = list.get(0);
            InternetRadioStationDB.fill(list2, internetRadioStation);
        }
    }

    public static void fill(List<Object> list, InternetRadioStation internetRadioStation) {
        int n = (Integer)list.get(0);
        String string = (String)list.get(1);
        String string2 = (String)list.get(2);
        String string3 = (String)list.get(3);
        String string4 = (String)list.get(4);
        String string5 = (String)list.get(5);
        String string6 = (String)list.get(6);
        String string7 = (String)list.get(7);
        String string8 = (String)list.get(8);
        boolean bl = (Boolean)list.get(9);
        internetRadioStation.setId(n);
        internetRadioStation.setName(string);
        internetRadioStation.setDescription(string2);
        internetRadioStation.setUrl(string3);
        internetRadioStation.setBitrate(string4);
        internetRadioStation.setType(string5);
        internetRadioStation.setWebsite(string6);
        internetRadioStation.setGenre(string7);
        internetRadioStation.setPls(string8);
        internetRadioStation.setBookmarked(bl);
    }

    public static void save(LibraryDatabase libraryDatabase, InternetRadioStation internetRadioStation) {
        if (internetRadioStation.getId() == -2) {
            return;
        }
        if (internetRadioStation.getId() == -1) {
            Object[] objectArray = InternetRadioStationDB.createInternetRadioStationInsertStatement(internetRadioStation);
            int n = libraryDatabase.insert((String)objectArray[0], (Object[])objectArray[1]);
            internetRadioStation.setId(n);
        } else {
            Object[] objectArray = InternetRadioStationDB.createInternetRadioStationUpdateStatement(internetRadioStation);
            libraryDatabase.update((String)objectArray[0], (Object[])objectArray[1]);
        }
    }

    public static void delete(LibraryDatabase libraryDatabase, InternetRadioStation internetRadioStation) {
        libraryDatabase.update("DELETE FROM InternetRadioStations WHERE internetRadioStationId = ?", internetRadioStation.getId());
    }

    public static List<InternetRadioStation> getInternetRadioStations(LibraryDatabase libraryDatabase) {
        List<List<Object>> list = libraryDatabase.query("SELECT internetRadioStationId, name, description, url, bitrate, type, website, genre, pls, bookmarked FROM InternetRadioStations", new Object[0]);
        ArrayList<InternetRadioStation> arrayList = new ArrayList<InternetRadioStation>(list.size());
        for (List<Object> list2 : list) {
            InternetRadioStation internetRadioStation = new InternetRadioStation(libraryDatabase);
            InternetRadioStationDB.fill(list2, internetRadioStation);
            arrayList.add(internetRadioStation);
        }
        return arrayList;
    }

    public static long getTotalRadioStations(LibraryDatabase libraryDatabase) {
        List<List<Object>> list = libraryDatabase.query("SELECT COUNT(*) FROM InternetRadioStations", new Object[0]);
        return list.size() > 0 ? (Long)list.get(0).get(0) : 0L;
    }

    public static void restoreDefaultRadioStations(LibraryDatabase libraryDatabase) {
        List<InternetRadioStation> list = InternetRadioStationDB.getInternetRadioStations(libraryDatabase);
        InternetRadioStationsData internetRadioStationsData = new InternetRadioStationsData();
        for (InternetRadioStation object : list) {
            internetRadioStationsData.add(object.getName(), object.getDescription(), object.getUrl(), object.getBitrate(), object.getType(), object.getWebsite(), object.getGenre(), object.getPls());
        }
        libraryDatabase.update("DELETE FROM InternetRadioStations", new Object[0]);
        for (List list2 : internetRadioStationsData.getData()) {
            libraryDatabase.update("INSERT INTO InternetRadioStations (name, description, url, bitrate, type, website, genre, pls, bookmarked) VALUES (LEFT(?, 10000), LEFT(?, 10000), LEFT(?, 10000), LEFT(?, 100), LEFT(?, 100), LEFT(?, 10000), LEFT(?, 10000), LEFT(?, 100000), false)", list2.toArray());
        }
    }

    private static Object[] createInternetRadioStationInsertStatement(InternetRadioStation internetRadioStation) {
        String string = "INSERT INTO InternetRadioStations (name, description, url, bitrate, type, website, genre, pls, bookmarked) VALUES (LEFT(?, 10000), LEFT(?, 10000), LEFT(?, 10000), LEFT(?, 100), LEFT(?, 100), LEFT(?, 10000), LEFT(?, 10000), LEFT(?, 100000), ?)";
        Object[] objectArray = new Object[]{internetRadioStation.getName(), internetRadioStation.getDescription(), internetRadioStation.getUrl(), internetRadioStation.getBitrate(), internetRadioStation.getType(), internetRadioStation.getWebsite(), internetRadioStation.getGenre(), internetRadioStation.getPls(), internetRadioStation.isBookmarked()};
        return new Object[]{string, objectArray};
    }

    private static Object[] createInternetRadioStationUpdateStatement(InternetRadioStation internetRadioStation) {
        String string = "UPDATE InternetRadioStations SET name = LEFT(?, 500), description = LEFT(?, 10000), url = LEFT(?, 10000), bitrate = LEFT(?, 100), type = LEFT(?, 100), website = LEFT(?, 10000), genre = LEFT(?, 10000), pls = LEFT(?, 100000), bookmarked = ? WHERE internetRadioStationId = ?";
        Object[] objectArray = new Object[]{internetRadioStation.getName(), internetRadioStation.getDescription(), internetRadioStation.getUrl(), internetRadioStation.getBitrate(), internetRadioStation.getType(), internetRadioStation.getWebsite(), internetRadioStation.getGenre(), internetRadioStation.getPls(), internetRadioStation.isBookmarked(), internetRadioStation.getId()};
        return new Object[]{string, objectArray};
    }
}

