/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.alexandria;

public final class LibraryUtils {
    private LibraryUtils() {
    }

    public static String luceneEncode(String string) {
        int n = string.length();
        string = string.replace("AND", " ").replace("OR", " ").replace("NOT", " ");
        StringBuilder stringBuilder = new StringBuilder(2 * n);
        for (int i = 0; i < n; ++i) {
            try {
                char c = string.charAt(i);
                switch (c) {
                    case '+': {
                        stringBuilder.append("\\+");
                        break;
                    }
                    case '-': {
                        stringBuilder.append("\\-");
                        break;
                    }
                    case '&': {
                        stringBuilder.append("\\&");
                        break;
                    }
                    case '|': {
                        stringBuilder.append("\\r");
                        break;
                    }
                    case '!': {
                        stringBuilder.append("\\!");
                        break;
                    }
                    case '(': {
                        stringBuilder.append("\\(");
                        break;
                    }
                    case ')': {
                        stringBuilder.append("\\)");
                        break;
                    }
                    case '{': {
                        stringBuilder.append("\\{");
                        break;
                    }
                    case '}': {
                        stringBuilder.append("\\}");
                        break;
                    }
                    case '[': {
                        stringBuilder.append("\\[");
                        break;
                    }
                    case ']': {
                        stringBuilder.append("\\]");
                        break;
                    }
                    case '^': {
                        stringBuilder.append("\\^");
                        break;
                    }
                    case '\"': {
                        stringBuilder.append("\\\"");
                        break;
                    }
                    case '~': {
                        stringBuilder.append("\\~");
                        break;
                    }
                    case '*': {
                        stringBuilder.append("\\*");
                        break;
                    }
                    case '?': {
                        stringBuilder.append("\\?");
                        break;
                    }
                    case ':': {
                        stringBuilder.append("\\:");
                        break;
                    }
                    case '\\': {
                        stringBuilder.append("\\\\");
                        break;
                    }
                    default: {
                        stringBuilder.append(c);
                        break;
                    }
                }
                continue;
            }
            catch (Throwable throwable) {
                break;
            }
        }
        return stringBuilder.toString().replaceAll("\\s+", " ");
    }

    public static String fuzzyLuceneQuery(String string) {
        String string2 = LibraryUtils.luceneEncode(string);
        String[] stringArray = string2.split(" ");
        if (stringArray.length == 0) {
            return string2;
        }
        if (stringArray.length == 1) {
            return string2 + "~";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuilder.append(stringArray[i] + "~ AND ");
        }
        stringBuilder.append(stringArray[stringArray.length - 1] + "~");
        return stringBuilder.toString().trim();
    }

    public static String wildcardLuceneQuery(String string) {
        String string2 = LibraryUtils.luceneEncode(string);
        String[] stringArray = string2.split(" ");
        if (stringArray.length == 0) {
            return string2;
        }
        if (stringArray.length == 1) {
            return string2 + "*";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuilder.append(stringArray[i] + "* AND ");
        }
        stringBuilder.append(stringArray[stringArray.length - 1] + "*");
        return stringBuilder.toString().trim();
    }
}

