/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.i18n;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.xnap.commons.i18n.I18n;

class I18nCache {
    private final Map i18nByPackage = Collections.synchronizedMap(new HashMap());

    I18nCache() {
    }

    public void clear() {
        this.i18nByPackage.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I18n get(String string, Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale is null");
        }
        List list = (List)this.i18nByPackage.get(string);
        if (list != null) {
            List list2 = list;
            synchronized (list2) {
                for (I18n i18n : list) {
                    if (!locale.equals(i18n.getLocale())) continue;
                    return i18n;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String string, I18n i18n) {
        List<I18n> list;
        Map map = this.i18nByPackage;
        synchronized (map) {
            list = (List<I18n>)this.i18nByPackage.get(string);
            if (list == null) {
                list = Collections.synchronizedList(new ArrayList(2));
                this.i18nByPackage.put(string, list);
            }
        }
        list.add(i18n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(Visitor visitor) {
        List[] listArray;
        Map map = this.i18nByPackage;
        synchronized (map) {
            listArray = this.i18nByPackage.values().toArray(new List[0]);
        }
        for (int i = 0; i < listArray.length; ++i) {
            List list;
            List list2 = list = listArray[i];
            synchronized (list2) {
                for (I18n i18n : list) {
                    visitor.visit(i18n);
                }
                continue;
            }
        }
    }

    public static interface Visitor {
        public void visit(I18n var1);
    }
}

