/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.i18n;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18n {
    private static final String CONTEXT_GLUE = "\u0004";
    private volatile ResourceBundle bundle;
    private volatile Locale sourceCodeLocale = Locale.ENGLISH;
    private String baseName;
    private ClassLoader loader;
    private volatile Locale locale;

    public I18n(ResourceBundle resourceBundle) {
        this.setResources(resourceBundle);
    }

    public I18n(String string, Locale locale, ClassLoader classLoader) {
        this.setResources(string, locale, classLoader);
    }

    public ResourceBundle getResources() {
        return this.bundle;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public synchronized void setResources(ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            throw new NullPointerException();
        }
        this.bundle = resourceBundle;
        this.baseName = null;
        this.locale = resourceBundle.getLocale();
        this.loader = null;
    }

    public synchronized void setResources(String string, Locale locale, ClassLoader classLoader) {
        this.bundle = ResourceBundle.getBundle(string, locale, classLoader);
        this.baseName = string;
        this.locale = locale;
        this.loader = classLoader;
    }

    public static final String marktr(String string) {
        return string;
    }

    public synchronized boolean setLocale(Locale locale) {
        if (this.baseName != null && this.loader != null) {
            this.setResources(this.baseName, locale, this.loader);
            return true;
        }
        this.locale = locale;
        return false;
    }

    public void setSourceCodeLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale must not be null");
        }
        this.sourceCodeLocale = locale;
    }

    public final String tr(String string) {
        try {
            return this.bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public final String tr(String string, Object[] objectArray) {
        return MessageFormat.format(this.tr(string), objectArray);
    }

    public final String tr(String string, Object object) {
        return this.tr(string, new Object[]{object});
    }

    public final String tr(String string, Object object, Object object2) {
        return this.tr(string, new Object[]{object, object2});
    }

    public final String tr(String string, Object object, Object object2, Object object3) {
        return this.tr(string, new Object[]{object, object2, object3});
    }

    public final String tr(String string, Object object, Object object2, Object object3, Object object4) {
        return this.tr(string, new Object[]{object, object2, object3, object4});
    }

    public final String trn(String string, String string2, long l) {
        try {
            return I18n.trnInternal(this.bundle, string, string2, l);
        }
        catch (MissingResourceException missingResourceException) {
            return l == 1L ? string : string2;
        }
    }

    public final String trn(String string, String string2, long l, Object[] objectArray) {
        return MessageFormat.format(this.trn(string, string2, l), objectArray);
    }

    public final String trn(String string, String string2, long l, Object object) {
        return this.trn(string, string2, l, new Object[]{object});
    }

    public final String trn(String string, String string2, long l, Object object, Object object2) {
        return this.trn(string, string2, l, new Object[]{object, object2});
    }

    public final String trn(String string, String string2, long l, Object object, Object object2, Object object3) {
        return this.trn(string, string2, l, new Object[]{object, object2, object3});
    }

    public final String trn(String string, String string2, long l, Object object, Object object2, Object object3, Object object4) {
        return this.trn(string, string2, l, new Object[]{object, object2, object3, object4});
    }

    private static String trnInternal(ResourceBundle resourceBundle, String string, String string2, long l) {
        ResourceBundle resourceBundle2 = resourceBundle;
        do {
            boolean bl = false;
            boolean bl2 = false;
            Method method = null;
            Method method2 = null;
            Method method3 = null;
            Method method4 = null;
            try {
                method = resourceBundle2.getClass().getMethod("handleGetObject", String.class);
                method2 = resourceBundle2.getClass().getMethod("getParent", new Class[0]);
                bl = Modifier.isPublic(method.getModifiers());
                method3 = resourceBundle2.getClass().getMethod("lookup", String.class);
                method4 = resourceBundle2.getClass().getMethod("pluralEval", Long.TYPE);
                bl2 = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                Object object;
                if (bl2) {
                    try {
                        object = method3.invoke((Object)resourceBundle2, string);
                        if (object.getClass().isArray()) {
                            String[] stringArray = (String[])object;
                            long l2 = 0L;
                            try {
                                l2 = (Long)method4.invoke((Object)resourceBundle2, new Long(l));
                                if (l2 < 0L || l2 >= (long)stringArray.length) {
                                    l2 = 0L;
                                }
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                // empty catch block
                            }
                            return stringArray[(int)l2];
                        }
                        return (String)object;
                    }
                    catch (Exception exception) {}
                } else {
                    try {
                        object = method.invoke((Object)resourceBundle2, string);
                        if (object != null) {
                            return (String)object;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                resourceBundle2 = null;
                try {
                    resourceBundle2 = (ResourceBundle)method2.invoke((Object)resourceBundle2, new Object[0]);
                }
                catch (Exception exception) {}
                continue;
            }
            return resourceBundle2.getString(string);
        } while (resourceBundle2 != null);
        throw new MissingResourceException("Can not find resource for key " + string + " in bundle " + resourceBundle.getClass().getName(), resourceBundle.getClass().getName(), string);
    }

    public final String trc(String string, String string2) {
        if (this.sourceCodeLocale.equals(this.getResources().getLocale())) {
            return string2;
        }
        String string3 = string + CONTEXT_GLUE + string2;
        String string4 = this.tr(string3);
        return string4 == string3 ? string2 : string4;
    }

    public final String trnc(String string, String string2, String string3, long l) {
        try {
            return I18n.trnInternal(this.bundle, string + CONTEXT_GLUE + string2, string3, l);
        }
        catch (MissingResourceException missingResourceException) {
            return l == 1L ? string2 : string3;
        }
    }

    public final String trnc(String string, String string2, String string3, long l, Object[] objectArray) {
        return MessageFormat.format(this.trnc(string, string2, string3, l), objectArray);
    }

    public final String trnc(String string, String string2, String string3, long l, Object object) {
        return MessageFormat.format(this.trnc(string, string2, string3, l), object);
    }

    public final String trnc(String string, String string2, String string3, long l, Object object, Object object2) {
        return MessageFormat.format(this.trnc(string, string2, string3, l), object, object2);
    }

    public final String trnc(String string, String string2, String string3, long l, Object object, Object object2, Object object3) {
        return MessageFormat.format(this.trnc(string, string2, string3, l), object, object2, object3);
    }

    public final String trnc(String string, String string2, String string3, long l, Object object, Object object2, Object object3, Object object4) {
        return MessageFormat.format(this.trnc(string, string2, string3, l), object, object2, object3, object4);
    }
}

