/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.ant.gettext;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.tools.ant.Location;

public class GettextUtils {
    public static String getJavaLocale(String string) {
        String string2;
        int n;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> arrayList = new ArrayList<String>(3);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        if (arrayList.size() < 1 || arrayList.size() > 3) {
            throw new IllegalArgumentException("Invalid locale format: " + string);
        }
        if (arrayList.size() < 3 && (n = (string2 = (String)arrayList.get(arrayList.size() - 1)).indexOf("@")) != -1) {
            arrayList.remove(arrayList.size() - 1);
            arrayList.add(string2.substring(0, n));
            if (arrayList.size() == 1) {
                arrayList.add("");
            }
            arrayList.add(string2.substring(n + 1));
        }
        if ((string2 = (String)arrayList.get(0)).equalsIgnoreCase("he")) {
            arrayList.set(0, "iw");
        } else if (string2.equalsIgnoreCase("yi")) {
            arrayList.set(0, "ji");
        } else if (string2.equalsIgnoreCase("id")) {
            arrayList.set(0, "in");
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            stringBuffer.append(string3);
            if (!iterator.hasNext()) continue;
            stringBuffer.append("_");
        }
        return stringBuffer.toString();
    }

    public static String getRelativePath(File file, Location location) {
        String string = file.getAbsolutePath();
        File file2 = new File(location.getFileName()).getParentFile();
        if (file2 == null) {
            return string;
        }
        String string2 = file2.getAbsolutePath();
        if (string.startsWith(string2)) {
            if (string.length() == string2.length()) {
                return "";
            }
            return string.substring(GettextUtils.getPathWithSeparator(string2).length());
        }
        int n = GettextUtils.getCommonPathPrefix(string, string2).length();
        if (n > 0) {
            String string3 = string2.substring(n);
            int n2 = GettextUtils.countOccurrences(string3, File.separatorChar) + 1;
            String string4 = string.substring(n);
            if (string4.charAt(0) == File.separatorChar) {
                string4 = string4.substring(1);
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n2; ++i) {
                stringBuilder.append("..").append(File.separatorChar);
            }
            stringBuilder.append(string4);
            return stringBuilder.toString();
        }
        return string;
    }

    public static String createAbsolutePath(String string, String string2) {
        return string + File.separator + string2;
    }

    private static String getPathWithSeparator(String string) {
        return string.endsWith(File.separator) ? string : string + File.separator;
    }

    static String getCommonPathPrefix(String string, String string2) {
        int n = Math.min(string.length(), string2.length());
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == File.separatorChar) {
                n2 = i;
            }
            if (string.charAt(i) == string2.charAt(i)) continue;
            if (string.charAt(i) == File.separatorChar || string2.charAt(i) == File.separatorChar) {
                return string.substring(0, i);
            }
            return string.substring(0, n2 + 1);
        }
        if (string.length() == string2.length()) {
            return string;
        }
        return string.substring(0, n2 + 1);
    }

    static int countOccurrences(String string, char c) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }
}

