/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.util;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Path {
    static Pattern component = Pattern.compile("(....|\\.\\.)(\\[(.*)\\])?");

    private Path() {
    }

    public static String createPath(Box box) {
        return Path.createPath(box, "");
    }

    private static String createPath(Box box, String string) {
        if (box instanceof IsoFile) {
            return string;
        }
        List<?> list = box.getParent().getBoxes(box.getClass());
        int n = list.indexOf(box);
        string = String.format("/%s[%d]", box.getType(), n) + string;
        return Path.createPath(box.getParent(), string);
    }

    public static Box getPath(Box box, String string) {
        List<Box> list = Path.getPaths(box, string, true);
        return list.isEmpty() ? null : list.get(0);
    }

    public static List<Box> getPaths(Box box, String string) {
        return Path.getPaths(box, string, false);
    }

    public static List<Box> getPaths(Box box, String string, boolean bl) {
        String string2;
        String string3;
        if (string.startsWith("/")) {
            Box box2 = box;
            while (box2.getParent() != null) {
                box2 = box2.getParent();
            }
            assert (box2 instanceof IsoFile) : box2.getType() + " has no parent";
            return Path.getPaths(box2, string.substring(1), bl);
        }
        if (string.isEmpty()) {
            return Collections.singletonList(box);
        }
        if (string.contains("/")) {
            string3 = string.substring(string.indexOf(47) + 1);
            string2 = string.substring(0, string.indexOf(47));
        } else {
            string2 = string;
            string3 = "";
        }
        Matcher matcher = component.matcher(string2);
        if (matcher.matches()) {
            Object object;
            String string4 = matcher.group(1);
            if ("..".equals(string4)) {
                return Path.getPaths(box.getParent(), string3, bl);
            }
            int n = -1;
            if (matcher.group(2) != null) {
                object = matcher.group(3);
                n = Integer.parseInt((String)object);
            }
            object = new LinkedList();
            int n2 = 0;
            for (Box box3 : ((ContainerBox)box).getBoxes()) {
                if (box3.getType().matches(string4)) {
                    if (n == -1 || n == n2) {
                        object.addAll(Path.getPaths(box3, string3, bl));
                    }
                    ++n2;
                }
                if (!bl || object.isEmpty()) continue;
                return object;
            }
            return object;
        }
        throw new RuntimeException(string2 + " is invalid path.");
    }

    public static boolean isContained(Box box, String string) {
        assert (string.startsWith("/")) : "Absolute path required";
        return Path.getPaths(box, string).contains(box);
    }
}

