/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.util;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;

public class ByteBufferByteChannel
implements ByteChannel {
    ByteBuffer byteBuffer;

    public ByteBufferByteChannel(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.remaining();
        if (this.byteBuffer.remaining() >= n) {
            this.byteBuffer.get(byArray, byteBuffer.position(), n);
            return n;
        }
        throw new EOFException("Reading beyond end of stream");
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.remaining();
        this.byteBuffer.put(byteBuffer);
        return n;
    }
}

