/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.h264.write;

import com.googlecode.mp4parser.h264.Debug;
import com.googlecode.mp4parser.h264.write.BitstreamWriter;
import java.io.IOException;
import java.io.OutputStream;

public class CAVLCWriter
extends BitstreamWriter {
    public CAVLCWriter(OutputStream outputStream) {
        super(outputStream);
    }

    public void writeU(int n, int n2, String string) throws IOException {
        Debug.print(string + "\t");
        this.writeNBit(n, n2);
        Debug.println("\t" + n);
    }

    public void writeUE(int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < 15; ++i) {
            if (n < n3 + (1 << i)) {
                n2 = i;
                break;
            }
            n3 += 1 << i;
        }
        this.writeNBit(0L, n2);
        this.write1Bit(1);
        this.writeNBit(n - n3, n2);
    }

    public void writeUE(int n, String string) throws IOException {
        Debug.print(string + "\t");
        this.writeUE(n);
        Debug.println("\t" + n);
    }

    public void writeSE(int n, String string) throws IOException {
        Debug.print(string + "\t");
        this.writeUE((n << 1) * (n < 0 ? -1 : 1) + (n > 0 ? 1 : 0));
        Debug.println("\t" + n);
    }

    public void writeBool(boolean bl, String string) throws IOException {
        Debug.print(string + "\t");
        this.write1Bit(bl ? 1 : 0);
        Debug.println("\t" + bl);
    }

    public void writeU(int n, int n2) throws IOException {
        this.writeNBit(n, n2);
    }

    public void writeNBit(long l, int n, String string) throws IOException {
        Debug.print(string + "\t");
        for (int i = 0; i < n; ++i) {
            this.write1Bit((int)(l >> n - i - 1) & 1);
        }
        Debug.println("\t" + l);
    }

    public void writeTrailingBits() throws IOException {
        this.write1Bit(1);
        this.writeRemainingZero();
        this.flush();
    }

    public void writeSliceTrailingBits() {
        throw new IllegalStateException("todo");
    }
}

