/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.h264.model;

import com.googlecode.mp4parser.h264.model.BitstreamElement;
import com.googlecode.mp4parser.h264.model.ScalingList;
import com.googlecode.mp4parser.h264.model.ScalingMatrix;
import com.googlecode.mp4parser.h264.read.CAVLCReader;
import com.googlecode.mp4parser.h264.write.CAVLCWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class PictureParameterSet
extends BitstreamElement {
    public boolean entropy_coding_mode_flag;
    public int num_ref_idx_l0_active_minus1;
    public int num_ref_idx_l1_active_minus1;
    public int slice_group_change_rate_minus1;
    public int pic_parameter_set_id;
    public int seq_parameter_set_id;
    public boolean pic_order_present_flag;
    public int num_slice_groups_minus1;
    public int slice_group_map_type;
    public boolean weighted_pred_flag;
    public int weighted_bipred_idc;
    public int pic_init_qp_minus26;
    public int pic_init_qs_minus26;
    public int chroma_qp_index_offset;
    public boolean deblocking_filter_control_present_flag;
    public boolean constrained_intra_pred_flag;
    public boolean redundant_pic_cnt_present_flag;
    public int[] top_left;
    public int[] bottom_right;
    public int[] run_length_minus1;
    public boolean slice_group_change_direction_flag;
    public int[] slice_group_id;
    public PPSExt extended;

    public static PictureParameterSet read(byte[] byArray) throws IOException {
        return PictureParameterSet.read(new ByteArrayInputStream(byArray));
    }

    public static PictureParameterSet read(InputStream inputStream) throws IOException {
        int n;
        int n2;
        int n3;
        CAVLCReader cAVLCReader = new CAVLCReader(inputStream);
        PictureParameterSet pictureParameterSet = new PictureParameterSet();
        pictureParameterSet.pic_parameter_set_id = cAVLCReader.readUE("PPS: pic_parameter_set_id");
        pictureParameterSet.seq_parameter_set_id = cAVLCReader.readUE("PPS: seq_parameter_set_id");
        pictureParameterSet.entropy_coding_mode_flag = cAVLCReader.readBool("PPS: entropy_coding_mode_flag");
        pictureParameterSet.pic_order_present_flag = cAVLCReader.readBool("PPS: pic_order_present_flag");
        pictureParameterSet.num_slice_groups_minus1 = cAVLCReader.readUE("PPS: num_slice_groups_minus1");
        if (pictureParameterSet.num_slice_groups_minus1 > 0) {
            pictureParameterSet.slice_group_map_type = cAVLCReader.readUE("PPS: slice_group_map_type");
            pictureParameterSet.top_left = new int[pictureParameterSet.num_slice_groups_minus1 + 1];
            pictureParameterSet.bottom_right = new int[pictureParameterSet.num_slice_groups_minus1 + 1];
            pictureParameterSet.run_length_minus1 = new int[pictureParameterSet.num_slice_groups_minus1 + 1];
            if (pictureParameterSet.slice_group_map_type == 0) {
                for (n3 = 0; n3 <= pictureParameterSet.num_slice_groups_minus1; ++n3) {
                    pictureParameterSet.run_length_minus1[n3] = cAVLCReader.readUE("PPS: run_length_minus1");
                }
            } else if (pictureParameterSet.slice_group_map_type == 2) {
                for (n3 = 0; n3 < pictureParameterSet.num_slice_groups_minus1; ++n3) {
                    pictureParameterSet.top_left[n3] = cAVLCReader.readUE("PPS: top_left");
                    pictureParameterSet.bottom_right[n3] = cAVLCReader.readUE("PPS: bottom_right");
                }
            } else if (pictureParameterSet.slice_group_map_type == 3 || pictureParameterSet.slice_group_map_type == 4 || pictureParameterSet.slice_group_map_type == 5) {
                pictureParameterSet.slice_group_change_direction_flag = cAVLCReader.readBool("PPS: slice_group_change_direction_flag");
                pictureParameterSet.slice_group_change_rate_minus1 = cAVLCReader.readUE("PPS: slice_group_change_rate_minus1");
            } else if (pictureParameterSet.slice_group_map_type == 6) {
                n3 = pictureParameterSet.num_slice_groups_minus1 + 1 > 4 ? 3 : (pictureParameterSet.num_slice_groups_minus1 + 1 > 2 ? 2 : 1);
                n2 = cAVLCReader.readUE("PPS: pic_size_in_map_units_minus1");
                pictureParameterSet.slice_group_id = new int[n2 + 1];
                for (n = 0; n <= n2; ++n) {
                    pictureParameterSet.slice_group_id[n] = cAVLCReader.readU(n3, "PPS: slice_group_id [" + n + "]f");
                }
            }
        }
        pictureParameterSet.num_ref_idx_l0_active_minus1 = cAVLCReader.readUE("PPS: num_ref_idx_l0_active_minus1");
        pictureParameterSet.num_ref_idx_l1_active_minus1 = cAVLCReader.readUE("PPS: num_ref_idx_l1_active_minus1");
        pictureParameterSet.weighted_pred_flag = cAVLCReader.readBool("PPS: weighted_pred_flag");
        pictureParameterSet.weighted_bipred_idc = (int)cAVLCReader.readNBit(2, "PPS: weighted_bipred_idc");
        pictureParameterSet.pic_init_qp_minus26 = cAVLCReader.readSE("PPS: pic_init_qp_minus26");
        pictureParameterSet.pic_init_qs_minus26 = cAVLCReader.readSE("PPS: pic_init_qs_minus26");
        pictureParameterSet.chroma_qp_index_offset = cAVLCReader.readSE("PPS: chroma_qp_index_offset");
        pictureParameterSet.deblocking_filter_control_present_flag = cAVLCReader.readBool("PPS: deblocking_filter_control_present_flag");
        pictureParameterSet.constrained_intra_pred_flag = cAVLCReader.readBool("PPS: constrained_intra_pred_flag");
        pictureParameterSet.redundant_pic_cnt_present_flag = cAVLCReader.readBool("PPS: redundant_pic_cnt_present_flag");
        if (cAVLCReader.moreRBSPData()) {
            pictureParameterSet.extended = new PPSExt();
            pictureParameterSet.extended.transform_8x8_mode_flag = cAVLCReader.readBool("PPS: transform_8x8_mode_flag");
            n3 = cAVLCReader.readBool("PPS: pic_scaling_matrix_present_flag") ? 1 : 0;
            if (n3 != 0) {
                for (n2 = 0; n2 < 6 + 2 * (pictureParameterSet.extended.transform_8x8_mode_flag ? 1 : 0); ++n2) {
                    n = cAVLCReader.readBool("PPS: pic_scaling_list_present_flag") ? 1 : 0;
                    if (n == 0) continue;
                    pictureParameterSet.extended.scalindMatrix.ScalingList4x4 = new ScalingList[8];
                    pictureParameterSet.extended.scalindMatrix.ScalingList8x8 = new ScalingList[8];
                    if (n2 < 6) {
                        pictureParameterSet.extended.scalindMatrix.ScalingList4x4[n2] = ScalingList.read(cAVLCReader, 16);
                        continue;
                    }
                    pictureParameterSet.extended.scalindMatrix.ScalingList8x8[n2 - 6] = ScalingList.read(cAVLCReader, 64);
                }
            }
            pictureParameterSet.extended.second_chroma_qp_index_offset = cAVLCReader.readSE("PPS: second_chroma_qp_index_offset");
        }
        cAVLCReader.readTrailingBits();
        return pictureParameterSet;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        CAVLCWriter cAVLCWriter = new CAVLCWriter(outputStream);
        cAVLCWriter.writeUE(this.pic_parameter_set_id, "PPS: pic_parameter_set_id");
        cAVLCWriter.writeUE(this.seq_parameter_set_id, "PPS: seq_parameter_set_id");
        cAVLCWriter.writeBool(this.entropy_coding_mode_flag, "PPS: entropy_coding_mode_flag");
        cAVLCWriter.writeBool(this.pic_order_present_flag, "PPS: pic_order_present_flag");
        cAVLCWriter.writeUE(this.num_slice_groups_minus1, "PPS: num_slice_groups_minus1");
        if (this.num_slice_groups_minus1 > 0) {
            int n;
            cAVLCWriter.writeUE(this.slice_group_map_type, "PPS: slice_group_map_type");
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            if (this.slice_group_map_type == 0) {
                for (n = 0; n <= this.num_slice_groups_minus1; ++n) {
                    cAVLCWriter.writeUE(nArray3[n], "PPS: ");
                }
            } else if (this.slice_group_map_type == 2) {
                for (n = 0; n < this.num_slice_groups_minus1; ++n) {
                    cAVLCWriter.writeUE(nArray[n], "PPS: ");
                    cAVLCWriter.writeUE(nArray2[n], "PPS: ");
                }
            } else if (this.slice_group_map_type == 3 || this.slice_group_map_type == 4 || this.slice_group_map_type == 5) {
                cAVLCWriter.writeBool(this.slice_group_change_direction_flag, "PPS: slice_group_change_direction_flag");
                cAVLCWriter.writeUE(this.slice_group_change_rate_minus1, "PPS: slice_group_change_rate_minus1");
            } else if (this.slice_group_map_type == 6) {
                n = this.num_slice_groups_minus1 + 1 > 4 ? 3 : (this.num_slice_groups_minus1 + 1 > 2 ? 2 : 1);
                cAVLCWriter.writeUE(this.slice_group_id.length, "PPS: ");
                for (int i = 0; i <= this.slice_group_id.length; ++i) {
                    cAVLCWriter.writeU(this.slice_group_id[i], n);
                }
            }
        }
        cAVLCWriter.writeUE(this.num_ref_idx_l0_active_minus1, "PPS: num_ref_idx_l0_active_minus1");
        cAVLCWriter.writeUE(this.num_ref_idx_l1_active_minus1, "PPS: num_ref_idx_l1_active_minus1");
        cAVLCWriter.writeBool(this.weighted_pred_flag, "PPS: weighted_pred_flag");
        cAVLCWriter.writeNBit(this.weighted_bipred_idc, 2, "PPS: weighted_bipred_idc");
        cAVLCWriter.writeSE(this.pic_init_qp_minus26, "PPS: pic_init_qp_minus26");
        cAVLCWriter.writeSE(this.pic_init_qs_minus26, "PPS: pic_init_qs_minus26");
        cAVLCWriter.writeSE(this.chroma_qp_index_offset, "PPS: chroma_qp_index_offset");
        cAVLCWriter.writeBool(this.deblocking_filter_control_present_flag, "PPS: deblocking_filter_control_present_flag");
        cAVLCWriter.writeBool(this.constrained_intra_pred_flag, "PPS: constrained_intra_pred_flag");
        cAVLCWriter.writeBool(this.redundant_pic_cnt_present_flag, "PPS: redundant_pic_cnt_present_flag");
        if (this.extended != null) {
            cAVLCWriter.writeBool(this.extended.transform_8x8_mode_flag, "PPS: transform_8x8_mode_flag");
            cAVLCWriter.writeBool(this.extended.scalindMatrix != null, "PPS: scalindMatrix");
            if (this.extended.scalindMatrix != null) {
                for (int i = 0; i < 6 + 2 * (this.extended.transform_8x8_mode_flag ? 1 : 0); ++i) {
                    if (i < 6) {
                        cAVLCWriter.writeBool(this.extended.scalindMatrix.ScalingList4x4[i] != null, "PPS: ");
                        if (this.extended.scalindMatrix.ScalingList4x4[i] == null) continue;
                        this.extended.scalindMatrix.ScalingList4x4[i].write(cAVLCWriter);
                        continue;
                    }
                    cAVLCWriter.writeBool(this.extended.scalindMatrix.ScalingList8x8[i - 6] != null, "PPS: ");
                    if (this.extended.scalindMatrix.ScalingList8x8[i - 6] == null) continue;
                    this.extended.scalindMatrix.ScalingList8x8[i - 6].write(cAVLCWriter);
                }
            }
            cAVLCWriter.writeSE(this.extended.second_chroma_qp_index_offset, "PPS: ");
        }
        cAVLCWriter.writeTrailingBits();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode(this.bottom_right);
        n = 31 * n + this.chroma_qp_index_offset;
        n = 31 * n + (this.constrained_intra_pred_flag ? 1231 : 1237);
        n = 31 * n + (this.deblocking_filter_control_present_flag ? 1231 : 1237);
        n = 31 * n + (this.entropy_coding_mode_flag ? 1231 : 1237);
        n = 31 * n + (this.extended == null ? 0 : this.extended.hashCode());
        n = 31 * n + this.num_ref_idx_l0_active_minus1;
        n = 31 * n + this.num_ref_idx_l1_active_minus1;
        n = 31 * n + this.num_slice_groups_minus1;
        n = 31 * n + this.pic_init_qp_minus26;
        n = 31 * n + this.pic_init_qs_minus26;
        n = 31 * n + (this.pic_order_present_flag ? 1231 : 1237);
        n = 31 * n + this.pic_parameter_set_id;
        n = 31 * n + (this.redundant_pic_cnt_present_flag ? 1231 : 1237);
        n = 31 * n + Arrays.hashCode(this.run_length_minus1);
        n = 31 * n + this.seq_parameter_set_id;
        n = 31 * n + (this.slice_group_change_direction_flag ? 1231 : 1237);
        n = 31 * n + this.slice_group_change_rate_minus1;
        n = 31 * n + Arrays.hashCode(this.slice_group_id);
        n = 31 * n + this.slice_group_map_type;
        n = 31 * n + Arrays.hashCode(this.top_left);
        n = 31 * n + this.weighted_bipred_idc;
        n = 31 * n + (this.weighted_pred_flag ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PictureParameterSet pictureParameterSet = (PictureParameterSet)object;
        if (!Arrays.equals(this.bottom_right, pictureParameterSet.bottom_right)) {
            return false;
        }
        if (this.chroma_qp_index_offset != pictureParameterSet.chroma_qp_index_offset) {
            return false;
        }
        if (this.constrained_intra_pred_flag != pictureParameterSet.constrained_intra_pred_flag) {
            return false;
        }
        if (this.deblocking_filter_control_present_flag != pictureParameterSet.deblocking_filter_control_present_flag) {
            return false;
        }
        if (this.entropy_coding_mode_flag != pictureParameterSet.entropy_coding_mode_flag) {
            return false;
        }
        if (this.extended == null ? pictureParameterSet.extended != null : !this.extended.equals(pictureParameterSet.extended)) {
            return false;
        }
        if (this.num_ref_idx_l0_active_minus1 != pictureParameterSet.num_ref_idx_l0_active_minus1) {
            return false;
        }
        if (this.num_ref_idx_l1_active_minus1 != pictureParameterSet.num_ref_idx_l1_active_minus1) {
            return false;
        }
        if (this.num_slice_groups_minus1 != pictureParameterSet.num_slice_groups_minus1) {
            return false;
        }
        if (this.pic_init_qp_minus26 != pictureParameterSet.pic_init_qp_minus26) {
            return false;
        }
        if (this.pic_init_qs_minus26 != pictureParameterSet.pic_init_qs_minus26) {
            return false;
        }
        if (this.pic_order_present_flag != pictureParameterSet.pic_order_present_flag) {
            return false;
        }
        if (this.pic_parameter_set_id != pictureParameterSet.pic_parameter_set_id) {
            return false;
        }
        if (this.redundant_pic_cnt_present_flag != pictureParameterSet.redundant_pic_cnt_present_flag) {
            return false;
        }
        if (!Arrays.equals(this.run_length_minus1, pictureParameterSet.run_length_minus1)) {
            return false;
        }
        if (this.seq_parameter_set_id != pictureParameterSet.seq_parameter_set_id) {
            return false;
        }
        if (this.slice_group_change_direction_flag != pictureParameterSet.slice_group_change_direction_flag) {
            return false;
        }
        if (this.slice_group_change_rate_minus1 != pictureParameterSet.slice_group_change_rate_minus1) {
            return false;
        }
        if (!Arrays.equals(this.slice_group_id, pictureParameterSet.slice_group_id)) {
            return false;
        }
        if (this.slice_group_map_type != pictureParameterSet.slice_group_map_type) {
            return false;
        }
        if (!Arrays.equals(this.top_left, pictureParameterSet.top_left)) {
            return false;
        }
        if (this.weighted_bipred_idc != pictureParameterSet.weighted_bipred_idc) {
            return false;
        }
        return this.weighted_pred_flag == pictureParameterSet.weighted_pred_flag;
    }

    public String toString() {
        return "PictureParameterSet{\n       entropy_coding_mode_flag=" + this.entropy_coding_mode_flag + ",\n       num_ref_idx_l0_active_minus1=" + this.num_ref_idx_l0_active_minus1 + ",\n       num_ref_idx_l1_active_minus1=" + this.num_ref_idx_l1_active_minus1 + ",\n       slice_group_change_rate_minus1=" + this.slice_group_change_rate_minus1 + ",\n       pic_parameter_set_id=" + this.pic_parameter_set_id + ",\n       seq_parameter_set_id=" + this.seq_parameter_set_id + ",\n       pic_order_present_flag=" + this.pic_order_present_flag + ",\n       num_slice_groups_minus1=" + this.num_slice_groups_minus1 + ",\n       slice_group_map_type=" + this.slice_group_map_type + ",\n       weighted_pred_flag=" + this.weighted_pred_flag + ",\n       weighted_bipred_idc=" + this.weighted_bipred_idc + ",\n       pic_init_qp_minus26=" + this.pic_init_qp_minus26 + ",\n       pic_init_qs_minus26=" + this.pic_init_qs_minus26 + ",\n       chroma_qp_index_offset=" + this.chroma_qp_index_offset + ",\n       deblocking_filter_control_present_flag=" + this.deblocking_filter_control_present_flag + ",\n       constrained_intra_pred_flag=" + this.constrained_intra_pred_flag + ",\n       redundant_pic_cnt_present_flag=" + this.redundant_pic_cnt_present_flag + ",\n       top_left=" + this.top_left + ",\n       bottom_right=" + this.bottom_right + ",\n       run_length_minus1=" + this.run_length_minus1 + ",\n       slice_group_change_direction_flag=" + this.slice_group_change_direction_flag + ",\n       slice_group_id=" + this.slice_group_id + ",\n       extended=" + this.extended + '}';
    }

    public static class PPSExt {
        public boolean transform_8x8_mode_flag;
        public ScalingMatrix scalindMatrix = new ScalingMatrix();
        public int second_chroma_qp_index_offset;
        public boolean[] pic_scaling_list_present_flag;

        public String toString() {
            return "PPSExt{transform_8x8_mode_flag=" + this.transform_8x8_mode_flag + ", scalindMatrix=" + this.scalindMatrix + ", second_chroma_qp_index_offset=" + this.second_chroma_qp_index_offset + ", pic_scaling_list_present_flag=" + this.pic_scaling_list_present_flag + '}';
        }
    }
}

