/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.threegpp26244;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractFullBox;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitReaderBuffer;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitWriterBuffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class SegmentIndexBox
extends AbstractFullBox {
    public static final String TYPE = "sidx";
    List<Entry> entries = new ArrayList<Entry>();
    long referenceId;
    long timeScale;
    long earliestPresentationTime;
    long firstOffset;
    int reserved;

    public SegmentIndexBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        long l = 4L;
        l += 4L;
        l += 4L;
        l += this.getVersion() == 0 ? 8L : 16L;
        l += 2L;
        l += 2L;
        return l += (long)(this.entries.size() * 12);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt32(byteBuffer, this.referenceId);
        IsoTypeWriter.writeUInt32(byteBuffer, this.timeScale);
        if (this.getVersion() == 0) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.earliestPresentationTime);
            IsoTypeWriter.writeUInt32(byteBuffer, this.firstOffset);
        } else {
            IsoTypeWriter.writeUInt64(byteBuffer, this.earliestPresentationTime);
            IsoTypeWriter.writeUInt64(byteBuffer, this.firstOffset);
        }
        IsoTypeWriter.writeUInt16(byteBuffer, this.reserved);
        IsoTypeWriter.writeUInt16(byteBuffer, this.entries.size());
        for (Entry entry : this.entries) {
            BitWriterBuffer bitWriterBuffer = new BitWriterBuffer(byteBuffer);
            bitWriterBuffer.writeBits(entry.getReferenceType(), 1);
            bitWriterBuffer.writeBits(entry.getReferencedSize(), 31);
            IsoTypeWriter.writeUInt32(byteBuffer, entry.getSubsegmentDuration());
            bitWriterBuffer = new BitWriterBuffer(byteBuffer);
            bitWriterBuffer.writeBits(entry.getStartsWithSap(), 1);
            bitWriterBuffer.writeBits(entry.getSapType(), 3);
            bitWriterBuffer.writeBits(entry.getSapDeltaTime(), 28);
        }
    }

    @Override
    protected void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        this.referenceId = IsoTypeReader.readUInt32(byteBuffer);
        this.timeScale = IsoTypeReader.readUInt32(byteBuffer);
        if (this.getVersion() == 0) {
            this.earliestPresentationTime = IsoTypeReader.readUInt32(byteBuffer);
            this.firstOffset = IsoTypeReader.readUInt32(byteBuffer);
        } else {
            this.earliestPresentationTime = IsoTypeReader.readUInt64(byteBuffer);
            this.firstOffset = IsoTypeReader.readUInt64(byteBuffer);
        }
        this.reserved = IsoTypeReader.readUInt16(byteBuffer);
        int n = IsoTypeReader.readUInt16(byteBuffer);
        for (int i = 0; i < n; ++i) {
            BitReaderBuffer bitReaderBuffer = new BitReaderBuffer(byteBuffer);
            Entry entry = new Entry();
            entry.setReferenceType((byte)bitReaderBuffer.readBits(1));
            entry.setReferencedSize(bitReaderBuffer.readBits(31));
            entry.setSubsegmentDuration(IsoTypeReader.readUInt32(byteBuffer));
            bitReaderBuffer = new BitReaderBuffer(byteBuffer);
            entry.setStartsWithSap((byte)bitReaderBuffer.readBits(1));
            entry.setSapType((byte)bitReaderBuffer.readBits(3));
            entry.setSapDeltaTime(bitReaderBuffer.readBits(28));
            this.entries.add(entry);
        }
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry> list) {
        this.entries = list;
    }

    public long getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(long l) {
        this.referenceId = l;
    }

    public long getTimeScale() {
        return this.timeScale;
    }

    public void setTimeScale(long l) {
        this.timeScale = l;
    }

    public long getEarliestPresentationTime() {
        return this.earliestPresentationTime;
    }

    public void setEarliestPresentationTime(long l) {
        this.earliestPresentationTime = l;
    }

    public long getFirstOffset() {
        return this.firstOffset;
    }

    public void setFirstOffset(long l) {
        this.firstOffset = l;
    }

    public int getReserved() {
        return this.reserved;
    }

    public void setReserved(int n) {
        this.reserved = n;
    }

    public static class Entry {
        byte referenceType;
        int referencedSize;
        long subsegmentDuration;
        byte startsWithSap;
        byte sapType;
        int sapDeltaTime;

        public Entry() {
        }

        public Entry(byte by, int n, long l, byte by2, byte by3, int n2) {
            this.referenceType = by;
            this.referencedSize = n;
            this.subsegmentDuration = l;
            this.startsWithSap = by2;
            this.sapType = by3;
            this.sapDeltaTime = n2;
        }

        public byte getReferenceType() {
            return this.referenceType;
        }

        public void setReferenceType(byte by) {
            this.referenceType = by;
        }

        public int getReferencedSize() {
            return this.referencedSize;
        }

        public void setReferencedSize(int n) {
            this.referencedSize = n;
        }

        public long getSubsegmentDuration() {
            return this.subsegmentDuration;
        }

        public void setSubsegmentDuration(long l) {
            this.subsegmentDuration = l;
        }

        public byte getStartsWithSap() {
            return this.startsWithSap;
        }

        public void setStartsWithSap(byte by) {
            this.startsWithSap = by;
        }

        public byte getSapType() {
            return this.sapType;
        }

        public void setSapType(byte by) {
            this.sapType = by;
        }

        public int getSapDeltaTime() {
            return this.sapDeltaTime;
        }

        public void setSapDeltaTime(int n) {
            this.sapDeltaTime = n;
        }

        public String toString() {
            return "Entry{referenceType=" + this.referenceType + ", referencedSize=" + this.referencedSize + ", subsegmentDuration=" + this.subsegmentDuration + ", startsWithSap=" + this.startsWithSap + ", sapType=" + this.sapType + ", sapDeltaTime=" + this.sapDeltaTime + '}';
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Entry entry = (Entry)object;
            if (this.referenceType != entry.referenceType) {
                return false;
            }
            if (this.referencedSize != entry.referencedSize) {
                return false;
            }
            if (this.sapDeltaTime != entry.sapDeltaTime) {
                return false;
            }
            if (this.sapType != entry.sapType) {
                return false;
            }
            if (this.startsWithSap != entry.startsWithSap) {
                return false;
            }
            return this.subsegmentDuration == entry.subsegmentDuration;
        }

        public int hashCode() {
            int n = this.referenceType;
            n = 31 * n + this.referencedSize;
            n = 31 * n + (int)(this.subsegmentDuration ^ this.subsegmentDuration >>> 32);
            n = 31 * n + this.startsWithSap;
            n = 31 * n + this.sapType;
            n = 31 * n + this.sapDeltaTime;
            return n;
        }
    }
}

