/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.piff;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.boxes.piff.ProtectionSpecificHeader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PlayReadyHeader
extends ProtectionSpecificHeader {
    private long length;
    private List<PlayReadyRecord> records;

    @Override
    public void parse(ByteBuffer byteBuffer) {
        this.length = IsoTypeReader.readUInt32BE(byteBuffer);
        int n = IsoTypeReader.readUInt16BE(byteBuffer);
        this.records = PlayReadyRecord.createFor(byteBuffer, n);
    }

    @Override
    public ByteBuffer getData() {
        int n = 6;
        for (PlayReadyRecord object : this.records) {
            n += 4;
            n += object.getValue().rewind().limit();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        IsoTypeWriter.writeUInt32BE(byteBuffer, n);
        IsoTypeWriter.writeUInt16BE(byteBuffer, this.records.size());
        for (PlayReadyRecord playReadyRecord : this.records) {
            IsoTypeWriter.writeUInt16BE(byteBuffer, playReadyRecord.type);
            IsoTypeWriter.writeUInt16BE(byteBuffer, playReadyRecord.getValue().limit());
            ByteBuffer byteBuffer2 = playReadyRecord.getValue();
            byteBuffer.put(byteBuffer2);
        }
        return byteBuffer;
    }

    public void setRecords(List<PlayReadyRecord> list) {
        this.records = list;
    }

    public List<PlayReadyRecord> getRecords() {
        return Collections.unmodifiableList(this.records);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PlayReadyHeader");
        stringBuilder.append("{length=").append(this.length);
        stringBuilder.append(", recordCount=").append(this.records.size());
        stringBuilder.append(", records=").append(this.records);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static abstract class PlayReadyRecord {
        int type;

        public PlayReadyRecord(int n) {
            this.type = n;
        }

        public static List<PlayReadyRecord> createFor(ByteBuffer byteBuffer, int n) {
            ArrayList<PlayReadyRecord> arrayList = new ArrayList<PlayReadyRecord>(n);
            for (int i = 0; i < n; ++i) {
                PlayReadyRecord playReadyRecord;
                int n2 = IsoTypeReader.readUInt16BE(byteBuffer);
                int n3 = IsoTypeReader.readUInt16BE(byteBuffer);
                switch (n2) {
                    case 1: {
                        playReadyRecord = new RMHeader();
                        break;
                    }
                    case 2: {
                        playReadyRecord = new DefaulPlayReadyRecord(2);
                        break;
                    }
                    case 3: {
                        playReadyRecord = new EmeddedLicenseStore();
                        break;
                    }
                    default: {
                        playReadyRecord = new DefaulPlayReadyRecord(n2);
                    }
                }
                playReadyRecord.parse((ByteBuffer)byteBuffer.slice().limit(n3));
                byteBuffer.position(byteBuffer.position() + n3);
                arrayList.add(playReadyRecord);
            }
            return arrayList;
        }

        public abstract void parse(ByteBuffer var1);

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("PlayReadyRecord");
            stringBuilder.append("{type=").append(this.type);
            stringBuilder.append(", length=").append(this.getValue().limit());
            stringBuilder.append('}');
            return stringBuilder.toString();
        }

        public abstract ByteBuffer getValue();

        public static class DefaulPlayReadyRecord
        extends PlayReadyRecord {
            ByteBuffer value;

            public DefaulPlayReadyRecord(int n) {
                super(n);
            }

            @Override
            public void parse(ByteBuffer byteBuffer) {
                this.value = byteBuffer.duplicate();
            }

            @Override
            public ByteBuffer getValue() {
                return this.value;
            }
        }

        public static class EmeddedLicenseStore
        extends PlayReadyRecord {
            ByteBuffer value;

            public EmeddedLicenseStore() {
                super(3);
            }

            @Override
            public void parse(ByteBuffer byteBuffer) {
                this.value = byteBuffer.duplicate();
            }

            @Override
            public ByteBuffer getValue() {
                return this.value;
            }

            @Override
            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("EmeddedLicenseStore");
                stringBuilder.append("{length=").append(this.getValue().limit());
                stringBuilder.append('}');
                return stringBuilder.toString();
            }
        }

        public static class RMHeader
        extends PlayReadyRecord {
            String header;

            public RMHeader() {
                super(1);
            }

            @Override
            public void parse(ByteBuffer byteBuffer) {
                try {
                    byte[] byArray = new byte[byteBuffer.slice().limit()];
                    byteBuffer.get(byArray);
                    this.header = new String(byArray, "UTF-16LE");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException(unsupportedEncodingException);
                }
            }

            @Override
            public ByteBuffer getValue() {
                byte[] byArray;
                try {
                    byArray = this.header.getBytes("UTF-16LE");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException(unsupportedEncodingException);
                }
                return ByteBuffer.wrap(byArray);
            }

            public void setHeader(String string) {
                this.header = string;
            }

            public String getHeader() {
                return this.header;
            }

            @Override
            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("RMHeader");
                stringBuilder.append("{length=").append(this.getValue().limit());
                stringBuilder.append(", header='").append(this.header).append('\'');
                stringBuilder.append('}');
                return stringBuilder.toString();
            }
        }
    }
}

