/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4.samplegrouping;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.boxes.mp4.samplegrouping.GroupEntry;
import com.googlecode.mp4parser.util.CastUtils;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class RateShareEntry
extends GroupEntry {
    public static final String TYPE = "rash";
    private short operationPointCut;
    private short targetRateShare;
    private List<Entry> entries = new LinkedList<Entry>();
    private int maximumBitrate;
    private int minimumBitrate;
    private short discardPriority;

    @Override
    public void parse(ByteBuffer byteBuffer) {
        this.operationPointCut = byteBuffer.getShort();
        if (this.operationPointCut == 1) {
            this.targetRateShare = byteBuffer.getShort();
        } else {
            int n = this.operationPointCut;
            while (n-- > 0) {
                this.entries.add(new Entry(CastUtils.l2i(IsoTypeReader.readUInt32(byteBuffer)), byteBuffer.getShort()));
            }
        }
        this.maximumBitrate = CastUtils.l2i(IsoTypeReader.readUInt32(byteBuffer));
        this.minimumBitrate = CastUtils.l2i(IsoTypeReader.readUInt32(byteBuffer));
        this.discardPriority = (short)IsoTypeReader.readUInt8(byteBuffer);
    }

    @Override
    public ByteBuffer get() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.operationPointCut == 1 ? 13 : this.operationPointCut * 6 + 11);
        byteBuffer.putShort(this.operationPointCut);
        if (this.operationPointCut == 1) {
            byteBuffer.putShort(this.targetRateShare);
        } else {
            for (Entry entry : this.entries) {
                byteBuffer.putInt(entry.getAvailableBitrate());
                byteBuffer.putShort(entry.getTargetRateShare());
            }
        }
        byteBuffer.putInt(this.maximumBitrate);
        byteBuffer.putInt(this.minimumBitrate);
        IsoTypeWriter.writeUInt8(byteBuffer, this.discardPriority);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RateShareEntry rateShareEntry = (RateShareEntry)object;
        if (this.discardPriority != rateShareEntry.discardPriority) {
            return false;
        }
        if (this.maximumBitrate != rateShareEntry.maximumBitrate) {
            return false;
        }
        if (this.minimumBitrate != rateShareEntry.minimumBitrate) {
            return false;
        }
        if (this.operationPointCut != rateShareEntry.operationPointCut) {
            return false;
        }
        if (this.targetRateShare != rateShareEntry.targetRateShare) {
            return false;
        }
        return !(this.entries != null ? !this.entries.equals(rateShareEntry.entries) : rateShareEntry.entries != null);
    }

    public int hashCode() {
        int n = this.operationPointCut;
        n = 31 * n + this.targetRateShare;
        n = 31 * n + (this.entries != null ? this.entries.hashCode() : 0);
        n = 31 * n + this.maximumBitrate;
        n = 31 * n + this.minimumBitrate;
        n = 31 * n + this.discardPriority;
        return n;
    }

    public short getOperationPointCut() {
        return this.operationPointCut;
    }

    public void setOperationPointCut(short s) {
        this.operationPointCut = s;
    }

    public short getTargetRateShare() {
        return this.targetRateShare;
    }

    public void setTargetRateShare(short s) {
        this.targetRateShare = s;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry> list) {
        this.entries = list;
    }

    public int getMaximumBitrate() {
        return this.maximumBitrate;
    }

    public void setMaximumBitrate(int n) {
        this.maximumBitrate = n;
    }

    public int getMinimumBitrate() {
        return this.minimumBitrate;
    }

    public void setMinimumBitrate(int n) {
        this.minimumBitrate = n;
    }

    public short getDiscardPriority() {
        return this.discardPriority;
    }

    public void setDiscardPriority(short s) {
        this.discardPriority = s;
    }

    public static class Entry {
        int availableBitrate;
        short targetRateShare;

        public Entry(int n, short s) {
            this.availableBitrate = n;
            this.targetRateShare = s;
        }

        public String toString() {
            return "{availableBitrate=" + this.availableBitrate + ", targetRateShare=" + this.targetRateShare + '}';
        }

        public int getAvailableBitrate() {
            return this.availableBitrate;
        }

        public void setAvailableBitrate(int n) {
            this.availableBitrate = n;
        }

        public short getTargetRateShare() {
            return this.targetRateShare;
        }

        public void setTargetRateShare(short s) {
            this.targetRateShare = s;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Entry entry = (Entry)object;
            if (this.availableBitrate != entry.availableBitrate) {
                return false;
            }
            return this.targetRateShare == entry.targetRateShare;
        }

        public int hashCode() {
            int n = this.availableBitrate;
            n = 31 * n + this.targetRateShare;
            return n;
        }
    }
}

