/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4.samplegrouping;

import com.coremedia.iso.Hex;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.boxes.mp4.samplegrouping.GroupEntry;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class CencSampleEncryptionInformationGroupEntry
extends GroupEntry {
    public static final String TYPE = "seig";
    private int isEncrypted;
    private byte ivSize;
    private byte[] kid = new byte[16];

    @Override
    public void parse(ByteBuffer byteBuffer) {
        this.isEncrypted = IsoTypeReader.readUInt24(byteBuffer);
        this.ivSize = (byte)IsoTypeReader.readUInt8(byteBuffer);
        this.kid = new byte[16];
        byteBuffer.get(this.kid);
    }

    @Override
    public ByteBuffer get() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(20);
        IsoTypeWriter.writeUInt24(byteBuffer, this.isEncrypted);
        IsoTypeWriter.writeUInt8(byteBuffer, this.ivSize);
        byteBuffer.put(this.kid);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public int getEncrypted() {
        return this.isEncrypted;
    }

    public void setEncrypted(int n) {
        this.isEncrypted = n;
    }

    public byte getIvSize() {
        return this.ivSize;
    }

    public void setIvSize(byte by) {
        this.ivSize = by;
    }

    public byte[] getKid() {
        return this.kid;
    }

    public void setKid(byte[] byArray) {
        assert (byArray.length == 16);
        this.kid = byArray;
    }

    public String toString() {
        return "CencSampleEncryptionInformationGroupEntry{isEncrypted=" + this.isEncrypted + ", ivSize=" + this.ivSize + ", kid=" + Hex.encodeHex(this.kid) + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CencSampleEncryptionInformationGroupEntry cencSampleEncryptionInformationGroupEntry = (CencSampleEncryptionInformationGroupEntry)object;
        if (this.isEncrypted != cencSampleEncryptionInformationGroupEntry.isEncrypted) {
            return false;
        }
        if (this.ivSize != cencSampleEncryptionInformationGroupEntry.ivSize) {
            return false;
        }
        return Arrays.equals(this.kid, cencSampleEncryptionInformationGroupEntry.kid);
    }

    public int hashCode() {
        int n = this.isEncrypted;
        n = 31 * n + this.ivSize;
        n = 31 * n + (this.kid != null ? Arrays.hashCode(this.kid) : 0);
        return n;
    }
}

