/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4.objectdescriptors;

import com.coremedia.iso.IsoTypeReader;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.AudioSpecificConfig;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BaseDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.DecoderConfigDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.DecoderSpecificInfo;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.Descriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ESDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ExtensionDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ExtensionProfileLevelDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ObjectDescriptorBase;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ProfileLevelIndicationDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.SLConfigDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.UnknownDescriptor;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ObjectDescriptorFactory {
    protected static Logger log = Logger.getLogger(ObjectDescriptorFactory.class.getName());
    protected static Map<Integer, Map<Integer, Class<? extends BaseDescriptor>>> descriptorRegistry = new HashMap<Integer, Map<Integer, Class<? extends BaseDescriptor>>>();

    public static BaseDescriptor createFrom(int n, ByteBuffer byteBuffer) throws IOException {
        BaseDescriptor baseDescriptor;
        Class<? extends BaseDescriptor> clazz;
        int n2 = IsoTypeReader.readUInt8(byteBuffer);
        Map<Integer, Class<? extends BaseDescriptor>> map = descriptorRegistry.get(n);
        if (map == null) {
            map = descriptorRegistry.get(-1);
        }
        if ((clazz = map.get(n2)) == null || clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            log.warning("No ObjectDescriptor found for objectTypeIndication " + Integer.toHexString(n) + " and tag " + Integer.toHexString(n2) + " found: " + clazz);
            baseDescriptor = new UnknownDescriptor();
        } else {
            try {
                baseDescriptor = clazz.newInstance();
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "Couldn't instantiate BaseDescriptor class " + clazz + " for objectTypeIndication " + n + " and tag " + n2, exception);
                throw new RuntimeException(exception);
            }
        }
        baseDescriptor.parse(n2, byteBuffer);
        return baseDescriptor;
    }

    static {
        HashSet<Class> hashSet = new HashSet<Class>();
        hashSet.add(DecoderSpecificInfo.class);
        hashSet.add(SLConfigDescriptor.class);
        hashSet.add(BaseDescriptor.class);
        hashSet.add(ExtensionDescriptor.class);
        hashSet.add(ObjectDescriptorBase.class);
        hashSet.add(ProfileLevelIndicationDescriptor.class);
        hashSet.add(AudioSpecificConfig.class);
        hashSet.add(ExtensionProfileLevelDescriptor.class);
        hashSet.add(ESDescriptor.class);
        hashSet.add(DecoderConfigDescriptor.class);
        for (Class clazz : hashSet) {
            Descriptor descriptor = clazz.getAnnotation(Descriptor.class);
            int[] nArray = descriptor.tags();
            int n = descriptor.objectTypeIndication();
            Map<Integer, Class<? extends BaseDescriptor>> map = descriptorRegistry.get(n);
            if (map == null) {
                map = new HashMap<Integer, Class<? extends BaseDescriptor>>();
            }
            for (int n2 : nArray) {
                map.put(n2, clazz);
            }
            descriptorRegistry.put(n, map);
        }
    }
}

