/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class ChangeTimeScaleTrack
implements Track {
    private static final Logger LOG = Logger.getLogger(ChangeTimeScaleTrack.class.getName());
    Track source;
    List<CompositionTimeToSample.Entry> ctts;
    List<TimeToSampleBox.Entry> tts;
    long timeScale;

    public ChangeTimeScaleTrack(Track track, long l, long[] lArray) {
        this.source = track;
        this.timeScale = l;
        double d = (double)l / (double)track.getTrackMetaData().getTimescale();
        this.ctts = ChangeTimeScaleTrack.adjustCtts(track.getCompositionTimeEntries(), d);
        this.tts = ChangeTimeScaleTrack.adjustTts(track.getDecodingTimeEntries(), d, lArray, ChangeTimeScaleTrack.getTimes(track, lArray, l));
    }

    private static long[] getTimes(Track track, long[] lArray, long l) {
        long[] lArray2 = new long[lArray.length];
        LinkedList<TimeToSampleBox.Entry> linkedList = new LinkedList<TimeToSampleBox.Entry>(track.getDecodingTimeEntries());
        int n = 1;
        long l2 = 0L;
        long l3 = 0L;
        int n2 = 0;
        long l4 = 0L;
        while ((long)n <= lArray[lArray.length - 1]) {
            if ((long)n++ == lArray[n2]) {
                lArray2[n2++] = l2 * l / track.getTrackMetaData().getTimescale();
            }
            if (l4-- == 0L) {
                TimeToSampleBox.Entry entry = (TimeToSampleBox.Entry)linkedList.poll();
                l4 = entry.getCount() - 1L;
                l3 = entry.getDelta();
            }
            l2 += l3;
        }
        return lArray2;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.source.getSampleDescriptionBox();
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        return this.tts;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return this.ctts;
    }

    @Override
    public long[] getSyncSamples() {
        return this.source.getSyncSamples();
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return this.source.getSampleDependencies();
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        TrackMetaData trackMetaData = (TrackMetaData)this.source.getTrackMetaData().clone();
        trackMetaData.setTimescale(this.timeScale);
        return trackMetaData;
    }

    @Override
    public String getHandler() {
        return this.source.getHandler();
    }

    @Override
    public boolean isEnabled() {
        return this.source.isEnabled();
    }

    @Override
    public boolean isInMovie() {
        return this.source.isInMovie();
    }

    @Override
    public boolean isInPreview() {
        return this.source.isInPreview();
    }

    @Override
    public boolean isInPoster() {
        return this.source.isInPoster();
    }

    @Override
    public List<ByteBuffer> getSamples() {
        return this.source.getSamples();
    }

    static List<CompositionTimeToSample.Entry> adjustCtts(List<CompositionTimeToSample.Entry> list, double d) {
        if (list != null) {
            ArrayList<CompositionTimeToSample.Entry> arrayList = new ArrayList<CompositionTimeToSample.Entry>(list.size());
            for (CompositionTimeToSample.Entry entry : list) {
                arrayList.add(new CompositionTimeToSample.Entry(entry.getCount(), (int)Math.round(d * (double)entry.getOffset())));
            }
            return arrayList;
        }
        return null;
    }

    static List<TimeToSampleBox.Entry> adjustTts(List<TimeToSampleBox.Entry> list, double d, long[] lArray, long[] lArray2) {
        long[] lArray3 = TimeToSampleBox.blowupTimeToSamples(list);
        long l = 0L;
        LinkedList<TimeToSampleBox.Entry> linkedList = new LinkedList<TimeToSampleBox.Entry>();
        for (int i = 1; i <= lArray3.length; ++i) {
            long l2 = lArray3[i - 1];
            long l3 = Math.round(d * (double)l2);
            TimeToSampleBox.Entry entry = linkedList.peekLast();
            int n = Arrays.binarySearch(lArray, (long)(i + 1));
            if (n >= 0 && lArray2[n] != l) {
                long l4 = lArray2[n] - (l + l3);
                LOG.finest(String.format("Sample %d %d / %d - correct by %d", i, l, lArray2[n], l4));
                l3 += l4;
            }
            l += l3;
            if (entry == null) {
                linkedList.add(new TimeToSampleBox.Entry(1L, l3));
                continue;
            }
            if (entry.getDelta() != l3) {
                linkedList.add(new TimeToSampleBox.Entry(1L, l3));
                continue;
            }
            entry.setCount(entry.getCount() + 1L);
        }
        return linkedList;
    }

    @Override
    public Box getMediaHeaderBox() {
        return this.source.getMediaHeaderBox();
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return this.source.getSubsampleInformationBox();
    }

    public String toString() {
        return "ChangeTimeScaleTrack{source=" + this.source + '}';
    }
}

