/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.builder;

import com.coremedia.iso.boxes.TimeToSampleBox;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.builder.FragmentIntersectionFinder;
import java.util.Arrays;
import java.util.List;

public class TwoSecondIntersectionFinder
implements FragmentIntersectionFinder {
    private int fragmentLength = 2;

    public TwoSecondIntersectionFinder() {
    }

    public TwoSecondIntersectionFinder(int n) {
        this.fragmentLength = n;
    }

    protected long getDuration(Track track) {
        long l = 0L;
        for (TimeToSampleBox.Entry entry : track.getDecodingTimeEntries()) {
            l += entry.getCount() * entry.getDelta();
        }
        return l;
    }

    @Override
    public long[] sampleNumbers(Track track, Movie movie) {
        int n;
        List<TimeToSampleBox.Entry> list = track.getDecodingTimeEntries();
        double d = 0.0;
        for (Track object2 : movie.getTracks()) {
            double l = this.getDuration(object2) / object2.getTrackMetaData().getTimescale();
            if (!(d < l)) continue;
            d = l;
        }
        int n2 = (int)Math.ceil(d / (double)this.fragmentLength) - 1;
        if (n2 < 1) {
            n2 = 1;
        }
        long[] lArray = new long[n2];
        Arrays.fill(lArray, -1L);
        lArray[0] = 1L;
        long l = 0L;
        int n3 = 0;
        for (TimeToSampleBox.Entry entry : list) {
            int n4;
            n = 0;
            while ((long)n < entry.getCount() && (n4 = (int)(l / track.getTrackMetaData().getTimescale() / (long)this.fragmentLength) + 1) < lArray.length) {
                lArray[n4] = n3++ + 1;
                l += entry.getDelta();
                ++n;
            }
        }
        long l2 = n3 + 1;
        for (n = lArray.length - 1; n >= 0; --n) {
            if (lArray[n] == -1L) {
                lArray[n] = l2;
            }
            l2 = lArray[n];
        }
        return lArray;
    }
}

