/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.builder;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.DataEntryUrlBox;
import com.coremedia.iso.boxes.DataInformationBox;
import com.coremedia.iso.boxes.DataReferenceBox;
import com.coremedia.iso.boxes.FileTypeBox;
import com.coremedia.iso.boxes.HandlerBox;
import com.coremedia.iso.boxes.MediaBox;
import com.coremedia.iso.boxes.MediaHeaderBox;
import com.coremedia.iso.boxes.MediaInformationBox;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.MovieHeaderBox;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleSizeBox;
import com.coremedia.iso.boxes.SampleTableBox;
import com.coremedia.iso.boxes.SampleToChunkBox;
import com.coremedia.iso.boxes.StaticChunkOffsetBox;
import com.coremedia.iso.boxes.SyncSampleBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.TrackHeaderBox;
import com.googlecode.mp4parser.authoring.DateHelper;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.builder.FragmentIntersectionFinder;
import com.googlecode.mp4parser.authoring.builder.Mp4Builder;
import com.googlecode.mp4parser.authoring.builder.TwoSecondIntersectionFinder;
import com.googlecode.mp4parser.util.CastUtils;
import com.googlecode.mp4parser.util.Path;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultMp4Builder
implements Mp4Builder {
    Set<StaticChunkOffsetBox> chunkOffsetBoxes = new HashSet<StaticChunkOffsetBox>();
    private static Logger LOG = Logger.getLogger(DefaultMp4Builder.class.getName());
    HashMap<Track, List<ByteBuffer>> track2Sample = new HashMap();
    HashMap<Track, long[]> track2SampleSizes = new HashMap();
    private FragmentIntersectionFinder intersectionFinder = new TwoSecondIntersectionFinder();

    public void setIntersectionFinder(FragmentIntersectionFinder fragmentIntersectionFinder) {
        this.intersectionFinder = fragmentIntersectionFinder;
    }

    @Override
    public IsoFile build(Movie movie) {
        Object object;
        Object l;
        List<Box> list;
        LOG.fine("Creating movie " + movie);
        for (Track object32 : movie.getTracks()) {
            list = object32.getSamples();
            this.putSamples(object32, list);
            l = new long[list.size()];
            for (int i = 0; i < ((long[])l).length; ++i) {
                object = (ByteBuffer)list.get(i);
                l[i] = ((Buffer)object).limit() - ((Buffer)object).position();
            }
            this.track2SampleSizes.put(object32, (long[])l);
        }
        IsoFile isoFile = new IsoFile();
        isoFile.addBox(this.createFileTypeBox(movie));
        HashMap<Track, int[]> hashMap = new HashMap<Track, int[]>();
        list = movie.getTracks().iterator();
        while (list.hasNext()) {
            l = (Track)list.next();
            hashMap.put((Track)l, this.getChunkSizes((Track)l, movie));
        }
        isoFile.addBox(this.createMovieBox(movie, hashMap));
        list = Path.getPaths(isoFile, "/moov/trak/mdia/minf/stbl/stsz");
        long l2 = 0L;
        for (Box l22 : list) {
            l2 += DefaultMp4Builder.sum(((SampleSizeBox)l22).getSampleSizes());
        }
        object = new InterleaveChunkMdat(movie, hashMap, l2);
        isoFile.addBox((Box)object);
        long l3 = ((InterleaveChunkMdat)object).getDataOffset();
        for (StaticChunkOffsetBox staticChunkOffsetBox : this.chunkOffsetBoxes) {
            long[] lArray = staticChunkOffsetBox.getChunkOffsets();
            int n = 0;
            while (n < lArray.length) {
                int n2 = n++;
                lArray[n2] = lArray[n2] + l3;
            }
        }
        return isoFile;
    }

    protected List<ByteBuffer> putSamples(Track track, List<ByteBuffer> list) {
        return this.track2Sample.put(track, list);
    }

    protected FileTypeBox createFileTypeBox(Movie movie) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("isom");
        linkedList.add("iso2");
        linkedList.add("avc1");
        return new FileTypeBox("isom", 0L, linkedList);
    }

    protected MovieBox createMovieBox(Movie movie, Map<Track, int[]> map) {
        MovieBox movieBox = new MovieBox();
        MovieHeaderBox movieHeaderBox = new MovieHeaderBox();
        movieHeaderBox.setCreationTime(DateHelper.convert(new Date()));
        movieHeaderBox.setModificationTime(DateHelper.convert(new Date()));
        long l = this.getTimescale(movie);
        long l2 = 0L;
        for (Track track : movie.getTracks()) {
            long l3 = DefaultMp4Builder.getDuration(track) * l / track.getTrackMetaData().getTimescale();
            if (l3 <= l2) continue;
            l2 = l3;
        }
        movieHeaderBox.setDuration(l2);
        movieHeaderBox.setTimescale(l);
        long l4 = 0L;
        for (Track track : movie.getTracks()) {
            l4 = l4 < track.getTrackMetaData().getTrackId() ? track.getTrackMetaData().getTrackId() : l4;
        }
        movieHeaderBox.setNextTrackId(++l4);
        if (movieHeaderBox.getCreationTime() >= 0x100000000L || movieHeaderBox.getModificationTime() >= 0x100000000L || movieHeaderBox.getDuration() >= 0x100000000L) {
            movieHeaderBox.setVersion(1);
        }
        movieBox.addBox(movieHeaderBox);
        for (Track track : movie.getTracks()) {
            movieBox.addBox(this.createTrackBox(track, movie, map));
        }
        Box box = this.createUdta(movie);
        if (box != null) {
            movieBox.addBox(box);
        }
        return movieBox;
    }

    protected Box createUdta(Movie movie) {
        return null;
    }

    protected TrackBox createTrackBox(Track track, Movie movie, Map<Track, int[]> map) {
        Object object;
        Object object2;
        Object object3;
        TrackBox trackBox = new TrackBox();
        TrackHeaderBox trackHeaderBox = new TrackHeaderBox();
        int n = 0;
        if (track.isEnabled()) {
            ++n;
        }
        if (track.isInMovie()) {
            n += 2;
        }
        if (track.isInPreview()) {
            n += 4;
        }
        if (track.isInPoster()) {
            n += 8;
        }
        trackHeaderBox.setFlags(n);
        trackHeaderBox.setAlternateGroup(track.getTrackMetaData().getGroup());
        trackHeaderBox.setCreationTime(DateHelper.convert(track.getTrackMetaData().getCreationTime()));
        trackHeaderBox.setDuration(DefaultMp4Builder.getDuration(track) * this.getTimescale(movie) / track.getTrackMetaData().getTimescale());
        trackHeaderBox.setHeight(track.getTrackMetaData().getHeight());
        trackHeaderBox.setWidth(track.getTrackMetaData().getWidth());
        trackHeaderBox.setLayer(track.getTrackMetaData().getLayer());
        trackHeaderBox.setModificationTime(DateHelper.convert(new Date()));
        trackHeaderBox.setTrackId(track.getTrackMetaData().getTrackId());
        trackHeaderBox.setVolume(track.getTrackMetaData().getVolume());
        if (trackHeaderBox.getCreationTime() >= 0x100000000L || trackHeaderBox.getModificationTime() >= 0x100000000L || trackHeaderBox.getDuration() >= 0x100000000L) {
            trackHeaderBox.setVersion(1);
        }
        trackBox.addBox(trackHeaderBox);
        MediaBox mediaBox = new MediaBox();
        trackBox.addBox(mediaBox);
        MediaHeaderBox mediaHeaderBox = new MediaHeaderBox();
        mediaHeaderBox.setCreationTime(DateHelper.convert(track.getTrackMetaData().getCreationTime()));
        mediaHeaderBox.setDuration(DefaultMp4Builder.getDuration(track));
        mediaHeaderBox.setTimescale(track.getTrackMetaData().getTimescale());
        mediaHeaderBox.setLanguage(track.getTrackMetaData().getLanguage());
        mediaBox.addBox(mediaHeaderBox);
        HandlerBox handlerBox = new HandlerBox();
        mediaBox.addBox(handlerBox);
        handlerBox.setHandlerType(track.getHandler());
        MediaInformationBox mediaInformationBox = new MediaInformationBox();
        mediaInformationBox.addBox(track.getMediaHeaderBox());
        DataInformationBox dataInformationBox = new DataInformationBox();
        DataReferenceBox dataReferenceBox = new DataReferenceBox();
        dataInformationBox.addBox(dataReferenceBox);
        DataEntryUrlBox dataEntryUrlBox = new DataEntryUrlBox();
        dataEntryUrlBox.setFlags(1);
        dataReferenceBox.addBox(dataEntryUrlBox);
        mediaInformationBox.addBox(dataInformationBox);
        SampleTableBox sampleTableBox = new SampleTableBox();
        sampleTableBox.addBox(track.getSampleDescriptionBox());
        List<TimeToSampleBox.Entry> list = track.getDecodingTimeEntries();
        if (list != null && !track.getDecodingTimeEntries().isEmpty()) {
            object3 = new TimeToSampleBox();
            ((TimeToSampleBox)object3).setEntries(track.getDecodingTimeEntries());
            sampleTableBox.addBox((Box)object3);
        }
        if ((object3 = track.getCompositionTimeEntries()) != null && !object3.isEmpty()) {
            object2 = new CompositionTimeToSample();
            ((CompositionTimeToSample)object2).setEntries((List<CompositionTimeToSample.Entry>)object3);
            sampleTableBox.addBox((Box)object2);
        }
        if ((object2 = track.getSyncSamples()) != null && ((long[])object2).length > 0) {
            object = new SyncSampleBox();
            ((SyncSampleBox)object).setSampleNumber((long[])object2);
            sampleTableBox.addBox((Box)object);
        }
        if (track.getSampleDependencies() != null && !track.getSampleDependencies().isEmpty()) {
            object = new SampleDependencyTypeBox();
            ((SampleDependencyTypeBox)object).setEntries(track.getSampleDependencies());
            sampleTableBox.addBox((Box)object);
        }
        object = map.get(track);
        SampleToChunkBox sampleToChunkBox = new SampleToChunkBox();
        sampleToChunkBox.setEntries(new LinkedList<SampleToChunkBox.Entry>());
        long l = Integer.MIN_VALUE;
        for (int i = 0; i < ((Object)object).length; ++i) {
            if (l == (long)object[i]) continue;
            sampleToChunkBox.getEntries().add(new SampleToChunkBox.Entry(i + 1, (long)object[i], 1L));
            l = (long)object[i];
        }
        sampleTableBox.addBox(sampleToChunkBox);
        SampleSizeBox sampleSizeBox = new SampleSizeBox();
        sampleSizeBox.setSampleSizes(this.track2SampleSizes.get(track));
        sampleTableBox.addBox(sampleSizeBox);
        StaticChunkOffsetBox staticChunkOffsetBox = new StaticChunkOffsetBox();
        this.chunkOffsetBoxes.add(staticChunkOffsetBox);
        long l2 = 0L;
        long[] lArray = new long[((Object)object).length];
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Calculating chunk offsets for track_" + track.getTrackMetaData().getTrackId());
        }
        for (int i = 0; i < ((Object)object).length; ++i) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Calculating chunk offsets for track_" + track.getTrackMetaData().getTrackId() + " chunk " + i);
            }
            for (Track track2 : movie.getTracks()) {
                int n2;
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Adding offsets of track_" + track2.getTrackMetaData().getTrackId());
                }
                int[] nArray = map.get(track2);
                long l3 = 0L;
                for (n2 = 0; n2 < i; ++n2) {
                    l3 += (long)nArray[n2];
                }
                if (track2 == track) {
                    lArray[i] = l2;
                }
                n2 = CastUtils.l2i(l3);
                while ((long)n2 < l3 + (long)nArray[i]) {
                    l2 += this.track2SampleSizes.get(track2)[n2];
                    ++n2;
                }
            }
        }
        staticChunkOffsetBox.setChunkOffsets(lArray);
        sampleTableBox.addBox(staticChunkOffsetBox);
        mediaInformationBox.addBox(sampleTableBox);
        mediaBox.addBox(mediaInformationBox);
        return trackBox;
    }

    int[] getChunkSizes(Track track, Movie movie) {
        long[] lArray = this.intersectionFinder.sampleNumbers(track, movie);
        int[] nArray = new int[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            long l = lArray[i] - 1L;
            long l2 = lArray.length == i + 1 ? (long)track.getSamples().size() : lArray[i + 1] - 1L;
            nArray[i] = CastUtils.l2i(l2 - l);
        }
        assert ((long)this.track2Sample.get(track).size() == DefaultMp4Builder.sum(nArray)) : "The number of samples and the sum of all chunk lengths must be equal";
        return nArray;
    }

    private static long sum(int[] nArray) {
        long l = 0L;
        int[] nArray2 = nArray;
        int n = nArray2.length;
        for (int i = 0; i < n; ++i) {
            long l2 = nArray2[i];
            l += l2;
        }
        return l;
    }

    private static long sum(long[] lArray) {
        long l = 0L;
        for (long l2 : lArray) {
            l += l2;
        }
        return l;
    }

    protected static long getDuration(Track track) {
        long l = 0L;
        for (TimeToSampleBox.Entry entry : track.getDecodingTimeEntries()) {
            l += entry.getCount() * entry.getDelta();
        }
        return l;
    }

    public long getTimescale(Movie movie) {
        long l = movie.getTracks().iterator().next().getTrackMetaData().getTimescale();
        for (Track track : movie.getTracks()) {
            l = DefaultMp4Builder.gcd(track.getTrackMetaData().getTimescale(), l);
        }
        return l;
    }

    public static long gcd(long l, long l2) {
        if (l2 == 0L) {
            return l;
        }
        return DefaultMp4Builder.gcd(l2, l % l2);
    }

    public List<ByteBuffer> unifyAdjacentBuffers(List<ByteBuffer> list) {
        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>(list.size());
        list = new ArrayList<ByteBuffer>(list);
        for (ByteBuffer byteBuffer : list) {
            ByteBuffer byteBuffer2;
            int n = arrayList.size() - 1;
            if (n >= 0 && byteBuffer.hasArray() && arrayList.get(n).hasArray() && byteBuffer.array() == arrayList.get(n).array() && arrayList.get(n).arrayOffset() + arrayList.get(n).limit() == byteBuffer.arrayOffset()) {
                byteBuffer2 = arrayList.remove(n);
                ByteBuffer byteBuffer3 = ByteBuffer.wrap(byteBuffer.array(), byteBuffer2.arrayOffset(), byteBuffer2.limit() + byteBuffer.limit()).slice();
                arrayList.add(byteBuffer3);
                continue;
            }
            if (n >= 0 && byteBuffer instanceof MappedByteBuffer && arrayList.get(n) instanceof MappedByteBuffer && arrayList.get(n).limit() == arrayList.get(n).capacity() - byteBuffer.capacity()) {
                byteBuffer2 = arrayList.get(n);
                byteBuffer2.limit(byteBuffer.limit() + byteBuffer2.limit());
                continue;
            }
            arrayList.add(byteBuffer);
        }
        return arrayList;
    }

    private class InterleaveChunkMdat
    implements Box {
        List<Track> tracks;
        List<List<ByteBuffer>> chunkList = new ArrayList<List<ByteBuffer>>();
        ContainerBox parent;
        long contentSize;

        @Override
        public ContainerBox getParent() {
            return this.parent;
        }

        @Override
        public void setParent(ContainerBox containerBox) {
            this.parent = containerBox;
        }

        @Override
        public void parse(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer, long l, BoxParser boxParser) throws IOException {
        }

        private InterleaveChunkMdat(Movie movie, Map<Track, int[]> map, long l) {
            this.contentSize = l;
            this.tracks = movie.getTracks();
            for (int i = 0; i < map.values().iterator().next().length; ++i) {
                for (Track track : this.tracks) {
                    int[] nArray = map.get(track);
                    long l2 = 0L;
                    for (int j = 0; j < i; ++j) {
                        l2 += (long)nArray[j];
                    }
                    List<ByteBuffer> list = DefaultMp4Builder.this.track2Sample.get(track).subList(CastUtils.l2i(l2), CastUtils.l2i(l2 + (long)nArray[i]));
                    this.chunkList.add(list);
                }
            }
        }

        public long getDataOffset() {
            Box box = this;
            long l = 16L;
            while (box.getParent() != null) {
                for (Box box2 : box.getParent().getBoxes()) {
                    if (box == box2) break;
                    l += box2.getSize();
                }
                box = box.getParent();
            }
            return l;
        }

        @Override
        public String getType() {
            return "mdat";
        }

        @Override
        public long getSize() {
            return 16L + this.contentSize;
        }

        private boolean isSmallBox(long l) {
            return l + 8L < 0x100000000L;
        }

        @Override
        public void getBox(WritableByteChannel writableByteChannel) throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.allocate(16);
            long l = this.getSize();
            if (this.isSmallBox(l)) {
                IsoTypeWriter.writeUInt32(byteBuffer, l);
            } else {
                IsoTypeWriter.writeUInt32(byteBuffer, 1L);
            }
            byteBuffer.put(IsoFile.fourCCtoBytes("mdat"));
            if (this.isSmallBox(l)) {
                byteBuffer.put(new byte[8]);
            } else {
                IsoTypeWriter.writeUInt64(byteBuffer, l);
            }
            byteBuffer.rewind();
            writableByteChannel.write(byteBuffer);
            for (List<ByteBuffer> list : this.chunkList) {
                list = DefaultMp4Builder.this.unifyAdjacentBuffers(list);
                for (ByteBuffer byteBuffer2 : list) {
                    writableByteChannel.write(byteBuffer2);
                }
            }
        }
    }
}

