/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.fragment;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.fragment.SampleFlags;
import com.coremedia.iso.boxes.fragment.TrackExtendsBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentHeaderBox;
import com.googlecode.mp4parser.AbstractFullBox;
import com.googlecode.mp4parser.util.CastUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class TrackRunBox
extends AbstractFullBox {
    public static final String TYPE = "trun";
    private int dataOffset;
    private SampleFlags firstSampleFlags;
    private List<Entry> entries = new ArrayList<Entry>();

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setDataOffset(int n) {
        if (n == -1) {
            this.setFlags(this.getFlags() & 0xFFFFFE);
        } else {
            this.setFlags(this.getFlags() | 1);
        }
        this.dataOffset = n;
    }

    public long[] getSampleCompositionTimeOffsets() {
        if (this.isSampleCompositionTimeOffsetPresent()) {
            long[] lArray = new long[this.entries.size()];
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = this.entries.get(i).getSampleCompositionTimeOffset();
            }
            return lArray;
        }
        return null;
    }

    public TrackExtendsBox getTrackExtendsBox() {
        TrackFragmentHeaderBox trackFragmentHeaderBox = ((TrackFragmentBox)this.getParent()).getTrackFragmentHeaderBox();
        List<MovieBox> list = trackFragmentHeaderBox.getIsoFile().getBoxes(MovieBox.class);
        if (list.size() == 0) {
            return null;
        }
        List<TrackExtendsBox> list2 = list.get(0).getBoxes(TrackExtendsBox.class, true);
        TrackExtendsBox trackExtendsBox = null;
        for (TrackExtendsBox trackExtendsBox2 : list2) {
            if (trackExtendsBox2.getTrackId() != trackFragmentHeaderBox.getTrackId()) continue;
            trackExtendsBox = trackExtendsBox2;
        }
        return trackExtendsBox;
    }

    public TrackRunBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        long l = 8L;
        int n = this.getFlags();
        if ((n & 1) == 1) {
            l += 4L;
        }
        if ((n & 4) == 4) {
            l += 4L;
        }
        long l2 = 0L;
        if ((n & 0x100) == 256) {
            l2 += 4L;
        }
        if ((n & 0x200) == 512) {
            l2 += 4L;
        }
        if ((n & 0x400) == 1024) {
            l2 += 4L;
        }
        if ((n & 0x800) == 2048) {
            l2 += 4L;
        }
        return l += l2 * (long)this.entries.size();
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt32(byteBuffer, this.entries.size());
        int n = this.getFlags();
        if ((n & 1) == 1) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.dataOffset);
        }
        if ((n & 4) == 4) {
            this.firstSampleFlags.getContent(byteBuffer);
        }
        for (Entry entry : this.entries) {
            if ((n & 0x100) == 256) {
                IsoTypeWriter.writeUInt32(byteBuffer, entry.sampleDuration);
            }
            if ((n & 0x200) == 512) {
                IsoTypeWriter.writeUInt32(byteBuffer, entry.sampleSize);
            }
            if ((n & 0x400) == 1024) {
                entry.sampleFlags.getContent(byteBuffer);
            }
            if ((n & 0x800) != 2048) continue;
            byteBuffer.putInt(entry.sampleCompositionTimeOffset);
        }
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        long l = IsoTypeReader.readUInt32(byteBuffer);
        this.dataOffset = (this.getFlags() & 1) == 1 ? CastUtils.l2i(IsoTypeReader.readUInt32(byteBuffer)) : -1;
        if ((this.getFlags() & 4) == 4) {
            this.firstSampleFlags = new SampleFlags(byteBuffer);
        }
        int n = 0;
        while ((long)n < l) {
            Entry entry = new Entry();
            if ((this.getFlags() & 0x100) == 256) {
                entry.sampleDuration = IsoTypeReader.readUInt32(byteBuffer);
            }
            if ((this.getFlags() & 0x200) == 512) {
                entry.sampleSize = IsoTypeReader.readUInt32(byteBuffer);
            }
            if ((this.getFlags() & 0x400) == 1024) {
                entry.sampleFlags = new SampleFlags(byteBuffer);
            }
            if ((this.getFlags() & 0x800) == 2048) {
                entry.sampleCompositionTimeOffset = byteBuffer.getInt();
            }
            this.entries.add(entry);
            ++n;
        }
    }

    public long getSampleCount() {
        return this.entries.size();
    }

    public boolean isDataOffsetPresent() {
        return (this.getFlags() & 1) == 1;
    }

    public boolean isFirstSampleFlagsPresent() {
        return (this.getFlags() & 4) == 4;
    }

    public boolean isSampleSizePresent() {
        return (this.getFlags() & 0x200) == 512;
    }

    public boolean isSampleDurationPresent() {
        return (this.getFlags() & 0x100) == 256;
    }

    public boolean isSampleFlagsPresent() {
        return (this.getFlags() & 0x400) == 1024;
    }

    public boolean isSampleCompositionTimeOffsetPresent() {
        return (this.getFlags() & 0x800) == 2048;
    }

    public void setDataOffsetPresent(boolean bl) {
        if (bl) {
            this.setFlags(this.getFlags() | 1);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFFE);
        }
    }

    public void setSampleSizePresent(boolean bl) {
        if (bl) {
            this.setFlags(this.getFlags() | 0x200);
        } else {
            this.setFlags(this.getFlags() & 0xFFFDFF);
        }
    }

    public void setSampleDurationPresent(boolean bl) {
        if (bl) {
            this.setFlags(this.getFlags() | 0x100);
        } else {
            this.setFlags(this.getFlags() & 0xFFFEFF);
        }
    }

    public void setSampleFlagsPresent(boolean bl) {
        if (bl) {
            this.setFlags(this.getFlags() | 0x400);
        } else {
            this.setFlags(this.getFlags() & 0xFFFBFF);
        }
    }

    public void setSampleCompositionTimeOffsetPresent(boolean bl) {
        if (bl) {
            this.setFlags(this.getFlags() | 0x800);
        } else {
            this.setFlags(this.getFlags() & 0xFFF7FF);
        }
    }

    public int getDataOffset() {
        return this.dataOffset;
    }

    public SampleFlags getFirstSampleFlags() {
        return this.firstSampleFlags;
    }

    public void setFirstSampleFlags(SampleFlags sampleFlags) {
        if (sampleFlags == null) {
            this.setFlags(this.getFlags() & 0xFFFFFB);
        } else {
            this.setFlags(this.getFlags() | 4);
        }
        this.firstSampleFlags = sampleFlags;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TrackRunBox");
        stringBuilder.append("{sampleCount=").append(this.entries.size());
        stringBuilder.append(", dataOffset=").append(this.dataOffset);
        stringBuilder.append(", dataOffsetPresent=").append(this.isDataOffsetPresent());
        stringBuilder.append(", sampleSizePresent=").append(this.isSampleSizePresent());
        stringBuilder.append(", sampleDurationPresent=").append(this.isSampleDurationPresent());
        stringBuilder.append(", sampleFlagsPresentPresent=").append(this.isSampleFlagsPresent());
        stringBuilder.append(", sampleCompositionTimeOffsetPresent=").append(this.isSampleCompositionTimeOffsetPresent());
        stringBuilder.append(", firstSampleFlags=").append(this.firstSampleFlags);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public void setEntries(List<Entry> list) {
        this.entries = list;
    }

    public static class Entry {
        private long sampleDuration;
        private long sampleSize;
        private SampleFlags sampleFlags;
        private int sampleCompositionTimeOffset;

        public Entry() {
        }

        public Entry(long l, long l2, SampleFlags sampleFlags, int n) {
            this.sampleDuration = l;
            this.sampleSize = l2;
            this.sampleFlags = sampleFlags;
            this.sampleCompositionTimeOffset = n;
        }

        public long getSampleDuration() {
            return this.sampleDuration;
        }

        public long getSampleSize() {
            return this.sampleSize;
        }

        public SampleFlags getSampleFlags() {
            return this.sampleFlags;
        }

        public int getSampleCompositionTimeOffset() {
            return this.sampleCompositionTimeOffset;
        }

        public void setSampleDuration(long l) {
            this.sampleDuration = l;
        }

        public void setSampleSize(long l) {
            this.sampleSize = l;
        }

        public void setSampleFlags(SampleFlags sampleFlags) {
            this.sampleFlags = sampleFlags;
        }

        public void setSampleCompositionTimeOffset(int n) {
            this.sampleCompositionTimeOffset = n;
        }

        public String toString() {
            return "Entry{sampleDuration=" + this.sampleDuration + ", sampleSize=" + this.sampleSize + ", sampleFlags=" + this.sampleFlags + ", sampleCompositionTimeOffset=" + this.sampleCompositionTimeOffset + '}';
        }
    }
}

