/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.AbstractMediaHeaderBox;
import java.nio.ByteBuffer;

public class VideoMediaHeaderBox
extends AbstractMediaHeaderBox {
    private int graphicsmode = 0;
    private int[] opcolor = new int[]{0, 0, 0};
    public static final String TYPE = "vmhd";

    public VideoMediaHeaderBox() {
        super(TYPE);
        this.setFlags(1);
    }

    public int getGraphicsmode() {
        return this.graphicsmode;
    }

    public int[] getOpcolor() {
        return this.opcolor;
    }

    @Override
    protected long getContentSize() {
        return 12L;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        this.graphicsmode = IsoTypeReader.readUInt16(byteBuffer);
        this.opcolor = new int[3];
        for (int i = 0; i < 3; ++i) {
            this.opcolor[i] = IsoTypeReader.readUInt16(byteBuffer);
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt16(byteBuffer, this.graphicsmode);
        for (int n : this.opcolor) {
            IsoTypeWriter.writeUInt16(byteBuffer, n);
        }
    }

    public String toString() {
        return "VideoMediaHeaderBox[graphicsmode=" + this.getGraphicsmode() + ";opcolor0=" + this.getOpcolor()[0] + ";opcolor1=" + this.getOpcolor()[1] + ";opcolor2=" + this.getOpcolor()[2] + "]";
    }

    public void setOpcolor(int[] nArray) {
        this.opcolor = nArray;
    }

    public void setGraphicsmode(int n) {
        this.graphicsmode = n;
    }
}

