/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractFullBox;
import com.googlecode.mp4parser.util.CastUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TimeToSampleBox
extends AbstractFullBox {
    public static final String TYPE = "stts";
    List<Entry> entries = Collections.emptyList();

    public TimeToSampleBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        return 8 + this.entries.size() * 8;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        int n = CastUtils.l2i(IsoTypeReader.readUInt32(byteBuffer));
        this.entries = new ArrayList<Entry>(n);
        for (int i = 0; i < n; ++i) {
            this.entries.add(new Entry(IsoTypeReader.readUInt32(byteBuffer), IsoTypeReader.readUInt32(byteBuffer)));
        }
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt32(byteBuffer, this.entries.size());
        for (Entry entry : this.entries) {
            IsoTypeWriter.writeUInt32(byteBuffer, entry.getCount());
            IsoTypeWriter.writeUInt32(byteBuffer, entry.getDelta());
        }
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry> list) {
        this.entries = list;
    }

    public String toString() {
        return "TimeToSampleBox[entryCount=" + this.entries.size() + "]";
    }

    public static long[] blowupTimeToSamples(List<Entry> list) {
        long l = 0L;
        for (Entry entry : list) {
            l += entry.getCount();
        }
        assert (l <= Integer.MAX_VALUE);
        Object object = new long[(int)l];
        int n = 0;
        for (Entry entry : list) {
            int n2 = 0;
            while ((long)n2 < entry.getCount()) {
                object[n++] = entry.getDelta();
                ++n2;
            }
        }
        return object;
    }

    public static class Entry {
        long count;
        long delta;

        public Entry(long l, long l2) {
            this.count = l;
            this.delta = l2;
        }

        public long getCount() {
            return this.count;
        }

        public long getDelta() {
            return this.delta;
        }

        public void setCount(long l) {
            this.count = l;
        }

        public void setDelta(long l) {
            this.delta = l;
        }

        public String toString() {
            return "Entry{count=" + this.count + ", delta=" + this.delta + '}';
        }
    }
}

