/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;

public final class OmaDrmAccessUnitFormatBox
extends AbstractFullBox {
    public static final String TYPE = "odaf";
    private boolean selectiveEncryption;
    private byte allBits;
    private int keyIndicatorLength;
    private int initVectorLength;

    @Override
    protected long getContentSize() {
        return 7L;
    }

    public OmaDrmAccessUnitFormatBox() {
        super(TYPE);
    }

    public boolean isSelectiveEncryption() {
        return this.selectiveEncryption;
    }

    public int getKeyIndicatorLength() {
        return this.keyIndicatorLength;
    }

    public int getInitVectorLength() {
        return this.initVectorLength;
    }

    public void setInitVectorLength(int n) {
        this.initVectorLength = n;
    }

    public void setKeyIndicatorLength(int n) {
        this.keyIndicatorLength = n;
    }

    public void setAllBits(byte by) {
        this.allBits = by;
        this.selectiveEncryption = (by & 0x80) == 128;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        this.allBits = (byte)IsoTypeReader.readUInt8(byteBuffer);
        this.selectiveEncryption = (this.allBits & 0x80) == 128;
        this.keyIndicatorLength = IsoTypeReader.readUInt8(byteBuffer);
        this.initVectorLength = IsoTypeReader.readUInt8(byteBuffer);
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt8(byteBuffer, this.allBits);
        IsoTypeWriter.writeUInt8(byteBuffer, this.keyIndicatorLength);
        IsoTypeWriter.writeUInt8(byteBuffer, this.initVectorLength);
    }
}

