/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeReaderVariable;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.IsoTypeWriterVariable;
import com.googlecode.mp4parser.AbstractFullBox;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class ItemLocationBox
extends AbstractFullBox {
    public int offsetSize = 8;
    public int lengthSize = 8;
    public int baseOffsetSize = 8;
    public int indexSize = 0;
    public List<Item> items = new LinkedList<Item>();
    public static final String TYPE = "iloc";

    public ItemLocationBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        long l = 8L;
        for (Item item : this.items) {
            l += (long)item.getSize();
        }
        return l;
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        IsoTypeWriter.writeUInt8(byteBuffer, this.offsetSize << 4 | this.lengthSize);
        if (this.getVersion() == 1) {
            IsoTypeWriter.writeUInt8(byteBuffer, this.baseOffsetSize << 4 | this.indexSize);
        } else {
            IsoTypeWriter.writeUInt8(byteBuffer, this.baseOffsetSize << 4);
        }
        IsoTypeWriter.writeUInt16(byteBuffer, this.items.size());
        for (Item item : this.items) {
            item.getContent(byteBuffer);
        }
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        int n = IsoTypeReader.readUInt8(byteBuffer);
        this.offsetSize = n >>> 4;
        this.lengthSize = n & 0xF;
        n = IsoTypeReader.readUInt8(byteBuffer);
        this.baseOffsetSize = n >>> 4;
        if (this.getVersion() == 1) {
            this.indexSize = n & 0xF;
        }
        int n2 = IsoTypeReader.readUInt16(byteBuffer);
        for (int i = 0; i < n2; ++i) {
            this.items.add(new Item(byteBuffer));
        }
    }

    public int getOffsetSize() {
        return this.offsetSize;
    }

    public void setOffsetSize(int n) {
        this.offsetSize = n;
    }

    public int getLengthSize() {
        return this.lengthSize;
    }

    public void setLengthSize(int n) {
        this.lengthSize = n;
    }

    public int getBaseOffsetSize() {
        return this.baseOffsetSize;
    }

    public void setBaseOffsetSize(int n) {
        this.baseOffsetSize = n;
    }

    public int getIndexSize() {
        return this.indexSize;
    }

    public void setIndexSize(int n) {
        this.indexSize = n;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> list) {
        this.items = list;
    }

    public Item createItem(int n, int n2, int n3, long l, List<Extent> list) {
        return new Item(n, n2, n3, l, list);
    }

    Item createItem(ByteBuffer byteBuffer) {
        return new Item(byteBuffer);
    }

    public Extent createExtent(long l, long l2, long l3) {
        return new Extent(l, l2, l3);
    }

    Extent createExtent(ByteBuffer byteBuffer) {
        return new Extent(byteBuffer);
    }

    public class Extent {
        public long extentOffset;
        public long extentLength;
        public long extentIndex;

        public Extent(long l, long l2, long l3) {
            this.extentOffset = l;
            this.extentLength = l2;
            this.extentIndex = l3;
        }

        public Extent(ByteBuffer byteBuffer) {
            if (ItemLocationBox.this.getVersion() == 1 && ItemLocationBox.this.indexSize > 0) {
                this.extentIndex = IsoTypeReaderVariable.read(byteBuffer, ItemLocationBox.this.indexSize);
            }
            this.extentOffset = IsoTypeReaderVariable.read(byteBuffer, ItemLocationBox.this.offsetSize);
            this.extentLength = IsoTypeReaderVariable.read(byteBuffer, ItemLocationBox.this.lengthSize);
        }

        public void getContent(ByteBuffer byteBuffer) {
            if (ItemLocationBox.this.getVersion() == 1 && ItemLocationBox.this.indexSize > 0) {
                IsoTypeWriterVariable.write(this.extentIndex, byteBuffer, ItemLocationBox.this.indexSize);
            }
            IsoTypeWriterVariable.write(this.extentOffset, byteBuffer, ItemLocationBox.this.offsetSize);
            IsoTypeWriterVariable.write(this.extentLength, byteBuffer, ItemLocationBox.this.lengthSize);
        }

        public int getSize() {
            return (ItemLocationBox.this.indexSize > 0 ? ItemLocationBox.this.indexSize : 0) + ItemLocationBox.this.offsetSize + ItemLocationBox.this.lengthSize;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Extent extent = (Extent)object;
            if (this.extentIndex != extent.extentIndex) {
                return false;
            }
            if (this.extentLength != extent.extentLength) {
                return false;
            }
            return this.extentOffset == extent.extentOffset;
        }

        public int hashCode() {
            int n = (int)(this.extentOffset ^ this.extentOffset >>> 32);
            n = 31 * n + (int)(this.extentLength ^ this.extentLength >>> 32);
            n = 31 * n + (int)(this.extentIndex ^ this.extentIndex >>> 32);
            return n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Extent");
            stringBuilder.append("{extentOffset=").append(this.extentOffset);
            stringBuilder.append(", extentLength=").append(this.extentLength);
            stringBuilder.append(", extentIndex=").append(this.extentIndex);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    public class Item {
        public int itemId;
        public int constructionMethod;
        public int dataReferenceIndex;
        public long baseOffset;
        public List<Extent> extents = new LinkedList<Extent>();

        public Item(ByteBuffer byteBuffer) {
            int n;
            this.itemId = IsoTypeReader.readUInt16(byteBuffer);
            if (ItemLocationBox.this.getVersion() == 1) {
                n = IsoTypeReader.readUInt16(byteBuffer);
                this.constructionMethod = n & 0xF;
            }
            this.dataReferenceIndex = IsoTypeReader.readUInt16(byteBuffer);
            this.baseOffset = ItemLocationBox.this.baseOffsetSize > 0 ? IsoTypeReaderVariable.read(byteBuffer, ItemLocationBox.this.baseOffsetSize) : 0L;
            n = IsoTypeReader.readUInt16(byteBuffer);
            for (int i = 0; i < n; ++i) {
                this.extents.add(new Extent(byteBuffer));
            }
        }

        public Item(int n, int n2, int n3, long l, List<Extent> list) {
            this.itemId = n;
            this.constructionMethod = n2;
            this.dataReferenceIndex = n3;
            this.baseOffset = l;
            this.extents = list;
        }

        public int getSize() {
            int n = 2;
            if (ItemLocationBox.this.getVersion() == 1) {
                n += 2;
            }
            n += 2;
            n += ItemLocationBox.this.baseOffsetSize;
            n += 2;
            for (Extent extent : this.extents) {
                n += extent.getSize();
            }
            return n;
        }

        public void setBaseOffset(long l) {
            this.baseOffset = l;
        }

        public void getContent(ByteBuffer byteBuffer) {
            IsoTypeWriter.writeUInt16(byteBuffer, this.itemId);
            if (ItemLocationBox.this.getVersion() == 1) {
                IsoTypeWriter.writeUInt16(byteBuffer, this.constructionMethod);
            }
            IsoTypeWriter.writeUInt16(byteBuffer, this.dataReferenceIndex);
            if (ItemLocationBox.this.baseOffsetSize > 0) {
                IsoTypeWriterVariable.write(this.baseOffset, byteBuffer, ItemLocationBox.this.baseOffsetSize);
            }
            IsoTypeWriter.writeUInt16(byteBuffer, this.extents.size());
            for (Extent extent : this.extents) {
                extent.getContent(byteBuffer);
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Item item = (Item)object;
            if (this.baseOffset != item.baseOffset) {
                return false;
            }
            if (this.constructionMethod != item.constructionMethod) {
                return false;
            }
            if (this.dataReferenceIndex != item.dataReferenceIndex) {
                return false;
            }
            if (this.itemId != item.itemId) {
                return false;
            }
            return !(this.extents != null ? !this.extents.equals(item.extents) : item.extents != null);
        }

        public int hashCode() {
            int n = this.itemId;
            n = 31 * n + this.constructionMethod;
            n = 31 * n + this.dataReferenceIndex;
            n = 31 * n + (int)(this.baseOffset ^ this.baseOffset >>> 32);
            n = 31 * n + (this.extents != null ? this.extents.hashCode() : 0);
            return n;
        }

        public String toString() {
            return "Item{baseOffset=" + this.baseOffset + ", itemId=" + this.itemId + ", constructionMethod=" + this.constructionMethod + ", dataReferenceIndex=" + this.dataReferenceIndex + ", extents=" + this.extents + '}';
        }
    }
}

