/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import java.lang.reflect.Array;

public abstract class TagDescriptor<T extends Directory> {
    @NotNull
    protected final T _directory;

    public TagDescriptor(@NotNull T t) {
        this._directory = t;
    }

    @Nullable
    public String getDescription(int n) {
        Object object = ((Directory)this._directory).getObject(n);
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            Class<?> clazz = object.getClass().getComponentType();
            boolean bl = clazz.getName().equals("byte");
            int n2 = Array.getLength(object);
            if (bl && n2 > 12) {
                return String.format("[%d byte%s]", n2, n2 == 1 ? "" : "s");
            }
        }
        return ((Directory)this._directory).getString(n);
    }

    @Nullable
    public static String convertBytesToVersionString(@Nullable int[] nArray, int n) {
        if (nArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 4 && i < nArray.length; ++i) {
            char c;
            if (i == n) {
                stringBuilder.append('.');
            }
            if ((c = (char)nArray[i]) < '0') {
                c = (char)(c + 48);
            }
            if (i == 0 && c == '0') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

