/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.controller;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import jd.Launcher;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.logging.Log;

public class PluginClassLoader
extends URLClassLoader {
    private static final PluginClassLoader INSTANCE = new PluginClassLoader();
    private Method findLoadedClass;

    public static PluginClassLoader getInstance() {
        return INSTANCE;
    }

    private PluginClassLoader() {
        super(new URL[]{Application.getRootUrlByClass(Launcher.class, null)}, PluginClassLoader.class.getClassLoader());
        try {
            this.findLoadedClass = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            this.findLoadedClass.setAccessible(true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public PluginClassLoaderChild getChild() {
        return new PluginClassLoaderChild(this);
    }

    public boolean isClassLoaded(String string) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ClassLoader classLoader;
        boolean bl = this.findLoadedClass(string) != null;
        ClassLoader classLoader2 = this;
        while ((classLoader = this.getParent()) != null && classLoader != classLoader2) {
            bl |= this.findLoadedClass.invoke((Object)classLoader, string) != null;
            classLoader2 = classLoader;
        }
        return bl;
    }

    public static class PluginClassLoaderChild
    extends URLClassLoader {
        public PluginClassLoaderChild(ClassLoader classLoader) {
            super(new URL[]{Application.getRootUrlByClass(Launcher.class, null)}, classLoader);
        }

        public synchronized Class loadClass(String string) throws ClassNotFoundException {
            try {
                if (!string.startsWith("jd.plugins.hoster") && !string.startsWith("jd.plugins.decrypter")) {
                    return super.loadClass(string);
                }
                if (string.startsWith("jd.plugins.hoster.RTMPDownload")) {
                    return super.loadClass(string);
                }
                Class<?> clazz = this.findLoadedClass(string);
                if (clazz != null) {
                    return clazz;
                }
                URL uRL = Application.getRessourceURL(string.replace(".", "/") + ".class");
                byte[] byArray = IO.readURL(uRL);
                return this.defineClass(string, byArray, 0, byArray.length);
            }
            catch (Exception exception) {
                Log.exception(exception);
                throw new ClassNotFoundException(exception.getMessage(), exception);
            }
        }
    }
}

