/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;
import jd.plugins.PluginForHost;
import jd.utils.JDUtilities;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.MinTimeWeakReference;
import org.appwork.utils.Application;
import org.jdownloader.AffiliateSettings;

public class DomainInfo
implements Comparable<DomainInfo> {
    private static final long CACHE_TIMEOUT = 30000L;
    private static final int WIDTH = 16;
    private static final int HEIGHT = 16;
    private String tld;
    protected MinTimeWeakReference<ImageIcon> hosterIcon = null;
    protected boolean hosterIconRequested = false;
    private static HashMap<String, DomainInfo> CACHE = new HashMap();

    private DomainInfo(String string) {
        this.tld = string;
    }

    public String toString() {
        return this.tld;
    }

    public String getTld() {
        return this.tld;
    }

    public void setTld(String string) {
        this.tld = string;
    }

    public synchronized ImageIcon getFavIcon() {
        ImageIcon imageIcon = null;
        if (this.hosterIcon != null) {
            imageIcon = this.hosterIcon.get();
            if (imageIcon == null) {
                this.resetFavIcon();
            } else {
                return imageIcon;
            }
        }
        if (!this.hosterIconRequested) {
            this.hosterIconRequested = true;
            imageIcon = null;
            if (imageIcon != null) {
                imageIcon = this.setFavIcon(imageIcon);
                return imageIcon;
            }
        }
        imageIcon = this.setFavIcon(null);
        return imageIcon;
    }

    public void resetFavIcon() {
        this.hosterIconRequested = false;
        this.hosterIcon = null;
    }

    public synchronized ImageIcon setFavIcon(ImageIcon imageIcon) {
        if (imageIcon == null) {
            if (this.hosterIcon != null) {
                imageIcon = this.hosterIcon.get();
            }
            if (imageIcon == null) {
                imageIcon = null;
            }
        } else {
            imageIcon = null;
        }
        this.hosterIcon = new MinTimeWeakReference<ImageIcon>(imageIcon, 30000L, this.getTld());
        return imageIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DomainInfo getInstance(String string) {
        if (string == null) {
            return null;
        }
        HashMap<String, DomainInfo> hashMap = CACHE;
        synchronized (hashMap) {
            DomainInfo domainInfo = CACHE.get(string);
            if (domainInfo == null) {
                domainInfo = new DomainInfo(string);
                CACHE.put(string, domainInfo);
            }
            return domainInfo;
        }
    }

    public AffiliateSettings getAffiliateSettings() {
        URL uRL = Application.getRessourceURL("cfg/aff." + this.getTld() + ".json");
        if (uRL != null && uRL.getProtocol().equals("file")) {
            try {
                File file = new File(new File(uRL.toURI()).getParentFile(), "aff." + this.getTld());
                return JsonConfig.create(file, AffiliateSettings.class);
            }
            catch (URISyntaxException uRISyntaxException) {
                return JsonConfig.create(AffiliateSettings.class);
            }
        }
        return JsonConfig.create(AffiliateSettings.class);
    }

    public String getName() {
        String string = this.getAffiliateSettings().getName();
        if (string == null) {
            return this.getTld();
        }
        return string;
    }

    public ImageIcon getIcon(int n) {
        ImageIcon imageIcon = null;
        if (imageIcon != null && imageIcon.getIconHeight() >= n && imageIcon.getIconWidth() >= n) {
            return null;
        }
        if (!this.hosterIconRequested) {
            this.getFavIcon();
        }
        imageIcon = null;
        return null;
    }

    public PluginForHost findPlugin() {
        return JDUtilities.getPluginForHost(this.getTld());
    }

    @Override
    public int compareTo(DomainInfo domainInfo) {
        return this.getTld().compareTo(domainInfo.getTld());
    }
}

