/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.logging.Log;
import org.appwork.utils.net.httpconnection.HTTPProxyStorable;

public class HTTPProxy {
    public static final HTTPProxy NONE = new HTTPProxy(TYPE.NONE){

        @Override
        public void setLocalIP(InetAddress inetAddress) {
        }

        @Override
        public void setPass(String string) {
        }

        @Override
        public void setPort(int n) {
        }

        @Override
        public void setType(TYPE tYPE) {
        }

        @Override
        public void setUser(String string) {
        }
    };
    private InetAddress localIP = null;
    private String user = null;
    private String pass = null;
    private int port = 80;
    protected String host = null;
    private TYPE type = TYPE.DIRECT;

    public static List<HTTPProxy> getFromSystemProperties() {
        ArrayList<HTTPProxy> arrayList = new ArrayList<HTTPProxy>();
        try {
            HTTPProxy hTTPProxy;
            String string;
            int n;
            String string2 = System.getProperties().getProperty("http.proxyHost");
            if (!StringUtils.isEmpty(string2)) {
                n = 80;
                string = System.getProperty("http.proxyPort");
                if (!StringUtils.isEmpty(string)) {
                    n = Integer.parseInt(string);
                }
                hTTPProxy = new HTTPProxy(TYPE.HTTP, string2, n);
                String string3 = System.getProperty("http.proxyUser");
                String string4 = System.getProperty("http.proxyPassword");
                if (!StringUtils.isEmpty(string3)) {
                    hTTPProxy.setUser(string3);
                }
                if (!StringUtils.isEmpty(string4)) {
                    hTTPProxy.setPass(string4);
                }
                arrayList.add(hTTPProxy);
            }
            if (!StringUtils.isEmpty(string2 = System.getProperties().getProperty("socksProxyHost"))) {
                n = 1080;
                string = System.getProperty("socksProxyPort");
                if (!StringUtils.isEmpty(string)) {
                    n = Integer.parseInt(string);
                }
                hTTPProxy = new HTTPProxy(TYPE.SOCKS5, string2, n);
                arrayList.add(hTTPProxy);
            }
        }
        catch (Throwable throwable) {
            Log.exception(throwable);
        }
        return arrayList;
    }

    public static HTTPProxy getHTTPProxy(HTTPProxyStorable hTTPProxyStorable) {
        if (hTTPProxyStorable == null || hTTPProxyStorable.getType() == null) {
            return null;
        }
        HTTPProxy hTTPProxy = null;
        switch (hTTPProxyStorable.getType()) {
            case NONE: {
                return NONE;
            }
            case DIRECT: {
                hTTPProxy = new HTTPProxy(TYPE.DIRECT);
                if (hTTPProxy.getHost() == null) break;
                try {
                    InetAddress inetAddress = InetAddress.getByName(hTTPProxy.getHost());
                    hTTPProxy.setLocalIP(inetAddress);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                break;
            }
            case HTTP: {
                hTTPProxy = new HTTPProxy(TYPE.HTTP);
                hTTPProxy.host = hTTPProxyStorable.getAddress();
                break;
            }
            case SOCKS4: {
                hTTPProxy = new HTTPProxy(TYPE.SOCKS4);
                hTTPProxy.host = hTTPProxyStorable.getAddress();
            }
            case SOCKS5: {
                hTTPProxy = new HTTPProxy(TYPE.SOCKS5);
                hTTPProxy.host = hTTPProxyStorable.getAddress();
            }
        }
        hTTPProxy.setPass(hTTPProxyStorable.getPassword());
        hTTPProxy.setUser(hTTPProxyStorable.getUsername());
        hTTPProxy.setPort(hTTPProxyStorable.getPort());
        return hTTPProxy;
    }

    private static String[] getInfo(String string, String string2) {
        String[] stringArray = new String[2];
        if (string == null) {
            return stringArray;
        }
        String string3 = string.replaceFirst("http://", "").replaceFirst("https://", "");
        String string4 = new Regex(string, ".*?:(\\d+)").getMatch(0);
        if (string4 != null) {
            stringArray[1] = "" + string4;
        } else {
            if (string2 != null) {
                string4 = new Regex(string2, "(\\d+)").getMatch(0);
            }
            if (string4 != null) {
                stringArray[1] = "" + string4;
            } else {
                Log.L.severe("No proxyport defined, using default 8080");
                stringArray[1] = "8080";
            }
        }
        stringArray[0] = new Regex(string3, "(.*?)(:|/|$)").getMatch(0);
        return stringArray;
    }

    public static HTTPProxyStorable getStorable(HTTPProxy hTTPProxy) {
        if (hTTPProxy == null || hTTPProxy.getType() == null) {
            return null;
        }
        HTTPProxyStorable hTTPProxyStorable = new HTTPProxyStorable();
        switch (hTTPProxy.getType()) {
            case NONE: {
                hTTPProxyStorable.setType(HTTPProxyStorable.TYPE.NONE);
                hTTPProxyStorable.setAddress(null);
                break;
            }
            case DIRECT: {
                hTTPProxyStorable.setType(HTTPProxyStorable.TYPE.DIRECT);
                if (hTTPProxy.getLocalIP() != null) {
                    String string = hTTPProxy.getLocalIP().getHostAddress();
                    hTTPProxyStorable.setAddress(string);
                    break;
                }
                hTTPProxyStorable.setAddress(null);
                break;
            }
            case HTTP: {
                hTTPProxyStorable.setType(HTTPProxyStorable.TYPE.HTTP);
                hTTPProxyStorable.setAddress(hTTPProxy.getHost());
                break;
            }
            case SOCKS4: {
                hTTPProxyStorable.setType(HTTPProxyStorable.TYPE.SOCKS4);
                hTTPProxyStorable.setAddress(hTTPProxy.getHost());
                break;
            }
            case SOCKS5: {
                hTTPProxyStorable.setType(HTTPProxyStorable.TYPE.SOCKS5);
                hTTPProxyStorable.setAddress(hTTPProxy.getHost());
            }
        }
        hTTPProxyStorable.setPort(hTTPProxy.getPort());
        hTTPProxyStorable.setPassword(hTTPProxy.getPass());
        hTTPProxyStorable.setUsername(hTTPProxy.getUser());
        return hTTPProxyStorable;
    }

    public static HTTPProxy parseHTTPProxy(String string) {
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        String string2 = new Regex(string, "(https?|socks5|socks4)://").getMatch(0);
        String string3 = new Regex(string, "://(.*?)@").getMatch(0);
        String string4 = new Regex(string, "://.*?@?(.*?)(/|$)").getMatch(0);
        HTTPProxy hTTPProxy = null;
        if ("http".equalsIgnoreCase(string2) || "https".equalsIgnoreCase(string2)) {
            hTTPProxy = new HTTPProxy(TYPE.HTTP);
            hTTPProxy.port = 8080;
        } else if ("socks5".equalsIgnoreCase(string2)) {
            hTTPProxy = new HTTPProxy(TYPE.SOCKS5);
            hTTPProxy.port = 1080;
        } else if ("socks4".equalsIgnoreCase(string2)) {
            hTTPProxy = new HTTPProxy(TYPE.SOCKS4);
            hTTPProxy.port = 1080;
        }
        if (hTTPProxy != null) {
            String string5 = new Regex(string4, "(.*?)(:|$)").getMatch(0);
            String string6 = new Regex(string4, ".*?:(\\d+)").getMatch(0);
            if (!StringUtils.isEmpty(string5)) {
                hTTPProxy.host = string5;
            }
            if (!StringUtils.isEmpty(string6) && hTTPProxy != null) {
                hTTPProxy.port = Integer.parseInt(string6);
            }
            String string7 = new Regex(string3, "(.*?)(:|$)").getMatch(0);
            String string8 = new Regex(string3, ".*?:(.+)").getMatch(0);
            if (!StringUtils.isEmpty(string7)) {
                hTTPProxy.user = string7;
            }
            if (!StringUtils.isEmpty(string8)) {
                hTTPProxy.pass = string8;
            }
            if (!StringUtils.isEmpty(hTTPProxy.host)) {
                return hTTPProxy;
            }
        }
        return null;
    }

    protected HTTPProxy() {
    }

    public HTTPProxy(InetAddress inetAddress) {
        this.type = TYPE.DIRECT;
        this.localIP = inetAddress;
    }

    public HTTPProxy(TYPE tYPE) {
        this.type = tYPE;
    }

    public HTTPProxy(TYPE tYPE, String string, int n) {
        this.port = n;
        this.type = tYPE;
        this.host = HTTPProxy.getInfo(string, "" + n)[0];
    }

    protected void cloneProxy(HTTPProxy hTTPProxy) {
        if (hTTPProxy == null) {
            return;
        }
        this.user = hTTPProxy.user;
        this.host = hTTPProxy.host;
        this.localIP = hTTPProxy.localIP;
        this.pass = hTTPProxy.pass;
        this.port = hTTPProxy.port;
        this.type = hTTPProxy.type;
        this.localIP = hTTPProxy.localIP;
    }

    public String getHost() {
        return this.host;
    }

    public InetAddress getLocalIP() {
        return this.localIP;
    }

    public String getPass() {
        return this.pass;
    }

    public int getPort() {
        return this.port;
    }

    public TYPE getType() {
        return this.type;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isDirect() {
        return this.type == TYPE.DIRECT;
    }

    public boolean isLocal() {
        return this.isDirect() || this.isNone();
    }

    public boolean isNone() {
        return this.type == TYPE.NONE;
    }

    public boolean isRemote() {
        return !this.isDirect() && !this.isNone();
    }

    public boolean sameProxy(HTTPProxy hTTPProxy) {
        if (hTTPProxy == null) {
            return false;
        }
        if (this == hTTPProxy) {
            return true;
        }
        if (!hTTPProxy.getType().equals((Object)this.type)) {
            return false;
        }
        if (hTTPProxy.getType().equals((Object)TYPE.DIRECT)) {
            return hTTPProxy.getLocalIP().equals(this.localIP);
        }
        if (!hTTPProxy.getHost().equalsIgnoreCase(this.host)) {
            return false;
        }
        if (!hTTPProxy.getPass().equalsIgnoreCase(this.pass)) {
            return false;
        }
        if (!hTTPProxy.getUser().equalsIgnoreCase(this.user)) {
            return false;
        }
        return hTTPProxy.getPort() == this.port;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setLocalIP(InetAddress inetAddress) {
        this.localIP = inetAddress;
    }

    public void setPass(String string) {
        this.pass = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setType(TYPE tYPE) {
        this.type = tYPE;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String toString() {
        if (this.type == TYPE.NONE) {
            return _AWU.T.proxy_none();
        }
        if (this.type == TYPE.DIRECT) {
            return _AWU.T.proxy_direct(this.localIP.getHostAddress());
        }
        if (this.type == TYPE.HTTP) {
            return _AWU.T.proxy_http(this.getHost(), this.getPort());
        }
        if (this.type == TYPE.SOCKS5) {
            return _AWU.T.proxy_socks5(this.getHost(), this.getPort());
        }
        if (this.type == TYPE.SOCKS4) {
            return _AWU.T.proxy_socks4(this.getHost(), this.getPort());
        }
        return "UNKNOWN";
    }

    public static enum TYPE {
        NONE,
        DIRECT,
        SOCKS4,
        SOCKS5,
        HTTP;

    }
}

