/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.util.ArrayList;
import java.util.Iterator;
import org.appwork.utils.event.BasicEvent;
import org.appwork.utils.event.BasicEventSender;
import org.appwork.utils.logging.Log;

public class ConnectionLimiter {
    private static final Object LOCK = new Object();
    public static final int CONNECTION_OPENED = 0;
    public static final int CONNECTION_CLOSED = 1;
    public static final int WAIT_DUETO_MAXSIMULTAN_LIMIT_END = 2;
    public static final int WAIT_DUETO_MAXSIMULTAN_LIMIT_START = 3;
    public static final int WAIT_DUETO_CONNECTIONSPERMINUTE_LIMIT_START = 4;
    public static final int WAIT_DUETO_CONNECTIONSPERMINUTE_LIMIT_END = 5;
    private int connectioncount;
    private final ArrayList<Long> list = new ArrayList();
    private int maxConcurrent = -1;
    private int timeConnections = -1;
    private long timeTime = -1L;
    private final BasicEventSender<Long> eventSender = new BasicEventSender();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closedConnection() {
        Object object = LOCK;
        synchronized (object) {
            --this.connectioncount;
        }
        this.eventSender.fireEvent(new BasicEvent<Object>((Object)this, 1, null, null));
    }

    public long[] getConnectionTimeLimit() {
        return new long[]{this.timeConnections, this.timeTime};
    }

    public BasicEventSender<Long> getEventSender() {
        return this.eventSender;
    }

    public int getMaxConcurrent() {
        return this.maxConcurrent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void openedConnection() throws InterruptedException {
        boolean bl;
        if (this.maxConcurrent > 0) {
            bl = false;
            long l = -1L;
            while (true) {
                Object object = LOCK;
                synchronized (object) {
                    if (this.connectioncount < this.maxConcurrent) {
                        if (bl) {
                            this.eventSender.fireEvent(new BasicEvent<Long>((Object)this, 2, System.currentTimeMillis() - l, null));
                        }
                        break;
                    }
                }
                if (l < 0L) {
                    l = System.currentTimeMillis();
                }
                Log.L.warning("block 250 ms for " + this.maxConcurrent + " connectionlimit");
                this.eventSender.fireEvent(new BasicEvent<Long>((Object)this, 3, System.currentTimeMillis() - l, null));
                bl = true;
                Thread.sleep(250L);
            }
        }
        bl = false;
        if (this.timeConnections > 0) {
            while (true) {
                Iterator<Long> iterator = this.list.iterator();
                while (iterator.hasNext() && iterator.next() + this.timeTime < System.currentTimeMillis()) {
                    iterator.remove();
                }
                if (this.list.size() < this.timeConnections) break;
                long l = this.timeConnections;
                if (iterator.hasNext()) {
                    l = Math.max(250L, iterator.next() - (System.currentTimeMillis() - this.timeTime));
                }
                bl = true;
                Log.L.warning("wait " + l + " ms because we got " + this.list.size() + " connections the last minute");
                this.eventSender.fireEvent(new BasicEvent<Long>((Object)this, 4, l, null));
                Thread.sleep(l);
            }
            this.list.add(System.currentTimeMillis());
        }
        Object object = LOCK;
        synchronized (object) {
            ++this.connectioncount;
        }
        if (bl) {
            this.eventSender.fireEvent(new BasicEvent<Object>((Object)this, 5, null, null));
        }
        this.eventSender.fireEvent(new BasicEvent<Object>((Object)this, 0, null, null));
    }

    public synchronized void setConnectionTimeLimit(int n, long l) {
        if (n > 0 && l > 0L) {
            this.timeConnections = n;
            this.timeTime = l;
        } else {
            this.timeConnections = -1;
            this.timeTime = -1L;
        }
    }

    public synchronized void setMaxConcurrent(int n) {
        if (n <= 0) {
            n = -1;
        }
        this.maxConcurrent = n;
    }
}

